/*
 * Decompiled with CFR 0.152.
 */
package com.brunchboy.util.swing.relativelayout;

import com.brunchboy.util.swing.relativelayout.Attribute;
import com.brunchboy.util.swing.relativelayout.AttributeSource;
import com.brunchboy.util.swing.relativelayout.AttributeType;
import com.brunchboy.util.swing.relativelayout.Constraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;

public class AttributeConstraint
implements Constraint {
    public static final String VERSION = "$Id: AttributeConstraint.java,v 1.2 2002/08/16 03:08:18 jim Exp $";
    protected final String anchorList;
    private final AttributeType attribute;
    private final int offset;
    private final List dependencies;

    public AttributeConstraint(String anchorList, AttributeType attribute, int offset) {
        this.anchorList = anchorList;
        this.attribute = attribute;
        this.offset = offset;
        ArrayList<Attribute> deps = new ArrayList<Attribute>();
        StringTokenizer st = new StringTokenizer(anchorList, ",");
        while (st.hasMoreTokens()) {
            String anchor = st.nextToken().trim();
            deps.add(new Attribute(anchor, attribute));
        }
        this.dependencies = Collections.unmodifiableList(deps);
    }

    public AttributeConstraint(String anchorList, AttributeType attribute) {
        this(anchorList, attribute, 0);
    }

    public List getDependencies() {
        return this.dependencies;
    }

    public int getValue(AttributeSource attributes) {
        long tally = 0L;
        if (this.attribute == AttributeType.BOTTOM || this.attribute == AttributeType.RIGHT || this.attribute == AttributeType.WIDTH || this.attribute == AttributeType.HEIGHT) {
            tally = Integer.MIN_VALUE;
        } else if (this.attribute == AttributeType.TOP || this.attribute == AttributeType.LEFT) {
            tally = Integer.MAX_VALUE;
        }
        ListIterator iter = this.dependencies.listIterator();
        while (iter.hasNext()) {
            Attribute anchorAttr = (Attribute)iter.next();
            int curValue = attributes.getValue(anchorAttr);
            if (this.attribute == AttributeType.BOTTOM || this.attribute == AttributeType.RIGHT || this.attribute == AttributeType.WIDTH || this.attribute == AttributeType.HEIGHT) {
                tally = Math.max(tally, (long)curValue);
                continue;
            }
            if (this.attribute == AttributeType.TOP || this.attribute == AttributeType.LEFT) {
                tally = Math.min(tally, (long)curValue);
                continue;
            }
            tally += (long)curValue;
        }
        if (this.attribute == AttributeType.HORIZONTAL_CENTER || this.attribute == AttributeType.VERTICAL_CENTER) {
            tally /= (long)this.dependencies.size();
        }
        return (int)tally + this.offset;
    }

    public String toString() {
        return "AttributeConstraint: {anchors=" + this.anchorList + "; attribute=" + this.attribute + "; offset=" + this.offset + '}';
    }
}

