/*
 * Decompiled with CFR 0.152.
 */
package com.brunchboy.util.swing.relativelayout;

import com.brunchboy.util.swing.relativelayout.Attribute;
import com.brunchboy.util.swing.relativelayout.AttributeAxis;
import com.brunchboy.util.swing.relativelayout.AttributeSource;
import com.brunchboy.util.swing.relativelayout.AttributeType;
import com.brunchboy.util.swing.relativelayout.Constraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AxisConstraint
implements Constraint {
    public static final String VERSION = "$Id: AxisConstraint.java,v 1.1.1.1 2002/05/13 20:51:44 jim Exp $";
    protected final String anchorName;
    private final AttributeAxis axis;
    private final double fraction;
    private final List dependencies;
    private final Attribute origin;
    private final Attribute length;

    public AxisConstraint(String anchorName, AttributeAxis axis, double position) {
        this.anchorName = anchorName;
        this.axis = axis;
        this.fraction = position;
        if (axis == AttributeAxis.HORIZONTAL) {
            this.origin = new Attribute(anchorName, AttributeType.LEFT);
            this.length = new Attribute(anchorName, AttributeType.WIDTH);
        } else {
            this.origin = new Attribute(anchorName, AttributeType.TOP);
            this.length = new Attribute(anchorName, AttributeType.HEIGHT);
        }
        ArrayList<Attribute> deps = new ArrayList<Attribute>(2);
        deps.add(this.origin);
        deps.add(this.length);
        this.dependencies = Collections.unmodifiableList(deps);
    }

    public List getDependencies() {
        return this.dependencies;
    }

    public int getValue(AttributeSource attributes) {
        return attributes.getValue(this.origin) + (int)(this.fraction * (double)attributes.getValue(this.length));
    }

    public String toString() {
        return "AxisConstraint: {anchor=" + this.anchorName + ", axis=" + this.axis + ", fraction=" + this.fraction + '}';
    }
}

