/*
 * Decompiled with CFR 0.152.
 */
package com.brunchboy.util.swing.relativelayout;

import com.brunchboy.util.swing.relativelayout.Attribute;
import com.brunchboy.util.swing.relativelayout.AttributeAxis;
import com.brunchboy.util.swing.relativelayout.AttributeSource;
import com.brunchboy.util.swing.relativelayout.AttributeType;
import com.brunchboy.util.swing.relativelayout.Constraint;
import com.brunchboy.util.swing.relativelayout.DependencyManager;
import java.awt.Component;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;

public class ComponentSpecifications {
    public static final String VERSION = "$Id: ComponentSpecifications.java,v 1.2 2002/05/20 23:17:13 jim Exp $";
    private final String componentName;
    private Component component;
    private Map constraints = new HashMap();
    private Map values = new HashMap();
    private static final Integer ZERO = new Integer(0);

    public String getComponentName() {
        return this.componentName;
    }

    public void setComponent(Component component) {
        if (this.component != null) {
            throw new IllegalStateException(this.componentName + ": component was already set");
        }
        this.component = component;
    }

    public Component getComponent() {
        return this.component;
    }

    public int getAttributeValue(AttributeType type) {
        Integer value = (Integer)this.values.get(type);
        if (value == null) {
            throw new IllegalStateException(this.componentName + ": " + type + " not yet resolved");
        }
        return value;
    }

    public boolean hasConstraint(AttributeType type) {
        return this.constraints.containsKey(type);
    }

    public int getComponentWidth(boolean minimumSize) {
        if (this.component != null) {
            if (minimumSize) {
                return this.component.getMinimumSize().width;
            }
            return this.component.getPreferredSize().width;
        }
        return 0;
    }

    public int getComponentHeight(boolean minimumSize) {
        if (this.component != null) {
            if (minimumSize) {
                return this.component.getMinimumSize().height;
            }
            return this.component.getPreferredSize().height;
        }
        return 0;
    }

    public void setAttributeValue(AttributeType type, int value) {
        if (this.values.containsKey(type)) {
            throw new IllegalStateException(this.componentName + ": " + type + "resolved more than once");
        }
        if (value == 0) {
            this.values.put(type, ZERO);
        } else {
            this.values.put(type, new Integer(value));
        }
    }

    public void clearAttributeValues() {
        this.values.clear();
    }

    public ComponentSpecifications(String componentName) {
        this(componentName, null);
    }

    public ComponentSpecifications(String componentName, Component component) {
        this.componentName = componentName;
        this.component = component;
    }

    public void addConstraint(AttributeType type, Constraint constraint) {
        if (type == null) {
            throw new NullPointerException("type must not be null");
        }
        if (constraint == null) {
            throw new NullPointerException("constraint must not be null");
        }
        HashSet relevantConstraints = new HashSet(this.constraints.keySet());
        relevantConstraints.retainAll(AttributeType.getAxisTypes(type.getAxis()));
        if (relevantConstraints.contains(type)) {
            throw new IllegalStateException(this.componentName + ": " + type + " is already constrained");
        }
        if (relevantConstraints.size() > 1) {
            throw new IllegalStateException(this.componentName + ": Cannot add " + type + " constraint without overconstraining");
        }
        this.constraints.put(type, constraint);
    }

    private void validateConstraints() {
        HashSet axisConstraints = new HashSet(this.constraints.keySet());
        axisConstraints.retainAll(AttributeType.getAxisTypes(AttributeAxis.HORIZONTAL));
        if (axisConstraints.size() < 1 || axisConstraints.size() == 1 && axisConstraints.contains(AttributeType.WIDTH)) {
            throw new IllegalStateException(this.componentName + " is underconstrained horizontally");
        }
        axisConstraints = new HashSet(this.constraints.keySet());
        axisConstraints.retainAll(AttributeType.getAxisTypes(AttributeAxis.VERTICAL));
        if (axisConstraints.size() < 1 || axisConstraints.size() == 1 && axisConstraints.contains(AttributeType.HEIGHT)) {
            throw new IllegalStateException(this.componentName + " is underconstrained vertically");
        }
    }

    public void reportDependencies(DependencyManager dependencies) {
        this.validateConstraints();
        Iterator iter = this.constraints.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Attribute dependent = new Attribute(this.componentName, (AttributeType)entry.getKey());
            Constraint constraint = (Constraint)entry.getValue();
            ListIterator catts = constraint.getDependencies().listIterator();
            while (catts.hasNext()) {
                dependencies.add(dependent, (Attribute)catts.next());
            }
        }
        HashSet others = new HashSet(AttributeType.getAllTypes());
        others.removeAll(this.constraints.keySet());
        Iterator iter2 = others.iterator();
        while (iter2.hasNext()) {
            AttributeType unconstrained = (AttributeType)iter2.next();
            Attribute derived = new Attribute(this.componentName, unconstrained);
            HashSet relevantConstraints = new HashSet(this.constraints.keySet());
            relevantConstraints.retainAll(AttributeType.getAxisTypes(unconstrained.getAxis()));
            Iterator iter22 = relevantConstraints.iterator();
            while (iter22.hasNext()) {
                dependencies.add(derived, new Attribute(this.componentName, (AttributeType)iter22.next()));
            }
        }
    }

    public void computeAttribute(AttributeType attribute, AttributeSource allAttrs, boolean minimumSize, int parentWidth, int parentHeight) {
        if (this.constraints.containsKey(attribute)) {
            Constraint constraint = (Constraint)this.constraints.get(attribute);
            this.setAttributeValue(attribute, constraint.getValue(allAttrs));
        } else {
            this.setAttributeValue(attribute, attribute.deriveValue(this, minimumSize));
        }
    }

    public void layoutComponent(int xOffset, int yOffset) {
        if (this.component != null) {
            this.component.setBounds(this.getAttributeValue(AttributeType.LEFT) + xOffset, this.getAttributeValue(AttributeType.TOP) + yOffset, this.getAttributeValue(AttributeType.WIDTH), this.getAttributeValue(AttributeType.HEIGHT));
        }
    }

    void setContainerSpecs(int width, int height) {
        this.setAttributeValue(AttributeType.LEFT, 0);
        this.setAttributeValue(AttributeType.TOP, 0);
        this.setAttributeValue(AttributeType.RIGHT, width);
        this.setAttributeValue(AttributeType.WIDTH, width);
        this.setAttributeValue(AttributeType.BOTTOM, height);
        this.setAttributeValue(AttributeType.HEIGHT, height);
        this.setAttributeValue(AttributeType.HORIZONTAL_CENTER, width / 2);
        this.setAttributeValue(AttributeType.VERTICAL_CENTER, height / 2);
    }
}

