/*
 * Decompiled with CFR 0.152.
 */
package com.brunchboy.util.swing.relativelayout;

import com.brunchboy.util.swing.relativelayout.Attribute;
import com.brunchboy.util.swing.relativelayout.AttributeSource;
import com.brunchboy.util.swing.relativelayout.AttributeType;
import com.brunchboy.util.swing.relativelayout.ComponentSpecifications;
import com.brunchboy.util.swing.relativelayout.Constraint;
import com.brunchboy.util.swing.relativelayout.DependencyManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;

public class RelativeLayout
implements LayoutManager2 {
    public static final String VERSION = "$Id: RelativeLayout.java,v 1.3 2002/08/15 00:34:38 jim Exp $";
    private Map componentSpecs = new HashMap();
    private Map specsByAWTComponent = new HashMap();
    private DependencyManager dependencies;
    private final AttributeSource attributeSource = new AttributeSource(){

        public int getValue(Attribute attribute) {
            ComponentSpecifications anchor = (ComponentSpecifications)RelativeLayout.this.componentSpecs.get(attribute.getComponent());
            if (anchor == null) {
                throw new IllegalStateException("Need attribute of unknown component " + attribute.getComponent());
            }
            return anchor.getAttributeValue(attribute.getType());
        }
    };

    private ComponentSpecifications getComponentSpecifications(String name) {
        if (name == null) {
            throw new NullPointerException("Component name cannot be null");
        }
        ComponentSpecifications results = (ComponentSpecifications)this.componentSpecs.get(name);
        if (results == null) {
            results = new ComponentSpecifications(name);
            this.componentSpecs.put(name, results);
        }
        return results;
    }

    private void validateComponentName(String name) {
        if ("_container".equals(name)) {
            throw new IllegalArgumentException("The name _container is reserved");
        }
    }

    public void addLayoutComponent(String name, Component component) {
        this.validateComponentName(name);
        if (this.specsByAWTComponent.get(component) != null) {
            throw new IllegalStateException("Component " + component + " is already in the layout");
        }
        if (!name.equals(component.getName())) {
            component.setName(name);
        }
        ComponentSpecifications specs = this.getComponentSpecifications(name);
        specs.setComponent(component);
        this.specsByAWTComponent.put(component, specs);
        this.dependencies = null;
    }

    public void addLayoutComponent(Component component, Object constraints) {
        if (constraints instanceof String) {
            this.addLayoutComponent((String)constraints, component);
            return;
        }
        throw new IllegalArgumentException("Unrecognizable constraints");
    }

    public void addConstraint(String componentName, AttributeType type, Constraint constraint) {
        this.validateComponentName(componentName);
        this.getComponentSpecifications(componentName).addConstraint(type, constraint);
        this.dependencies = null;
    }

    private void resolveContainerSpecs(int width, int height) {
        this.getComponentSpecifications("_container").setContainerSpecs(width, height);
    }

    private void resolveComponents(boolean minimumSize, int parentWidth, int parentHeight) {
        boolean needDependencies = false;
        if (this.dependencies == null) {
            this.dependencies = new DependencyManager();
            needDependencies = true;
        }
        Iterator iter = this.componentSpecs.values().iterator();
        while (iter.hasNext()) {
            ComponentSpecifications spec = (ComponentSpecifications)iter.next();
            spec.clearAttributeValues();
            if (!needDependencies || spec.getComponentName() == "_container") continue;
            spec.reportDependencies(this.dependencies);
        }
        this.resolveContainerSpecs(parentWidth, parentHeight);
        ListIterator iter2 = this.dependencies.sort().listIterator();
        while (iter2.hasNext()) {
            Attribute attribute = (Attribute)iter2.next();
            ComponentSpecifications spec = this.getComponentSpecifications(attribute.getComponent());
            spec.computeAttribute(attribute.getType(), this.attributeSource, minimumSize, parentWidth, parentHeight);
        }
    }

    public void layoutContainer(Container parent) {
        Insets insets = parent.getInsets();
        int width = parent.getSize().width - insets.left - insets.right;
        int height = parent.getSize().height - insets.top - insets.bottom;
        this.resolveComponents(false, width, height);
        Iterator iter = this.componentSpecs.values().iterator();
        while (iter.hasNext()) {
            ComponentSpecifications spec = (ComponentSpecifications)iter.next();
            spec.layoutComponent(insets.left, insets.top);
        }
    }

    public void removeLayoutComponent(Component component) {
        ComponentSpecifications specs = (ComponentSpecifications)this.specsByAWTComponent.get(component);
        if (specs != null) {
            this.specsByAWTComponent.remove(component);
            this.componentSpecs.remove(specs.getComponentName());
            this.dependencies = null;
        }
    }

    private Dimension calculateBoundingBox() {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        Iterator iter = this.componentSpecs.values().iterator();
        while (iter.hasNext()) {
            ComponentSpecifications spec = (ComponentSpecifications)iter.next();
            minX = Math.min(minX, spec.getAttributeValue(AttributeType.LEFT));
            minY = Math.min(minY, spec.getAttributeValue(AttributeType.TOP));
            maxX = Math.max(maxX, spec.getAttributeValue(AttributeType.RIGHT));
            maxY = Math.max(maxY, spec.getAttributeValue(AttributeType.BOTTOM));
        }
        return new Dimension(maxX - minX, maxY - minY);
    }

    private Dimension addInsets(Dimension spaceNeeded, Container parent) {
        Insets insets = parent.getInsets();
        return new Dimension(spaceNeeded.width + insets.left + insets.right, spaceNeeded.height + insets.top + insets.bottom);
    }

    public Dimension preferredLayoutSize(Container parent) {
        this.resolveComponents(false, 0, 0);
        return this.addInsets(this.calculateBoundingBox(), parent);
    }

    public Dimension minimumLayoutSize(Container parent) {
        this.resolveComponents(true, 0, 0);
        return this.addInsets(this.calculateBoundingBox(), parent);
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }
}

