/*
 * Decompiled with CFR 0.152.
 */
package com.brunchboy.util.swing.relativelayout;

import com.brunchboy.util.swing.relativelayout.AttributeAxis;
import com.brunchboy.util.swing.relativelayout.AttributeConstraint;
import com.brunchboy.util.swing.relativelayout.AttributeType;
import com.brunchboy.util.swing.relativelayout.AxisConstraint;
import com.brunchboy.util.swing.relativelayout.RelativeLayout;
import java.io.File;
import java.io.IOException;
import java.util.ListIterator;
import org.jdom.DataConversionException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlConstraintBuilder {
    public static final String VERSION = "$Id: XmlConstraintBuilder.java,v 1.2 2002/08/16 05:13:04 jim Exp $";
    private final SAXBuilder builder = new SAXBuilder(true);
    public static final String CONSTRAINT_SET_DTD_PUBLIC = "-//Brunch Boy Design//RelativeLayout Constraint Set DTD 1.0//EN";
    public static final String CONSTRAINT_SET_DTD_SYSTEM = "constraint-set.dtd";

    public XmlConstraintBuilder() {
        this.builder.setEntityResolver((EntityResolver)new DtdResolver());
    }

    private String getReferences(Element target) {
        StringBuffer result = new StringBuffer();
        if (target.getAttributeValue("reference") != null) {
            result.append(target.getAttributeValue("reference"));
        }
        ListIterator references = target.getChildren("reference").listIterator();
        while (references.hasNext()) {
            if (result.length() > 0) {
                result.append(',');
            }
            result.append(((Element)references.next()).getAttributeValue("name"));
        }
        return result.toString();
    }

    protected void addComponentConstraint(String component, Element constraint, RelativeLayout layout) throws DataConversionException, ParseException {
        AttributeType type = AttributeType.getInstance(constraint.getName());
        Element target = (Element)constraint.getChildren().get(0);
        if (target.getName().equals("toAttribute")) {
            int offset = 0;
            if (target.getAttribute("offset") != null) {
                offset = target.getAttribute("offset").getIntValue();
            }
            AttributeType targetAttribute = AttributeType.getInstance(target.getAttributeValue("attribute"));
            layout.addConstraint(component, type, new AttributeConstraint(this.getReferences(target), targetAttribute, offset));
        } else if (target.getName().equals("toAxis")) {
            layout.addConstraint(component, type, new AxisConstraint(target.getAttributeValue("reference"), AttributeAxis.getInstance(target.getAttributeValue("axis")), target.getAttribute("fraction").getDoubleValue()));
        } else {
            throw new ParseException("Unrecognized constraint type: " + target.getName(), null);
        }
    }

    protected void addConstraints(Document document, RelativeLayout layout) throws DataConversionException, ParseException {
        ListIterator components = document.getRootElement().getChildren("constrain").listIterator();
        while (components.hasNext()) {
            Element component = (Element)components.next();
            ListIterator constraints = component.getChildren().listIterator();
            while (constraints.hasNext()) {
                this.addComponentConstraint(component.getAttributeValue("name"), (Element)constraints.next(), layout);
            }
        }
    }

    public void addConstraints(File file, RelativeLayout layout) throws ParseException {
        try {
            this.addConstraints(this.builder.build(file), layout);
        }
        catch (Exception e) {
            throw new ParseException("Problem parsing " + file + ": " + e, e);
        }
    }

    public static class ParseException
    extends Exception {
        protected Throwable cause;

        public ParseException(String message, Throwable cause) {
            super(message);
            this.cause = cause;
        }

        public Throwable getCause() {
            return this.cause;
        }
    }

    private static class DtdResolver
    implements EntityResolver {
        private DtdResolver() {
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (XmlConstraintBuilder.CONSTRAINT_SET_DTD_PUBLIC.equals(publicId)) {
                InputSource ourDtd = new InputSource(this.getClass().getResourceAsStream(XmlConstraintBuilder.CONSTRAINT_SET_DTD_SYSTEM));
                ourDtd.setPublicId(publicId);
                ourDtd.setSystemId(XmlConstraintBuilder.CONSTRAINT_SET_DTD_SYSTEM);
                return ourDtd;
            }
            return null;
        }
    }
}

