/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ClientGui;
import client.DSModel;
import client.SwingWorkerII;
import com.brunchboy.util.swing.relativelayout.AttributeAxis;
import com.brunchboy.util.swing.relativelayout.AttributeConstraint;
import com.brunchboy.util.swing.relativelayout.AttributeType;
import com.brunchboy.util.swing.relativelayout.AxisConstraint;
import com.brunchboy.util.swing.relativelayout.RelativeLayout;
import common.Constants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public abstract class AsyncOperationGui
extends SwingWorkerII
implements Constants {
    private Vector taskList;
    private String title;
    private Frame owner;
    private Timer t1;
    private JDialog dialog;
    private JLabel[] checks;
    private JLabel[] labels;
    private JButton cancelButton;
    private Border okBorder;
    private JLabel emptyIcon;
    private JLabel statusIcon;
    private JLabel status1;
    private JLabel status2;
    private int currentTask = 0;
    private boolean blink = false;
    private boolean operationCompleted = false;
    private boolean operationSuccess = false;
    private boolean operationFailed = false;
    private boolean operationCancelled = false;
    private boolean pervasive = true;

    public AsyncOperationGui(String title, Frame owner) {
        this.title = title;
        this.owner = owner;
    }

    public AsyncOperationGui(String title, Frame owner, boolean pervasive) {
        this.title = title;
        this.owner = owner;
        this.pervasive = false;
    }

    protected void init(Vector tasks) {
        this.taskList = tasks;
        this.dialog = new JDialog(this.owner, "Blood Pit Client " + this.title, true);
        JPanel cp = new JPanel(new BorderLayout());
        Border b0 = BorderFactory.createEmptyBorder(5, 5, 10, 5);
        cp.setBorder(b0);
        this.dialog.setContentPane(cp);
        this.dialog.setLocation(DSModel.instance().getOperationLocation());
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (AsyncOperationGui.this.operationCompleted) {
                    AsyncOperationGui.this.operationCompletedEvent();
                } else {
                    AsyncOperationGui.this.interrupt();
                    AsyncOperationGui.this.operationCancelled = true;
                    AsyncOperationGui.this.operationCompletedEvent();
                }
                AsyncOperationGui.this.display(false);
            }
        });
        RelativeLayout taskLayout = new RelativeLayout();
        JPanel taskPanel = new JPanel(taskLayout);
        Border b1 = BorderFactory.createEtchedBorder();
        TitledBorder tb = BorderFactory.createTitledBorder(b1, this.title + " Tasks");
        Border b2 = BorderFactory.createEmptyBorder(5, 5, 15, 16);
        CompoundBorder b3 = BorderFactory.createCompoundBorder(tb, b2);
        tb.setTitlePosition(1);
        tb.setTitleJustification(2);
        taskPanel.setBorder(b3);
        cp.add((Component)taskPanel, "Center");
        String prevComp = "";
        this.checks = new JLabel[this.taskList.size()];
        this.labels = new JLabel[this.taskList.size()];
        for (int i = 0; i < this.taskList.size(); ++i) {
            this.checks[i] = new JLabel(ClientGui.TASK_INCOMPLETE_ICON);
            this.labels[i] = new JLabel((String)this.taskList.get(i));
            this.labels[i].setEnabled(false);
            taskPanel.add((Component)this.checks[i], "checks" + i);
            taskPanel.add((Component)this.labels[i], "labels" + i);
            if (prevComp.equals("")) {
                taskLayout.addConstraint("checks" + i, AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 5));
                taskLayout.addConstraint("labels" + i, AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 5));
            } else {
                taskLayout.addConstraint("checks" + i, AttributeType.TOP, new AttributeConstraint(prevComp, AttributeType.BOTTOM, 5));
                taskLayout.addConstraint("labels" + i, AttributeType.TOP, new AttributeConstraint(prevComp, AttributeType.BOTTOM, 5));
            }
            taskLayout.addConstraint("checks" + i, AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 16));
            taskLayout.addConstraint("labels" + i, AttributeType.LEFT, new AttributeConstraint("checks" + i, AttributeType.RIGHT, 8));
            prevComp = "checks" + i;
        }
        this.statusIcon = new JLabel(ClientGui.TASK_BLANK_ICON);
        this.status1 = new JLabel("");
        this.status2 = new JLabel("");
        taskPanel.add((Component)this.statusIcon, "StatusIcon");
        taskPanel.add((Component)this.status1, "Status1");
        taskPanel.add((Component)this.status2, "Status2");
        taskLayout.addConstraint("StatusIcon", AttributeType.TOP, new AttributeConstraint("checks" + (this.taskList.size() - 1), AttributeType.BOTTOM, 18));
        taskLayout.addConstraint("Status1", AttributeType.TOP, new AttributeConstraint("checks" + (this.taskList.size() - 1), AttributeType.BOTTOM, 15));
        taskLayout.addConstraint("StatusIcon", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 17));
        taskLayout.addConstraint("Status1", AttributeType.LEFT, new AttributeConstraint("StatusIcon", AttributeType.RIGHT, 9));
        taskLayout.addConstraint("Status2", AttributeType.TOP, new AttributeConstraint("StatusIcon", AttributeType.BOTTOM, 5));
        taskLayout.addConstraint("Status2", AttributeType.LEFT, new AttributeConstraint("Status1", AttributeType.LEFT, 0));
        RelativeLayout buttonLayout = new RelativeLayout();
        JPanel buttonPanel = new JPanel(buttonLayout);
        cp.add((Component)buttonPanel, "South");
        this.cancelButton = new JButton("Cancel");
        buttonPanel.add((Component)this.cancelButton, "Cancel");
        Border outer = BorderFactory.createEtchedBorder();
        Border inner = BorderFactory.createEmptyBorder(3, 28, 3, 28);
        this.okBorder = BorderFactory.createCompoundBorder(outer, inner);
        buttonLayout.addConstraint("Cancel", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 10));
        buttonLayout.addConstraint("Cancel", AttributeType.HORIZONTAL_CENTER, new AxisConstraint("_container", AttributeAxis.HORIZONTAL, 0.5));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!AsyncOperationGui.this.operationCompleted) {
                    AsyncOperationGui.this.interrupt();
                    AsyncOperationGui.this.operationCancelled = true;
                }
                AsyncOperationGui.this.display(false);
                AsyncOperationGui.this.operationCompletedEvent();
            }
        });
    }

    public abstract void operationCompletedEvent();

    public void display(boolean flag) {
        if (flag) {
            this.dialog.pack();
            this.dialog.setVisible(flag);
        } else {
            this.dialog.dispose();
        }
    }

    public void startTasks() {
        Runnable startedTask = new Runnable(){

            public void run() {
                if (AsyncOperationGui.this.currentTask != 0) {
                    throw new RuntimeException("Start Task called out of sequence");
                }
                AsyncOperationGui.this.t1 = new Timer(500, new BlinkListener());
                AsyncOperationGui.this.t1.start();
            }
        };
        try {
            SwingUtilities.invokeLater(startedTask);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finishedTask() {
        Runnable finishedTask = new Runnable(){

            public void run() {
                if (AsyncOperationGui.this.currentTask >= AsyncOperationGui.this.taskList.size()) {
                    throw new RuntimeException("Finished Task called beyond list end ");
                }
                AsyncOperationGui.this.t1.restart();
                AsyncOperationGui.this.resetBlinker();
                AsyncOperationGui.this.checks[AsyncOperationGui.this.currentTask].setIcon(ClientGui.TASK_COMPLETE_ICON);
                AsyncOperationGui.this.currentTask++;
            }
        };
        try {
            SwingUtilities.invokeLater(finishedTask);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void operationSuccess() {
        Runnable completed = new Runnable(){

            public void run() {
                AsyncOperationGui.this.cancelButton.setText("OK");
                AsyncOperationGui.this.cancelButton.setBorder(AsyncOperationGui.this.okBorder);
                AsyncOperationGui.this.statusIcon.setIcon(ClientGui.SUCCESS_ICON);
                AsyncOperationGui.this.status1.setText("Completed Successfully");
                AsyncOperationGui.this.operationFailed = false;
                AsyncOperationGui.this.operationSuccess = true;
                AsyncOperationGui.this.operationCompleted = true;
                if (!AsyncOperationGui.this.pervasive) {
                    AsyncOperationGui.this.display(false);
                    AsyncOperationGui.this.operationCompletedEvent();
                }
            }
        };
        try {
            SwingUtilities.invokeLater(completed);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void operationFailure(final String line1, final String line2) {
        Runnable completed = new Runnable(){

            public void run() {
                AsyncOperationGui.this.cancelButton.setText("OK");
                AsyncOperationGui.this.cancelButton.setBorder(AsyncOperationGui.this.okBorder);
                AsyncOperationGui.this.statusIcon.setIcon(ClientGui.FAILURE_ICON);
                AsyncOperationGui.this.status1.setText(line1);
                AsyncOperationGui.this.status2.setText(line2);
                AsyncOperationGui.this.resetBlinker();
                AsyncOperationGui.this.operationFailed = true;
                AsyncOperationGui.this.operationSuccess = false;
                AsyncOperationGui.this.operationCompleted = true;
            }
        };
        try {
            SwingUtilities.invokeLater(completed);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean getOperationSuccess() {
        return this.operationSuccess;
    }

    public boolean getOperationFailed() {
        return this.operationFailed;
    }

    public boolean getOperationCancelled() {
        return this.operationCancelled;
    }

    private void taskBlinkToggle() {
        if (this.currentTask >= this.taskList.size() || this.operationSuccess || this.operationFailed || this.operationCancelled || this.hasFinished()) {
            this.t1.stop();
            return;
        }
        this.blink = !this.blink;
        this.labels[this.currentTask].setEnabled(this.blink);
    }

    private void resetBlinker() {
        this.labels[this.currentTask].setEnabled(true);
        this.blink = false;
    }

    class BlinkListener
    implements ActionListener {
        BlinkListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            AsyncOperationGui.this.taskBlinkToggle();
        }
    }
}

