/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.SwingWorkerII;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PushbackReader;
import javax.swing.text.JTextComponent;

public class BPAsyncXMLDocLoader
extends SwingWorkerII {
    JTextComponent titleObserver;
    JTextComponent bodyObserver;
    File xmlDoc;
    String title = "";
    String body = "";

    public BPAsyncXMLDocLoader(JTextComponent titleObserver, JTextComponent bodyObserver, File xmlDoc) {
        this.titleObserver = titleObserver;
        this.bodyObserver = bodyObserver;
        this.xmlDoc = xmlDoc;
    }

    public Object construct() {
        try {
            Token token;
            String next;
            PushbackReader in = new PushbackReader(new BufferedReader(new FileReader(this.xmlDoc)), 2);
            while ((next = this.tokenize(in)) != null && this.title == "") {
                token = new Token(next);
                if (token.tag_id != 3 || token.tag_pos != 1) continue;
                this.title = this.tokenize(in);
            }
            while ((next = this.tokenize(in)) != null && this.body == "") {
                token = new Token(next);
                if (token.type != 1) continue;
                this.body = next;
                break;
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void finished() {
        this.titleObserver.setText(this.title);
        this.bodyObserver.setText(this.body);
        this.bodyObserver.setCaretPosition(0);
    }

    private String tokenize(PushbackReader in) {
        StringBuffer token;
        block17: {
            char c = ' ';
            char[] pushback = new char[2];
            boolean isTag = false;
            boolean cdata = false;
            token = new StringBuffer();
            try {
                int j;
                int i;
                while ((i = in.read()) != -1) {
                    c = (char)i;
                    token.append(c);
                    if (Character.isWhitespace(c)) continue;
                }
                if (i == -1) {
                    return null;
                }
                if (c == '<') {
                    j = in.read();
                    if (j == 33) {
                        cdata = true;
                    } else {
                        cdata = false;
                        isTag = true;
                    }
                    token = new StringBuffer();
                    in.unread(j);
                    in.unread(i);
                } else {
                    isTag = false;
                    cdata = false;
                }
                if (isTag) {
                    while ((i = in.read()) != -1) {
                        c = (char)i;
                        token.append(c);
                        if (c != '>') continue;
                        break block17;
                    }
                    break block17;
                }
                if (cdata) {
                    in.skip(9L);
                    while ((i = in.read()) != -1) {
                        pushback[0] = c = (char)i;
                        if (c == ']') {
                            j = in.read();
                            pushback[1] = c = (char)j;
                            if (c == ']') {
                                in.skip(1L);
                                break block17;
                            }
                            in.unread(j);
                            c = (char)i;
                        }
                        token.append(c);
                    }
                    break block17;
                }
                while ((i = in.read()) != -1) {
                    pushback[0] = c = (char)i;
                    if (c == '<') {
                        j = in.read();
                        pushback[1] = c = (char)j;
                        if (Character.isJavaIdentifierStart(c) || c == '/') {
                            in.unread(pushback);
                            break;
                        }
                        in.unread(j);
                        c = (char)i;
                    }
                    token.append(c);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return token.toString();
    }

    class Token {
        public static final int TYPE_UNKNOWN = 1;
        public static final int TYPE_VALUE = 1;
        public static final int TYPE_TAG = 2;
        public static final int POS_UNKNOWN = 0;
        public static final int POS_OPEN = 1;
        public static final int POS_CLOSE = 2;
        public static final int ID_UNKNOWN = 1;
        public static final int XML = 2;
        public static final int TITLE = 3;
        public static final int BODY = 4;
        public static final int DOCUMENT = 5;
        public String value = "";
        public int type = 1;
        public int tag_pos = 0;
        public int tag_id = 1;

        public Token(String value) {
            this.value = value;
            if (value.startsWith("<")) {
                String name;
                this.type = 2;
                if (value.startsWith("</")) {
                    this.tag_pos = 2;
                    name = value.substring(2, value.length() - 1);
                } else {
                    this.tag_pos = 1;
                    name = value.substring(1, value.length() - 1);
                }
                if (name.startsWith("?xml")) {
                    this.tag_id = 2;
                } else if (name.startsWith("title")) {
                    this.tag_id = 3;
                } else if (name.startsWith("body")) {
                    this.tag_id = 4;
                } else if (name.startsWith("document")) {
                    this.tag_id = 5;
                }
            } else {
                this.type = 1;
            }
        }
    }
}

