/*
 * Decompiled with CFR 0.152.
 */
package client;

import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class BPEmailField
extends JTextField {
    private int maxLength;

    public BPEmailField(int columns, int maxLength) {
        super(columns);
        this.maxLength = maxLength;
        Border b1 = BorderFactory.createEmptyBorder(1, 2, 1, 2);
        Border b2 = BorderFactory.createLoweredBevelBorder();
        this.setBorder(BorderFactory.createCompoundBorder(b2, b1));
    }

    protected Document createDefaultModel() {
        return new BPTextDocument();
    }

    public void setEnabled(boolean enabled) {
        super.setEditable(enabled);
        if (enabled) {
            this.setBackground(Color.WHITE);
        } else {
            this.setBackground(Color.LIGHT_GRAY);
        }
    }

    class BPTextDocument
    extends PlainDocument {
        BPTextDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (this.getLength() < BPEmailField.this.maxLength && this.getLength() + str.length() <= BPEmailField.this.maxLength) {
                char[] source = str.toCharArray();
                char[] dest = new char[source.length];
                int j = 0;
                block3: for (int i = 0; i < source.length; ++i) {
                    switch (source[i]) {
                        case ' ': 
                        case ',': 
                        case '/': 
                        case '<': 
                        case '>': 
                        case '\\': 
                        case '{': 
                        case '|': 
                        case '}': {
                            continue block3;
                        }
                        default: {
                            dest[j++] = Character.toUpperCase(source[i]);
                        }
                    }
                }
                if (dest.length > 0 && dest[0] != '\u0000') {
                    super.insertString(offs, str, a);
                }
            }
        }
    }
}

