/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.AutoLoginProperties;
import client.ClientPreferences;
import client.ClientProperties;
import client.data.ArenaCOM;
import client.data.ManagerCOM;
import common.ArenaDescriptor;
import common.BPFileManager;
import common.FileNamingSchema;
import common.TeamDescriptor;
import common.WarriorDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ClientFileManager
extends BPFileManager {
    public static final String PLAYER_SAVE_FILE = "player.dat";
    public static final String LOGIN_PROPERTIES_SAVE_FILE = "login.properties";
    public static final String CLIENT_PROPERTIES_SAVE_FILE = "client.properties";
    public static final String RMI_PROPERTIES_SAVE_FILE = "rmi.properties";
    public static final String PREFERENCES_SAVE_FILE = "preferences.dat";
    public static final String PLAYER_COUNT_FILTER = "M[0-9]{4}";
    private static ClientProperties clientProperties = null;

    public static synchronized ClientProperties getClientProperties() {
        if (clientProperties == null) {
            clientProperties = ClientFileManager.loadClientProperties();
        }
        return clientProperties;
    }

    private ClientFileManager() {
    }

    public static synchronized Vector getLocalPlayerList(int arenaNumber) {
        Vector<Integer> playerList = new Vector<Integer>();
        Object[] playerDirs = new File[]{};
        File arenaDir = new File(FileNamingSchema.getArenaDirectoryName(arenaNumber));
        if (arenaDir.isDirectory() && arenaDir.canRead()) {
            playerDirs = arenaDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.matches(ClientFileManager.PLAYER_COUNT_FILTER);
                }
            });
        }
        Arrays.sort(playerDirs);
        for (int i = 0; i < playerDirs.length; ++i) {
            if (!((File)playerDirs[i]).isDirectory()) continue;
            playerList.add(Integer.valueOf(((File)playerDirs[i]).getName().substring(1)));
        }
        return playerList;
    }

    public static synchronized void saveAutoLoginProperties(Properties properties) {
        File outFile = new File(LOGIN_PROPERTIES_SAVE_FILE);
        try {
            GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(outFile));
            properties.store(os, null);
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized AutoLoginProperties loadAutoLoginProperties() {
        File inFile = new File(LOGIN_PROPERTIES_SAVE_FILE);
        AutoLoginProperties properties = new AutoLoginProperties();
        try {
            GZIPInputStream is = new GZIPInputStream(new FileInputStream(inFile));
            properties.load(is);
            ((InputStream)is).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    public static synchronized void saveClientProperties(Properties properties) {
        File outFile = new File(CLIENT_PROPERTIES_SAVE_FILE);
        try {
            FileOutputStream os = new FileOutputStream(outFile);
            properties.store(os, null);
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized ClientProperties loadClientProperties() {
        File inFile = new File(CLIENT_PROPERTIES_SAVE_FILE);
        ClientProperties properties = new ClientProperties();
        try {
            FileInputStream is = new FileInputStream(inFile);
            properties.load(is);
            ((InputStream)is).close();
        }
        catch (Exception e) {
            ClientFileManager.saveClientProperties(properties);
        }
        return properties;
    }

    public static synchronized void saveClientPreferences(ArenaCOM clientData, Properties preferences) {
        ManagerCOM manager = clientData.getManager();
        File playerDir = new File(FileNamingSchema.getFullPathname(manager));
        if (!playerDir.isDirectory()) {
            playerDir.mkdirs();
        }
        File outFile = new File(playerDir, PREFERENCES_SAVE_FILE);
        try {
            FileOutputStream os = new FileOutputStream(outFile);
            preferences.store(os, null);
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized ClientPreferences loadClientPreferences(ArenaCOM clientData) {
        ManagerCOM manager = clientData.getManager();
        File playerDir = new File(FileNamingSchema.getFullPathname(manager));
        File inFile = new File(playerDir, PREFERENCES_SAVE_FILE);
        ClientPreferences preferences = new ClientPreferences();
        try {
            FileInputStream is = new FileInputStream(inFile);
            preferences.load(is);
            ((InputStream)is).close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return preferences;
    }

    public static synchronized void savePlayerData(ArenaCOM clientData) throws Exception {
        ManagerCOM manager = clientData.getManager();
        String password = manager.getPassword();
        File playerDir = new File(FileNamingSchema.getFullPathname(manager));
        if (!playerDir.isDirectory()) {
            playerDir.mkdirs();
        }
        File outFile = new File(playerDir, PLAYER_SAVE_FILE);
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(outFile));
        oos.writeObject(password);
        oos.writeObject(clientData);
        oos.close();
    }

    public static synchronized ArenaCOM loadPlayerData(int arenaNumber, int managerNumber, String password) throws Exception {
        String playerDir = FileNamingSchema.getArenaDirectoryName(arenaNumber) + FileNamingSchema.getManagerDirectoryName(managerNumber);
        File inFile = new File(playerDir, PLAYER_SAVE_FILE);
        ObjectInputStream ois = new ObjectInputStream(new FileInputStream(inFile));
        String pwd = (String)ois.readObject();
        if (pwd.equals(password)) {
            ArenaCOM clientData = (ArenaCOM)ois.readObject();
            ois.close();
            return clientData;
        }
        ois.close();
        return null;
    }

    public static synchronized File[] getNewsletterList(final ArenaDescriptor arena) {
        Object[] newsfiles = new File[]{};
        File arenaDir = new File(FileNamingSchema.getFullPathname(arena));
        if (arenaDir.isDirectory() && arenaDir.canRead()) {
            newsfiles = arenaDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.matches(FileNamingSchema.getNewsletterFilter(arena));
                }
            });
        }
        Arrays.sort(newsfiles);
        return newsfiles;
    }

    public static synchronized File[] getFightList(final WarriorDescriptor warrior) {
        File[] singlesFights = new File[]{};
        File[] teamFights = new File[]{};
        TreeMap<String, File> map = new TreeMap<String, File>();
        File teamDir = new File(FileNamingSchema.getFullPathname(warrior));
        if (teamDir.isDirectory() && teamDir.canRead()) {
            singlesFights = teamDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.matches(FileNamingSchema.getFilenameFilter(warrior));
                }
            });
            for (int i = 0; i < singlesFights.length; ++i) {
                String key = FileNamingSchema.getTurnAndSeriesKey(singlesFights[i].getName());
                map.put(key, singlesFights[i]);
            }
            final TeamDescriptor team = (TeamDescriptor)warrior.getParent();
            teamFights = teamDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.matches(FileNamingSchema.getFilenameFilter(team));
                }
            });
            for (int i = 0; i < teamFights.length; ++i) {
                String key = FileNamingSchema.getTurnAndSeriesKey(teamFights[i].getName());
                if (map.containsKey(key)) continue;
                map.put(key, teamFights[i]);
            }
        }
        return map.values().toArray(new File[0]);
    }
}

