/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.DSModel;
import client.DownloadOperation;
import client.DownloadStatusEnum;
import client.LoadOperation;
import client.LoadStatusEnum;
import client.LoginGui;
import client.MainGui;
import client.data.ArenaCOM;
import common.Constants;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JWindow;
import javax.swing.Timer;
import javax.swing.UIManager;

public class ClientGui
extends JWindow
implements MainGui.Observer,
LoginGui.Observer,
DownloadOperation.Observer,
LoadOperation.Observer,
Constants {
    public static final String FULL_APPLICATION_NAME = "Blood Pit Client";
    public static final int ONE_SECOND = 1000;
    public static ImageIcon TASK_INCOMPLETE_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = ClientGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/task_incomplete.gif"));
    public static ImageIcon TASK_COMPLETE_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = ClientGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/task_complete.gif"));
    public static ImageIcon TASK_BLANK_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = ClientGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/task_blank.gif"));
    public static ImageIcon SUCCESS_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = ClientGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/indicator_success.gif"));
    public static ImageIcon FAILURE_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = ClientGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/indicator_failure.gif"));
    public static Font fixedWidthFont;
    public static Font f0b;
    public static Font f1b;
    public static Font f1p;
    private LoginGui loginGui = null;
    private MainGui mainGui = null;
    private LoadOperation loadOperation = null;
    private DownloadOperation download = null;
    private int accountNumber = -1;
    private String password = "";
    private ArenaCOM clientData = null;
    private Timer t1;
    static /* synthetic */ Class class$client$MainGui;
    static /* synthetic */ Class class$client$ClientGui;

    public ClientGui() {
        JComponent logoSplashTop = (JComponent)this.getContentPane();
        ImageIcon logoSplash = new ImageIcon((class$client$ClientGui == null ? (class$client$ClientGui = ClientGui.class$("client.ClientGui")) : class$client$ClientGui).getResource("images/logo.gif"));
        JLabel logoLabel = new JLabel(logoSplash);
        logoSplashTop.add(logoLabel);
        this.setLocation(DSModel.instance().getLogoLocation());
        this.display(true);
        Font defaultFont = UIManager.getFont("MenuBar.font");
        float fontSize = defaultFont.getSize();
        f0b = defaultFont.deriveFont(1, (float)((double)fontSize - 0.0));
        f1b = defaultFont.deriveFont(1, (float)((double)fontSize - 1.0));
        f1p = defaultFont.deriveFont(0, (float)((double)fontSize - 1.0));
        try {
            fixedWidthFont = new Font("Lucida Console", 0, DSModel.instance().getDefaultFontSize() + 1);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (fixedWidthFont == null) {
            fixedWidthFont = new Font("Monospaced", 0, DSModel.instance().getDefaultFontSize() + 1);
        }
        this.mainGui = new MainGui(this);
        this.mainGui.start();
        this.loginGui = new LoginGui(this);
    }

    public void initCompletedEvent(MainGui gui) {
        this.loginGui.display(true);
    }

    public void loginEvent(LoginGui gui) {
        gui.getFrame().setEnabled(false);
        this.accountNumber = gui.getAccountNumber();
        this.password = gui.getPassword();
        this.startLoadData();
    }

    public void startLoadData() {
        this.loadOperation = new LoadOperation(1, this.accountNumber, this.password, this);
        this.loadOperation.start();
    }

    public void operationCompletedEvent(LoadOperation operation) {
        LoadStatusEnum status = operation.getStatus();
        if (status == LoadStatusEnum.SUCCESS) {
            this.clientData = operation.getClientData();
            this.startMainGui();
        } else if (status == LoadStatusEnum.FILE_NOT_FOUND || status == LoadStatusEnum.SERIALIZATION_ERROR) {
            this.download = new DownloadOperation(this.accountNumber, this.password, this.loginGui.getFrame(), this, false);
            this.download.start();
            this.download.display(true);
        } else {
            if (status == LoadStatusEnum.AUTH_FAILURE) {
                this.loginGui.clearAll();
            }
            JOptionPane.showMessageDialog(this.loginGui.getFrame(), status.name() + ": " + status.toString(), "Load Player Data Error", 0);
            this.loginGui.getFrame().setEnabled(true);
        }
    }

    public void operationCompletedEvent(DownloadOperation operation) {
        DownloadStatusEnum status = operation.getStatus();
        if (status == DownloadStatusEnum.SUCCESS) {
            this.clientData = operation.getClientData();
            this.startMainGui();
        } else {
            if (status == DownloadStatusEnum.AUTH_FAILURE) {
                this.loginGui.clearAll();
            }
            this.loginGui.getFrame().setEnabled(true);
        }
    }

    public void startMainGui() {
        if (this.download != null) {
            this.mainGui.setClientDataFromRemote(this.clientData);
        } else {
            this.mainGui.setClientDataFromLocal(this.clientData);
        }
        this.mainGui.display(true);
        this.loginGui.display(false);
        this.display(false);
    }

    public void display(boolean flag) {
        if (flag) {
            this.pack();
            this.setVisible(flag);
        } else {
            this.dispose();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

