/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ClientFileManager;
import client.HttpNamingOperation;
import client.UploadStatusEnum;
import client.rmi.AuthenticationException;
import client.rmi.ClientRmiInterface;
import client.rmi.CreateAccountResult;
import client.rmi.DataSyncException;
import client.rmi.LockoutException;
import client.rmi.ServerStatusException;
import client.rmi.ValidationException;
import java.awt.Frame;
import java.rmi.ConnectException;
import java.rmi.MarshalException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Vector;

public class CreateAccountOperation
extends HttpNamingOperation {
    private String screenName = "";
    private String password = "";
    private String emailAddress = "";
    private Observer observer;
    private ClientRmiInterface pdi;
    private CreateAccountResult createAccountResult = new CreateAccountResult();
    private UploadStatusEnum status = UploadStatusEnum.NONE;

    public CreateAccountOperation(String screenName, String password, String emailAddress, Frame owner, Observer myObserver, boolean pervasive) {
        super("Create Account", owner, pervasive);
        this.screenName = screenName;
        this.password = password;
        this.emailAddress = emailAddress;
        this.observer = myObserver;
        this.init();
    }

    protected void init() {
        Vector<String> tasks = new Vector<String>();
        tasks.add("Connecting to server");
        tasks.add("Checking server status");
        tasks.add("Checking client version");
        tasks.add("Sending account data");
        super.init(tasks);
    }

    public Object construct() {
        try {
            Thread.yield();
            this.startTasks();
            this.doNamingLookup();
            this.pdi = (ClientRmiInterface)Naming.lookup(ClientFileManager.getRMIProperties().getRemoteInterfaceName());
            this.finishedTask();
            this.pdi.statusCheck();
            this.finishedTask();
            this.pdi.compatibilityCheck("v1.2a");
            this.finishedTask();
            this.createAccountResult = this.pdi.createAccount(this.screenName, this.password, this.emailAddress);
            this.createAccountResult.localize();
            this.finishedTask();
            this.status = UploadStatusEnum.SUCCESS;
            this.operationSuccess();
            return null;
        }
        catch (ConnectException e) {
            this.status = UploadStatusEnum.CONNECT_FAILURE;
            this.operationFailure(this.status.name(), this.status.toString());
            e.printStackTrace();
            return null;
        }
        catch (MarshalException e) {
            this.status = UploadStatusEnum.SERIALIZATION_ERROR;
            this.operationFailure(this.status.name(), this.status.toString());
            e.printStackTrace();
            return null;
        }
        catch (NotBoundException e) {
            this.status = UploadStatusEnum.RMI_FAILURE;
            this.operationFailure(this.status.name(), this.status.toString());
            e.printStackTrace();
            return null;
        }
        catch (RemoteException e) {
            this.status = UploadStatusEnum.RMI_FAILURE;
            try {
                if (e.getCause() != null) {
                    throw e.getCause();
                }
            }
            catch (ServerStatusException cause) {
                this.status = UploadStatusEnum.SERVER_UNAVAILABLE;
                cause.printStackTrace();
            }
            catch (LockoutException cause) {
                this.status = UploadStatusEnum.ACCOUNT_LOCKED;
                cause.printStackTrace();
            }
            catch (AuthenticationException cause) {
                this.status = UploadStatusEnum.AUTH_FAILURE;
                cause.printStackTrace();
            }
            catch (DataSyncException cause) {
                this.status = UploadStatusEnum.DATA_SYNC_FAILURE;
                cause.printStackTrace();
            }
            catch (ValidationException cause) {
                this.status = UploadStatusEnum.VALIDATION_FAILURE;
                cause.printStackTrace();
            }
            catch (Throwable cause) {
                cause.printStackTrace();
            }
            this.operationFailure(this.status.name(), this.status.toString());
            return null;
        }
        catch (Exception e) {
            this.status = UploadStatusEnum.UNEXPECTED_ERROR;
            this.operationFailure(this.status.name(), this.status.toString());
            e.printStackTrace();
            return null;
        }
    }

    public void operationCompletedEvent() {
        this.observer.operationCompletedEvent(this);
    }

    public UploadStatusEnum getStatus() {
        return this.status;
    }

    public CreateAccountResult getResult() {
        return this.createAccountResult;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public static interface Observer {
        public void operationCompletedEvent(CreateAccountOperation var1);
    }
}

