/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.DSModel;
import client.DescriptorDisplayAdapter;
import com.brunchboy.util.swing.relativelayout.AttributeAxis;
import com.brunchboy.util.swing.relativelayout.AttributeConstraint;
import com.brunchboy.util.swing.relativelayout.AttributeType;
import com.brunchboy.util.swing.relativelayout.AxisConstraint;
import com.brunchboy.util.swing.relativelayout.RelativeLayout;
import common.Descriptor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class DescriptorChooserGui {
    private Descriptor selection = null;
    private String selectionType;
    private Vector ddaList;
    private Frame owner;
    private JList selectionPanel;
    private JDialog dialog;
    private JButton okButton;
    private JButton cancelButton;

    public static Descriptor show(String selectionType, Vector descriptorList, Frame owner) {
        DescriptorChooserGui chooser = new DescriptorChooserGui(selectionType, descriptorList, owner);
        chooser.display(true);
        return chooser.getSelection();
    }

    public DescriptorChooserGui(String selectionType, Vector descriptorList, Frame owner) {
        this.selectionType = selectionType;
        this.owner = owner;
        this.ddaList = new Vector();
        for (int i = 0; i < descriptorList.size(); ++i) {
            this.ddaList.add(new DescriptorDisplayAdapter((Descriptor)descriptorList.get(i)));
        }
        this.dialog = new JDialog(owner, "Select " + selectionType, true);
        JPanel cp = new JPanel(new BorderLayout());
        Border b0 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        cp.setBorder(b0);
        this.dialog.setContentPane(cp);
        this.dialog.setLocation(DSModel.instance().getOperationLocation());
        this.dialog.setDefaultCloseOperation(2);
        JPanel listPanel = new JPanel(new BorderLayout());
        Border b1 = BorderFactory.createEtchedBorder();
        Border b2 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        CompoundBorder b3 = BorderFactory.createCompoundBorder(b1, b2);
        listPanel.setBorder(b3);
        cp.add((Component)listPanel, "Center");
        this.selectionPanel = new JList(this.ddaList);
        JScrollPane selectionScroll = new JScrollPane(this.selectionPanel);
        this.selectionPanel.setCellRenderer(new DescriptorListCellRenderer());
        this.selectionPanel.setSelectionMode(0);
        this.selectionPanel.setFixedCellHeight(20);
        this.selectionPanel.setFixedCellWidth(280);
        listPanel.add((Component)selectionScroll, "Center");
        RelativeLayout buttonLayout = new RelativeLayout();
        JPanel buttonPanel = new JPanel(buttonLayout);
        cp.add((Component)buttonPanel, "South");
        this.okButton = new JButton("OK");
        Border outer = BorderFactory.createEtchedBorder();
        Border inner = BorderFactory.createEmptyBorder(5, 8, 5, 8);
        CompoundBorder okBorder = BorderFactory.createCompoundBorder(outer, inner);
        this.cancelButton = new JButton("Cancel");
        buttonPanel.add((Component)this.okButton, "OK");
        buttonPanel.add((Component)this.cancelButton, "Cancel");
        buttonLayout.addConstraint("OK", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 10));
        buttonLayout.addConstraint("OK", AttributeType.HORIZONTAL_CENTER, new AxisConstraint("_container", AttributeAxis.HORIZONTAL, 0.35));
        buttonLayout.addConstraint("Cancel", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 10));
        buttonLayout.addConstraint("Cancel", AttributeType.HORIZONTAL_CENTER, new AxisConstraint("_container", AttributeAxis.HORIZONTAL, 0.65));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DescriptorDisplayAdapter dda = (DescriptorDisplayAdapter)DescriptorChooserGui.this.selectionPanel.getSelectedValue();
                if (dda != null) {
                    DescriptorChooserGui.this.selection = dda.getDescriptor();
                }
                DescriptorChooserGui.this.display(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DescriptorChooserGui.this.display(false);
            }
        });
    }

    public Descriptor getSelection() {
        return this.selection;
    }

    public void display(boolean flag) {
        if (flag) {
            this.dialog.pack();
            this.dialog.setVisible(flag);
        } else {
            this.dialog.dispose();
        }
    }

    protected class DescriptorListCellRenderer
    extends DefaultListCellRenderer {
        protected DescriptorListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            DescriptorDisplayAdapter adapter = (DescriptorDisplayAdapter)value;
            this.setIcon(adapter.getIcon());
            this.setDisabledIcon(adapter.getIcon());
            this.setText(adapter.getDetailSummary());
            return this;
        }
    }
}

