/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ClientPreferences;
import client.MainGui;
import common.ArenaDescriptor;
import common.Descriptor;
import common.FightOptionsEnum;
import common.GenerativeVisitor;
import common.ManagerCore;
import common.ManagerDescriptor;
import common.NullDescriptor;
import common.TeamCore;
import common.TeamDescriptor;
import common.TextHelper;
import common.WarriorCore;
import common.WarriorDescriptor;
import java.util.Vector;
import javax.swing.ImageIcon;

public class DescriptorDisplayAdapter {
    protected static final Boolean FALSE = new Boolean(false);
    protected static final Boolean TRUE = new Boolean(true);
    public static final DescriptorDisplayAdapter NONE = new DescriptorDisplayAdapter(NullDescriptor.NONE);
    protected Descriptor descriptor;
    protected ClientPreferences preferences = null;
    protected Boolean isMine;
    protected ImageIcon displayIcon;
    protected String displayString;
    protected String detailSummary;
    protected Vector detail;

    public DescriptorDisplayAdapter(Descriptor descriptor) {
        this.descriptor = descriptor;
        this.isMine = this.isMine(descriptor);
    }

    public DescriptorDisplayAdapter(Descriptor descriptor, ClientPreferences preferences) {
        this.descriptor = descriptor;
        this.preferences = preferences;
        this.isMine = this.isMine(descriptor);
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return this.descriptor.toString();
    }

    public boolean isMine() {
        return this.isMine;
    }

    public boolean isChallengable() {
        return !this.isMine() && !this.descriptor.isBuiltIn();
    }

    public ImageIcon getIcon() {
        if (this.isMine() || this.displayIcon == null) {
            this.displayIcon = this.getIcon(this.descriptor);
        }
        return this.displayIcon;
    }

    public String getDisplayString() {
        if (this.isMine() || this.displayString == null) {
            this.displayString = this.getDisplayString(this.descriptor);
        }
        return this.displayString;
    }

    public String getDetailSummary() {
        if (this.isMine() || this.detailSummary == null) {
            this.detailSummary = this.getDetailSummary(this.descriptor);
        }
        return this.detailSummary;
    }

    public Vector getDetail() {
        if (this.isMine() || this.detail == null) {
            DetailVisitor detailCollector = new DetailVisitor();
            this.detail = (Vector)this.descriptor.accept(detailCollector);
        }
        return this.detail;
    }

    protected Boolean isMine(Descriptor d) {
        if (d instanceof WarriorCore || d instanceof TeamCore || d instanceof ManagerCore) {
            return TRUE;
        }
        return FALSE;
    }

    protected ImageIcon getIcon(Descriptor d) {
        if (d instanceof WarriorDescriptor) {
            return this.getIcon((WarriorDescriptor)d);
        }
        if (d instanceof TeamDescriptor) {
            return this.getIcon((TeamDescriptor)d);
        }
        if (d instanceof ManagerDescriptor) {
            return this.getIcon((ManagerDescriptor)d);
        }
        if (d instanceof ArenaDescriptor) {
            return this.getIcon((ArenaDescriptor)d);
        }
        if (d instanceof NullDescriptor) {
            return this.getIcon((NullDescriptor)d);
        }
        return MainGui.UNKNOWN_ICON;
    }

    protected String getDisplayString(Descriptor d) {
        if (d instanceof NullDescriptor) {
            return "None";
        }
        if (d instanceof ArenaDescriptor) {
            return "All";
        }
        if (d instanceof WarriorDescriptor) {
            return d.getNameRecordText();
        }
        return d.getNameNumberText();
    }

    protected String getDetailSummary(Descriptor d) {
        if (d instanceof NullDescriptor) {
            return "None";
        }
        if (d instanceof ArenaDescriptor) {
            return d.getNameNumberText();
        }
        return d.getNameRecordText();
    }

    protected ImageIcon getIcon(NullDescriptor nd) {
        return MainGui.NONE_ICON;
    }

    protected ImageIcon getIcon(ArenaDescriptor ad) {
        return MainGui.ARENA_ICON;
    }

    protected ImageIcon getIcon(ManagerDescriptor md) {
        if (md.isActive()) {
            return MainGui.ACTIVE_MANAGER_ICON;
        }
        return MainGui.INACTIVE_MANAGER_ICON;
    }

    protected ImageIcon getIcon(TeamDescriptor td) {
        if (td.isActive()) {
            return MainGui.ACTIVE_TEAM_ICON;
        }
        return MainGui.INACTIVE_TEAM_ICON;
    }

    protected ImageIcon getIcon(WarriorDescriptor wd) {
        if (wd.isDead() && (this.preferences == null || !this.preferences.getHideWLK())) {
            if (wd.getTotalFights() >= 50) {
                return MainGui.DEAD_VETERAN_ICON;
            }
            return MainGui.DEAD_WARRIOR_ICON;
        }
        if (wd.isRetired()) {
            return MainGui.RETIRED_WARRIOR_ICON;
        }
        if (wd.getFightOptions() == FightOptionsEnum.SINGLES_FIGHT) {
            return MainGui.WARRIOR_ICON;
        }
        if (wd.getFightOptions() == FightOptionsEnum.TEAM_FIGHT) {
            return MainGui.TEAM_FIGHT_ICON;
        }
        if (wd.getFightOptions() == FightOptionsEnum.MONSTER) {
            return MainGui.MONSTER_WARRIOR_ICON;
        }
        if (wd.getFightOptions() == FightOptionsEnum.RETIRE) {
            return MainGui.RETIRE_WARRIOR_ICON;
        }
        if (wd.getFightOptions() == FightOptionsEnum.EVENT) {
            return MainGui.EVENT_WARRIOR_ICON;
        }
        return MainGui.WARRIOR_ICON;
    }

    public class NVPair {
        public String name;
        public String value;

        public NVPair(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public class DetailVisitor
    extends GenerativeVisitor {
        Vector detailList = new Vector();

        public Vector visit(NullDescriptor nd) {
            return this.detailList;
        }

        public Vector visit(ArenaDescriptor ad) {
            this.detailList.add(new NVPair("Arena:", DescriptorDisplayAdapter.this.getDetailSummary(ad)));
            return this.detailList;
        }

        public Vector visit(ManagerDescriptor md) {
            md.getParent().accept(this);
            this.detailList.add(new NVPair("Manager:", DescriptorDisplayAdapter.this.getDetailSummary(md)));
            return this.detailList;
        }

        public Vector visit(TeamDescriptor td) {
            td.getParent().accept(this);
            this.detailList.add(new NVPair("Team:", DescriptorDisplayAdapter.this.getDetailSummary(td)));
            return this.detailList;
        }

        public Vector visit(WarriorDescriptor wd) {
            wd.getParent().accept(this);
            this.detailList.add(new NVPair("Warrior:", DescriptorDisplayAdapter.this.getDisplayString(wd)));
            this.detailList.add(new NVPair("Race:", wd.getRace().name()));
            this.detailList.add(new NVPair("Gender:", wd.getGender().name()));
            this.detailList.add(new NVPair("Height:", TextHelper.getHeightText(wd.getHeight())));
            this.detailList.add(new NVPair("Weight:", TextHelper.getWeightText(wd.getWeight())));
            return this.detailList;
        }
    }
}

