/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ClientFileManager;
import client.DownloadStatusEnum;
import client.HttpNamingOperation;
import client.data.ArenaCOM;
import client.data.ManagerCOM;
import client.rmi.AuthenticationException;
import client.rmi.ClientRmiInterface;
import client.rmi.LockoutException;
import client.rmi.RemoteTextFile;
import client.rmi.ServerStatusException;
import client.rmi.VersionException;
import java.awt.Frame;
import java.io.File;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.Vector;

public class DownloadOperation
extends HttpNamingOperation {
    public static final long MIN_DOWNLOAD_FILE_LENGTH = 5L;
    private int accountNumber = -1;
    private String password = "";
    private Observer observer;
    private ClientRmiInterface pdi;
    private ArenaCOM clientData;
    private DownloadStatusEnum status = DownloadStatusEnum.NONE;

    public DownloadOperation(int accnt, String pwd, Frame owner, Observer myObserver, boolean pervasive) {
        super("Download", owner, pervasive);
        this.accountNumber = accnt;
        this.password = pwd;
        this.observer = myObserver;
        this.init();
    }

    public DownloadOperation(ManagerCOM mgr, Frame owner, Observer myObserver) {
        super("Download", owner);
        this.accountNumber = mgr.getManagerNumber();
        this.password = mgr.getPassword();
        this.observer = myObserver;
        this.init();
    }

    protected void init() {
        Vector<String> tasks = new Vector<String>();
        tasks.add("Connecting to server");
        tasks.add("Checking server status");
        tasks.add("Checking client version");
        tasks.add("Authenticating user");
        tasks.add("Downloading arena data");
        tasks.add("Downloading player data");
        tasks.add("Downloading new files");
        super.init(tasks);
    }

    public Object construct() {
        try {
            Thread.yield();
            this.startTasks();
            this.doNamingLookup();
            this.pdi = (ClientRmiInterface)Naming.lookup(ClientFileManager.getRMIProperties().getRemoteInterfaceName());
            this.finishedTask();
            this.pdi.statusCheck();
            this.finishedTask();
            this.pdi.compatibilityCheck("v1.2a");
            this.finishedTask();
            this.pdi.authenticatePlayer(this.accountNumber, this.password);
            this.finishedTask();
            this.clientData = this.pdi.getArenaData(1);
            this.finishedTask();
            ManagerCOM manager = this.pdi.getPlayerData(this.accountNumber, this.password);
            this.finishedTask();
            Vector remoteFileList = this.pdi.getFileList(this.accountNumber, this.password);
            for (int fileHandle = 0; fileHandle < remoteFileList.size(); ++fileHandle) {
                File fileName = (File)remoteFileList.get(fileHandle);
                if (fileName.exists() && fileName.length() >= 5L) continue;
                RemoteTextFile remoteFile = this.pdi.getFile(this.accountNumber, this.password, fileHandle);
                remoteFile.writeFile();
            }
            this.finishedTask();
            this.clientData.setManager(manager);
            this.clientData.localizeTree();
            this.status = DownloadStatusEnum.SUCCESS;
            this.operationSuccess();
            return null;
        }
        catch (ConnectException e) {
            this.status = DownloadStatusEnum.CONNECT_FAILURE;
            this.operationFailure(this.status.name(), this.status.toString());
            e.printStackTrace();
            return null;
        }
        catch (UnmarshalException e) {
            this.status = DownloadStatusEnum.SERIALIZATION_ERROR;
            this.operationFailure(this.status.name(), this.status.toString());
            e.printStackTrace();
            return null;
        }
        catch (NotBoundException e) {
            this.status = DownloadStatusEnum.RMI_FAILURE;
            this.operationFailure(this.status.name(), this.status.toString());
            e.printStackTrace();
            return null;
        }
        catch (RemoteException e) {
            this.status = DownloadStatusEnum.RMI_FAILURE;
            try {
                if (e.getCause() != null) {
                    throw e.getCause();
                }
            }
            catch (ServerStatusException cause) {
                this.status = DownloadStatusEnum.SERVER_UNAVAILABLE;
                cause.printStackTrace();
            }
            catch (LockoutException cause) {
                this.status = DownloadStatusEnum.ACCOUNT_LOCKED;
                cause.printStackTrace();
            }
            catch (AuthenticationException cause) {
                this.status = DownloadStatusEnum.AUTH_FAILURE;
                cause.printStackTrace();
            }
            catch (VersionException cause) {
                this.status = DownloadStatusEnum.VERSION_ERROR;
                cause.printStackTrace();
            }
            catch (Throwable cause) {
                cause.printStackTrace();
            }
            this.operationFailure(this.status.name(), this.status.toString());
            return null;
        }
        catch (Exception e) {
            this.status = DownloadStatusEnum.UNEXPECTED_ERROR;
            this.operationFailure(this.status.name(), this.status.toString());
            e.printStackTrace();
            return null;
        }
    }

    public void operationCompletedEvent() {
        this.observer.operationCompletedEvent(this);
    }

    public DownloadStatusEnum getStatus() {
        return this.status;
    }

    public ArenaCOM getClientData() {
        return this.clientData;
    }

    static interface Observer {
        public void operationCompletedEvent(DownloadOperation var1);
    }
}

