/*
 * Decompiled with CFR 0.152.
 */
package client;

import java.io.Serializable;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.Vector;

public class DownloadStatusEnum
implements Serializable,
Comparable {
    private static TreeMap VALUE2NAME = new TreeMap();
    private static HashMap NAME2VALUE = new HashMap();
    public static int MIN_VALUE = Integer.MAX_VALUE;
    public static int MAX_VALUE = Integer.MIN_VALUE;
    public static DownloadStatusEnum NONE = new DownloadStatusEnum(0, "None", "No download status available");
    public static DownloadStatusEnum SUCCESS = new DownloadStatusEnum(1, "Success", "Download succeeded");
    public static DownloadStatusEnum AUTH_FAILURE = new DownloadStatusEnum(2, "Authentication Failure", "Invalid account/password");
    public static DownloadStatusEnum CONNECT_FAILURE = new DownloadStatusEnum(3, "Connect Failure", "Server connection refused");
    public static DownloadStatusEnum SERIALIZATION_ERROR = new DownloadStatusEnum(4, "Serialization Error", "Data model incompatible");
    public static DownloadStatusEnum SERVER_UNAVAILABLE = new DownloadStatusEnum(5, "Server Unavailable", "Maintenance in progress");
    public static DownloadStatusEnum RMI_FAILURE = new DownloadStatusEnum(6, "RMI Failure", "Server-side error");
    public static DownloadStatusEnum ABORTED = new DownloadStatusEnum(7, "Aborted", "Operation Cancelled");
    public static DownloadStatusEnum VERSION_ERROR = new DownloadStatusEnum(8, "Version Error", "Client version incompatible");
    public static DownloadStatusEnum ACCOUNT_LOCKED = new DownloadStatusEnum(9, "Account Locked", "Contact your administrator");
    public static DownloadStatusEnum UNEXPECTED_ERROR = new DownloadStatusEnum(10, "Unexpected Error", "Stack trace in debug log");
    private Integer value;
    private String name;
    private String description;

    protected DownloadStatusEnum(int value, String name) {
        this.value = new Integer(value);
        this.name = name;
        this.description = name;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    protected DownloadStatusEnum(int value, String name, String description) {
        this.value = new Integer(value);
        this.name = name;
        this.description = description;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    public static boolean contains(String name) {
        return NAME2VALUE.containsKey(name);
    }

    public static boolean contains(int value) {
        return VALUE2NAME.containsKey(new Integer(value));
    }

    public static int valueOf(String name) {
        return ((DownloadStatusEnum)NAME2VALUE.get(name)).value();
    }

    public static String nameOf(int value) {
        return ((DownloadStatusEnum)VALUE2NAME.get(new Integer(value))).name();
    }

    public static DownloadStatusEnum get(String name) {
        return (DownloadStatusEnum)NAME2VALUE.get(name);
    }

    public static DownloadStatusEnum get(int value) {
        return (DownloadStatusEnum)VALUE2NAME.get(new Integer(value));
    }

    public int value() {
        return this.value;
    }

    public String name() {
        return this.name;
    }

    public int compareTo(Object o) {
        Integer anIntegerValue = ((DownloadStatusEnum)o).value;
        return this.value.compareTo(anIntegerValue);
    }

    public static Vector values() {
        Vector<DownloadStatusEnum> v = new Vector<DownloadStatusEnum>(MAX_VALUE);
        for (int i = MIN_VALUE; i <= MAX_VALUE; ++i) {
            v.add(DownloadStatusEnum.get(i));
        }
        return v;
    }

    public String toString() {
        return this.description;
    }

    public String toStringFull() {
        return super.toString() + " Name=" + this.name + " Value=" + this.value.toString();
    }
}

