/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.DSModel;
import common.Constants;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public class HelpGui
implements Constants {
    private JFrame myFrame;
    private JEditorPane helpTextPane;
    private Observer myObserver;

    public HelpGui(URL helpURL, Observer observer) {
        this.myObserver = observer;
        this.myFrame = new JFrame("Blood Pit Client - Help");
        this.myFrame.setDefaultCloseOperation(2);
        JComponent loginTop = (JComponent)this.myFrame.getContentPane();
        loginTop.setLayout(new BorderLayout());
        this.myFrame.setLocation(DSModel.instance().getHelpLocation());
        try {
            this.helpTextPane = new JEditorPane(helpURL);
        }
        catch (IOException e) {
            throw new RuntimeException("Help starting URL not found");
        }
        this.helpTextPane.setPreferredSize(new Dimension(420, 460));
        JScrollPane helpPaneScroll = new JScrollPane(this.helpTextPane);
        this.helpTextPane.setEditable(false);
        loginTop.add(helpPaneScroll);
        this.myFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                HelpGui.this.myObserver.closedEvent(HelpGui.this);
            }
        });
    }

    public void display(boolean flag) {
        if (flag) {
            this.myFrame.pack();
            this.myFrame.setVisible(flag);
        } else {
            this.myFrame.dispose();
        }
    }

    public Frame getFrame() {
        return this.myFrame;
    }

    public static interface Observer {
        public void closedEvent(HelpGui var1);
    }
}

