/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ClientFileManager;
import client.LoadStatusEnum;
import client.SwingWorkerII;
import client.data.ArenaCOM;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InvalidClassException;

public class LoadOperation
extends SwingWorkerII {
    private Observer observer;
    private int arenaNumber;
    private int accountNumber;
    private String password;
    private ArenaCOM clientData;
    private LoadStatusEnum status = LoadStatusEnum.NONE;

    public LoadOperation(int arenaNumber, int accountNumber, String password, Observer observer) {
        this.accountNumber = accountNumber;
        this.arenaNumber = arenaNumber;
        this.password = password;
        this.observer = observer;
    }

    public Object construct() {
        try {
            Thread.yield();
            this.clientData = ClientFileManager.loadPlayerData(this.arenaNumber, this.accountNumber, this.password);
            if (this.clientData != null) {
                this.clientData.localizeTree();
                this.status = LoadStatusEnum.SUCCESS;
            } else {
                this.status = LoadStatusEnum.AUTH_FAILURE;
            }
        }
        catch (FileNotFoundException e) {
            this.status = LoadStatusEnum.FILE_NOT_FOUND;
        }
        catch (InvalidClassException e) {
            this.status = LoadStatusEnum.SERIALIZATION_ERROR;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.status = LoadStatusEnum.UNEXPECTED_ERROR;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            this.status = LoadStatusEnum.UNEXPECTED_ERROR;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.status = LoadStatusEnum.UNEXPECTED_ERROR;
        }
        return null;
    }

    public void finished() {
        this.observer.operationCompletedEvent(this);
    }

    public ArenaCOM getClientData() {
        return this.clientData;
    }

    public LoadStatusEnum getStatus() {
        return this.status;
    }

    public static interface Observer {
        public void operationCompletedEvent(LoadOperation var1);
    }
}

