/*
 * Decompiled with CFR 0.152.
 */
package client;

import java.io.Serializable;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.Vector;

public class LoadStatusEnum
implements Serializable,
Comparable {
    private static TreeMap VALUE2NAME = new TreeMap();
    private static HashMap NAME2VALUE = new HashMap();
    public static int MIN_VALUE = Integer.MAX_VALUE;
    public static int MAX_VALUE = Integer.MIN_VALUE;
    public static LoadStatusEnum NONE = new LoadStatusEnum(0, "None", "No load status available");
    public static LoadStatusEnum SUCCESS = new LoadStatusEnum(1, "Success", "Load operation succeeded");
    public static LoadStatusEnum AUTH_FAILURE = new LoadStatusEnum(2, "Authentication Failure", "Invalid account/password");
    public static LoadStatusEnum FILE_NOT_FOUND = new LoadStatusEnum(3, "File Not Found", "File not found");
    public static LoadStatusEnum SERIALIZATION_ERROR = new LoadStatusEnum(4, "Serialization Error", "Data model incompatible");
    public static LoadStatusEnum VERSION_ERROR = new LoadStatusEnum(5, "Version Error", "Client version incompatible");
    public static LoadStatusEnum UNEXPECTED_ERROR = new LoadStatusEnum(6, "Unexpected Error", "Stack trace in debug log");
    private Integer value;
    private String name;
    private String description;

    protected LoadStatusEnum(int value, String name) {
        this.value = new Integer(value);
        this.name = name;
        this.description = name;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    protected LoadStatusEnum(int value, String name, String description) {
        this.value = new Integer(value);
        this.name = name;
        this.description = description;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    public static boolean contains(String name) {
        return NAME2VALUE.containsKey(name);
    }

    public static boolean contains(int value) {
        return VALUE2NAME.containsKey(new Integer(value));
    }

    public static int valueOf(String name) {
        return ((LoadStatusEnum)NAME2VALUE.get(name)).value();
    }

    public static String nameOf(int value) {
        return ((LoadStatusEnum)VALUE2NAME.get(new Integer(value))).name();
    }

    public static LoadStatusEnum get(String name) {
        return (LoadStatusEnum)NAME2VALUE.get(name);
    }

    public static LoadStatusEnum get(int value) {
        return (LoadStatusEnum)VALUE2NAME.get(new Integer(value));
    }

    public int value() {
        return this.value;
    }

    public String name() {
        return this.name;
    }

    public int compareTo(Object o) {
        Integer anIntegerValue = ((LoadStatusEnum)o).value;
        return this.value.compareTo(anIntegerValue);
    }

    public static Vector values() {
        Vector<LoadStatusEnum> v = new Vector<LoadStatusEnum>(MAX_VALUE);
        for (int i = MIN_VALUE; i <= MAX_VALUE; ++i) {
            v.add(LoadStatusEnum.get(i));
        }
        return v;
    }

    public String toString() {
        return this.description;
    }

    public String toStringFull() {
        return super.toString() + " Name=" + this.name + " Value=" + this.value.toString();
    }
}

