/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.AutoLoginProperties;
import client.BPEmailField;
import client.BPNumericField;
import client.BPPasswordField;
import client.BPTextField;
import client.ClientFileManager;
import client.ClientGui;
import client.CreateAccountOperation;
import client.DSModel;
import client.HelpGui;
import client.MainGui;
import client.UploadStatusEnum;
import client.UserAgreementGui;
import client.rmi.CreateAccountResult;
import client.rmi.CreateAccountStatusEnum;
import common.Constants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class LoginGui
implements CreateAccountOperation.Observer,
HelpGui.Observer,
Constants {
    public static final URL AGREEMENT_URL = (class$client$LoginGui == null ? (class$client$LoginGui = LoginGui.class$("client.LoginGui")) : class$client$LoginGui).getResource("help/agreement.html");
    public static final URL ACCOUNT_HELP_URL = (class$client$LoginGui == null ? (class$client$LoginGui = LoginGui.class$("client.LoginGui")) : class$client$LoginGui).getResource("help/accountSetup.html");
    protected static AutoLoginProperties autoLoginProperties = null;
    private Observer observer;
    private int accountNumber = -1;
    private String password = "";
    private String newScreenName;
    private String newPassword;
    private String newEmail;
    private CreateAccountOperation create;
    private HelpGui helpGui;
    private JTabbedPane loginTabbedPane;
    private JFrame myFrame;
    private BPNumericField accountField;
    private BPPasswordField passwordField;
    private JCheckBox autoLogin;
    private JButton loginButton;
    private BPTextField screenNameField;
    private BPEmailField emailField;
    private BPPasswordField newPasswordField1;
    private BPPasswordField newPasswordField2;
    private JButton helpButton;
    private JButton agreementButton;
    private JButton createButton;
    static /* synthetic */ Class class$client$LoginGui;

    public static AutoLoginProperties getAutoLoginProperties() {
        if (autoLoginProperties == null) {
            autoLoginProperties = ClientFileManager.loadAutoLoginProperties();
        }
        return autoLoginProperties;
    }

    public LoginGui(Observer myObserver) {
        this.observer = myObserver;
        LoginGui.getAutoLoginProperties();
        this.myFrame = new JFrame("Blood Pit Client - v1.2");
        this.myFrame.setDefaultCloseOperation(3);
        JComponent loginTop = (JComponent)this.myFrame.getContentPane();
        loginTop.setLayout(new BorderLayout());
        this.myFrame.setLocation(DSModel.instance().getLoginLocation());
        this.loginTabbedPane = new JTabbedPane();
        loginTop.add(this.loginTabbedPane);
        JPanel newPlayerPanel = new JPanel(new BorderLayout());
        JPanel loginPanel = new JPanel(new BorderLayout());
        Border border1 = BorderFactory.createEtchedBorder();
        TitledBorder tBorder1 = BorderFactory.createTitledBorder(border1, "Account Info");
        Border border2 = BorderFactory.createEmptyBorder(10, 20, 2, 20);
        CompoundBorder border3 = BorderFactory.createCompoundBorder(tBorder1, border2);
        loginPanel.setBorder(border3);
        this.loginTabbedPane.add((Component)loginPanel, "Login");
        border1 = BorderFactory.createEtchedBorder();
        tBorder1 = BorderFactory.createTitledBorder(border1, "Account Setup");
        border2 = BorderFactory.createEmptyBorder(10, 20, 10, 20);
        border3 = BorderFactory.createCompoundBorder(tBorder1, border2);
        newPlayerPanel.setBorder(border3);
        this.loginTabbedPane.add((Component)newPlayerPanel, "New Player");
        JPanel loginLabels = new JPanel(new GridLayout(0, 1));
        border1 = BorderFactory.createEmptyBorder(0, 0, 0, 4);
        loginLabels.setBorder(border1);
        JPanel loginFields = new JPanel(new GridLayout(0, 1));
        loginPanel.add((Component)loginLabels, "West");
        loginPanel.add((Component)loginFields, "Center");
        JLabel accountLabel = new JLabel("Account Number");
        JLabel passwordLabel = new JLabel("Password");
        JLabel dummyLabel1 = new JLabel("");
        JLabel dummyLabel2 = new JLabel("");
        loginLabels.add(accountLabel);
        loginLabels.add(passwordLabel);
        loginLabels.add(dummyLabel1);
        loginLabels.add(dummyLabel2);
        this.accountField = new BPNumericField(20, 6);
        this.passwordField = new BPPasswordField(20, 12);
        JPanel dummyField1 = new JPanel();
        this.autoLogin = new JCheckBox("Always use this login");
        JPanel dummyField3 = new JPanel();
        border1 = BorderFactory.createEmptyBorder(0, 2, 0, 2);
        border2 = BorderFactory.createLoweredBevelBorder();
        this.passwordField.setBorder(BorderFactory.createCompoundBorder(border2, border1));
        loginFields.add(this.accountField);
        loginFields.add(this.passwordField);
        loginFields.add(this.autoLogin);
        loginFields.add(dummyField1);
        this.accountField.setText(LoginGui.getAutoLoginProperties().getAccountNumber());
        this.passwordField.setText(LoginGui.getAutoLoginProperties().getPassword());
        this.autoLogin.setSelected(LoginGui.getAutoLoginProperties().isEnabled());
        Box loginButtonPanel = Box.createHorizontalBox();
        border1 = BorderFactory.createEmptyBorder(8, 0, 4, 0);
        loginButtonPanel.setBorder(border1);
        loginPanel.add((Component)loginButtonPanel, "South");
        this.loginButton = new JButton("Login");
        loginButtonPanel.add(Box.createHorizontalGlue());
        loginButtonPanel.add(this.loginButton);
        loginButtonPanel.add(Box.createHorizontalGlue());
        this.accountField.setFont(ClientGui.f0b);
        this.passwordField.setFont(ClientGui.f0b);
        this.passwordField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String pwd = new String(LoginGui.this.passwordField.getPassword());
                String accnt = LoginGui.this.accountField.getText();
                if (pwd.length() > 0 && accnt.length() > 0) {
                    try {
                        LoginGui.this.accountNumber = Integer.parseInt(accnt);
                    }
                    catch (Exception x) {
                        throw new RuntimeException(x);
                    }
                    LoginGui.this.password = pwd;
                    LoginGui.this.observer.loginEvent(LoginGui.this);
                    LoginGui.this.closeHelp();
                }
            }
        });
        this.loginButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String pwd = new String(LoginGui.this.passwordField.getPassword());
                String accnt = LoginGui.this.accountField.getText();
                if (pwd.length() > 0 && accnt.length() > 0) {
                    try {
                        LoginGui.this.accountNumber = Integer.parseInt(accnt);
                    }
                    catch (Exception x) {
                        throw new RuntimeException(x);
                    }
                    LoginGui.this.password = pwd;
                    if (LoginGui.this.autoLogin.isSelected()) {
                        LoginGui.getAutoLoginProperties().setAccountNumber(accnt);
                        LoginGui.getAutoLoginProperties().setPassword(pwd);
                    } else {
                        LoginGui.getAutoLoginProperties().reset();
                    }
                    ClientFileManager.saveAutoLoginProperties(LoginGui.getAutoLoginProperties());
                    LoginGui.this.observer.loginEvent(LoginGui.this);
                    LoginGui.this.closeHelp();
                }
            }
        });
        JPanel newPlayerLabels = new JPanel(new GridLayout(0, 1));
        border1 = BorderFactory.createEmptyBorder(0, 0, 0, 6);
        newPlayerLabels.setBorder(border1);
        JPanel newPlayerFields = new JPanel(new GridLayout(0, 1));
        newPlayerPanel.add((Component)newPlayerLabels, "West");
        newPlayerPanel.add((Component)newPlayerFields, "Center");
        JLabel screenNameLabel = new JLabel("Manager Name");
        JLabel emailLabel = new JLabel("Email Address");
        JLabel newPasswordLabel1 = new JLabel("Password");
        JLabel newPasswordLabel2 = new JLabel("Verify Password");
        newPlayerLabels.add(screenNameLabel);
        newPlayerLabels.add(emailLabel);
        newPlayerLabels.add(newPasswordLabel1);
        newPlayerLabels.add(newPasswordLabel2);
        this.screenNameField = new BPTextField(20, 25);
        this.emailField = new BPEmailField(20, 40);
        this.newPasswordField1 = new BPPasswordField(20, 12);
        this.newPasswordField2 = new BPPasswordField(20, 12);
        border1 = BorderFactory.createEmptyBorder(0, 2, 0, 2);
        border2 = BorderFactory.createLoweredBevelBorder();
        this.newPasswordField1.setBorder(BorderFactory.createCompoundBorder(border2, border1));
        this.newPasswordField2.setBorder(BorderFactory.createCompoundBorder(border2, border1));
        this.screenNameField.setEnabled(false);
        this.emailField.setEnabled(false);
        this.newPasswordField1.setEnabled(false);
        this.newPasswordField2.setEnabled(false);
        this.screenNameField.setBackground(Color.LIGHT_GRAY);
        this.emailField.setBackground(Color.LIGHT_GRAY);
        this.newPasswordField1.setBackground(Color.LIGHT_GRAY);
        this.newPasswordField2.setBackground(Color.LIGHT_GRAY);
        newPlayerFields.add(this.screenNameField);
        newPlayerFields.add(this.emailField);
        newPlayerFields.add(this.newPasswordField1);
        newPlayerFields.add(this.newPasswordField2);
        Box createButtonPanel = Box.createHorizontalBox();
        border1 = BorderFactory.createEmptyBorder(10, 0, 0, 0);
        createButtonPanel.setBorder(border1);
        newPlayerPanel.add((Component)createButtonPanel, "South");
        this.helpButton = new JButton("Help");
        this.agreementButton = new JButton("Read User Agreement");
        this.createButton = new JButton("Create Account");
        createButtonPanel.add(Box.createHorizontalGlue());
        createButtonPanel.add(this.helpButton);
        createButtonPanel.add(Box.createHorizontalStrut(10));
        createButtonPanel.add(this.agreementButton);
        createButtonPanel.add(Box.createHorizontalStrut(10));
        createButtonPanel.add(this.createButton);
        createButtonPanel.add(Box.createHorizontalGlue());
        this.createButton.setEnabled(false);
        this.newPasswordField1.getDocument().addDocumentListener(new CreateAccountDocumentListener());
        this.newPasswordField2.getDocument().addDocumentListener(new CreateAccountDocumentListener());
        this.screenNameField.setFont(ClientGui.f0b);
        this.emailField.setFont(ClientGui.f0b);
        this.newPasswordField1.setFont(ClientGui.f0b);
        this.newPasswordField2.setFont(ClientGui.f0b);
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (LoginGui.this.helpGui == null) {
                    LoginGui.this.helpGui = new HelpGui(ACCOUNT_HELP_URL, LoginGui.this);
                    LoginGui.this.helpGui.display(true);
                }
            }
        });
        this.agreementButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean agreementAccepted = UserAgreementGui.show(AGREEMENT_URL, LoginGui.this.myFrame);
                LoginGui.this.screenNameField.setEnabled(agreementAccepted);
                LoginGui.this.emailField.setEnabled(agreementAccepted);
                LoginGui.this.newPasswordField1.setEnabled(agreementAccepted);
                LoginGui.this.newPasswordField2.setEnabled(agreementAccepted);
            }
        });
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LoginGui.this.newScreenName = LoginGui.this.screenNameField.getText();
                LoginGui.this.newEmail = LoginGui.this.emailField.getText();
                LoginGui.this.newPassword = new String(LoginGui.this.newPasswordField1.getPassword());
                LoginGui.this.create = new CreateAccountOperation(LoginGui.this.newScreenName, LoginGui.this.newPassword, LoginGui.this.newEmail, LoginGui.this.myFrame, LoginGui.this, false);
                LoginGui.this.create.start();
                LoginGui.this.create.display(true);
            }
        });
    }

    public void clearAll() {
        this.accountField.setText("");
        this.passwordField.setText("");
        this.screenNameField.setText("");
        this.emailField.setText("");
        this.newPasswordField1.setText("");
        this.newPasswordField2.setText("");
        this.autoLogin.setSelected(false);
    }

    public void display(boolean flag) {
        if (flag) {
            this.myFrame.pack();
            this.myFrame.setVisible(flag);
        } else {
            this.myFrame.dispose();
        }
    }

    public Frame getFrame() {
        return this.myFrame;
    }

    public int getAccountNumber() {
        return this.accountNumber;
    }

    public String getPassword() {
        return this.password;
    }

    public void operationCompletedEvent(CreateAccountOperation operation) {
        if (operation.getStatus() == UploadStatusEnum.SUCCESS) {
            CreateAccountResult result = operation.getResult();
            if (result.getStatus() == CreateAccountStatusEnum.SUCCESS) {
                JOptionPane.showMessageDialog(this.myFrame, result.getDetail(), "Account Creation Result", -1, MainGui.ARENA_ICON);
                this.clearAll();
                this.loginTabbedPane.setSelectedIndex(0);
            } else if (result.getStatus() == CreateAccountStatusEnum.VALIDATION_FAILURE) {
                JOptionPane.showMessageDialog(this.myFrame, result.getDetail(), "Account Creation Result", 2);
            } else {
                JOptionPane.showMessageDialog(this.myFrame, result.getDetail(), "Account Creation Result", 0);
                this.clearAll();
            }
        }
    }

    public void closedEvent(HelpGui gui) {
        this.helpGui = null;
    }

    public void closeHelp() {
        if (this.helpGui != null) {
            this.helpGui.display(false);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Observer {
        public void loginEvent(LoginGui var1);
    }

    public class CreateAccountDocumentListener
    implements DocumentListener {
        public void insertUpdate(DocumentEvent e) {
            String newPwd2;
            String newPwd1;
            char[] new1 = LoginGui.this.newPasswordField1.getPassword();
            char[] new2 = LoginGui.this.newPasswordField2.getPassword();
            if (new1.length >= 6 && (newPwd1 = new String(new1)).equals(newPwd2 = new String(new2))) {
                LoginGui.this.createButton.setEnabled(true);
                return;
            }
            LoginGui.this.createButton.setEnabled(false);
        }

        public void removeUpdate(DocumentEvent e) {
            String newPwd2;
            String newPwd1;
            char[] new1 = LoginGui.this.newPasswordField1.getPassword();
            char[] new2 = LoginGui.this.newPasswordField2.getPassword();
            if (new1.length >= 6 && (newPwd1 = new String(new1)).equals(newPwd2 = new String(new2))) {
                LoginGui.this.createButton.setEnabled(true);
                return;
            }
            LoginGui.this.createButton.setEnabled(false);
        }

        public void changedUpdate(DocumentEvent e) {
        }
    }
}

