/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.AboutGui;
import client.ChangePasswordOperation;
import client.ClientFileManager;
import client.ClientGui;
import client.ClientPreferences;
import client.DSModel;
import client.DependentGui;
import client.DescriptorDisplayAdapter;
import client.DownloadOperation;
import client.DownloadStatusEnum;
import client.ManagerGui;
import client.PasswordGui;
import client.SaveOperation;
import client.SaveStatusEnum;
import client.SwingWorkerII;
import client.TeamGui;
import client.UploadOperation;
import client.UploadStatusEnum;
import client.WarriorGui;
import client.data.ArenaCOM;
import client.data.ManagerCOM;
import com.brunchboy.util.swing.relativelayout.AttributeAxis;
import com.brunchboy.util.swing.relativelayout.AttributeConstraint;
import com.brunchboy.util.swing.relativelayout.AttributeType;
import com.brunchboy.util.swing.relativelayout.AxisConstraint;
import com.brunchboy.util.swing.relativelayout.RelativeLayout;
import common.ActiveTeamsCollectionVisitor;
import common.ArenaDescriptor;
import common.Constants;
import common.Descriptor;
import common.ManagerDescriptor;
import common.TeamDescriptor;
import common.WarriorDescriptor;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.Spring;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

public class MainGui
extends SwingWorkerII
implements SaveOperation.Observer,
UploadOperation.Observer,
DownloadOperation.Observer,
PasswordGui.Observer,
Constants {
    public static ImageIcon ARENA_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = MainGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/arena.gif"));
    public static ImageIcon ACTIVE_MANAGER_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = MainGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/active_manager.gif"));
    public static ImageIcon INACTIVE_MANAGER_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = MainGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/inactive_manager.gif"));
    public static ImageIcon ACTIVE_MANAGER_UPLOAD_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = MainGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/active_manager_up.gif"));
    public static ImageIcon INACTIVE_MANAGER_UPLOAD_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = MainGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/inactive_manager_up.gif"));
    public static ImageIcon ACTIVE_TEAM_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = MainGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/active_team.gif"));
    public static ImageIcon INACTIVE_TEAM_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = MainGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/inactive_team.gif"));
    public static ImageIcon WARRIOR_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = MainGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/warrior.gif"));
    public static ImageIcon DEAD_WARRIOR_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = MainGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/warrior_dead.gif"));
    public static ImageIcon DEAD_VETERAN_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = MainGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/warrior_dead.gif"));
    public static ImageIcon TEAM_FIGHT_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = MainGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/warrior_team.gif"));
    public static ImageIcon MONSTER_WARRIOR_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = MainGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/warrior_monster.gif"));
    public static ImageIcon RETIRE_WARRIOR_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = MainGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/warrior_retire.gif"));
    public static ImageIcon RETIRED_WARRIOR_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = MainGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/warrior_retired.gif"));
    public static ImageIcon EVENT_WARRIOR_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = MainGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/warrior_event.gif"));
    public static ImageIcon NONE_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = MainGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/none.gif"));
    public static ImageIcon RIGHT_ARROW_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = MainGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/arrow_right.gif"));
    public static ImageIcon CLEAR_SELECTION_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = MainGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/clear_selection.gif"));
    public static ImageIcon UNKNOWN_ICON = new ImageIcon((class$client$MainGui == null ? (class$client$MainGui = MainGui.class$("client.MainGui")) : class$client$MainGui).getResource("images/unknown.gif"));
    public static Color LIGHT_BROWN = new Color(229, 219, 190);
    public static Color MEDIUM_GRAY = new Color(150, 150, 150);
    public static Color BROWN = new Color(200, 160, 53);
    public static Color DARK_BROWN = new Color(130, 104, 34);
    public static Color DARK_BLUE = new Color(0, 0, 128);
    public static final int REFRESH_ALWAYS = 0;
    public static final int REFRESH_NEVER = 1;
    public static final int REFRESH_AS_NEEDED = 2;
    private Observer observer;
    private DSModel dsm = DSModel.instance();
    private ArenaCOM clientData = null;
    private ClientPreferences clientPreferences = null;
    private SaveOperation finalSave = null;
    private UploadOperation finalUpload = null;
    private boolean saveNeeded = false;
    private JFrame myFrame;
    private JPanel mtreePanel;
    private JPanel dataPanel;
    private CardLayout dataPanelLayout;
    private JTree mtree;
    private ManagerDataTreeCellRenderer mtreeRenderer;
    private JCheckBoxMenuItem itemHideWLK;
    private DependentGui currentGui;
    private ManagerGui mGui;
    private TeamGui tGui;
    private WarriorGui wGui;
    private Border border1;
    private Border border2;
    private Border border3;
    private TitledBorder tBorder1;
    private TitledBorder tBorder2;
    private TitledBorder tBorder3;
    private GridBagConstraints gbConst1;
    private GridBagConstraints gbConst2;
    private Spring spring0;
    private Spring spring1;
    private Spring spring2;
    private Spring spring3;
    static /* synthetic */ Class class$client$MainGui;

    public ClientPreferences getClientPreferences() {
        if (this.clientPreferences == null) {
            this.clientPreferences = ClientFileManager.loadClientPreferences(this.clientData);
        }
        return this.clientPreferences;
    }

    public MainGui(Observer observer) {
        this.observer = observer;
    }

    public Object construct() {
        this.myFrame = new JFrame("Blood Pit Client - v1.2");
        this.myFrame.setDefaultCloseOperation(0);
        JPanel mainTop = new JPanel();
        RelativeLayout mainLayout = new RelativeLayout();
        mainTop.setLayout(mainLayout);
        this.myFrame.setContentPane(mainTop);
        this.myFrame.setLocation(this.dsm.getMainLocation());
        this.myFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                int option;
                if (MainGui.this.clientData.getManager().getUploadNeeded() && (option = JOptionPane.showConfirmDialog(MainGui.this.myFrame, "You have made local changes that have not yet\nbeen uploaded to the server.  Do you still\nwant to exit?", "Upload Warning", 0, 2)) == 1) {
                    return;
                }
                MainGui.this.finalSave = new SaveOperation(MainGui.this.clientData, MainGui.this);
                MainGui.this.finalSave.start();
                MainGui.this.myFrame.setVisible(false);
                MainGui.this.myFrame.dispose();
            }
        });
        JMenuBar menuBar = new JMenuBar();
        this.myFrame.setJMenuBar(menuBar);
        JMenu menuFile = new JMenu("File");
        JMenu menuEdit = new JMenu("Edit");
        JMenu menuPreferences = new JMenu("Preferences");
        JMenu menuAction = new JMenu("Action");
        JMenu menuHelp = new JMenu("Help");
        menuFile.setMnemonic(70);
        menuEdit.setMnemonic(69);
        menuAction.setMnemonic(65);
        menuPreferences.setMnemonic(79);
        menuHelp.setMnemonic(72);
        menuBar.add(Box.createHorizontalStrut(6));
        menuBar.add(menuFile);
        menuBar.add(Box.createHorizontalStrut(12));
        menuBar.add(menuEdit);
        menuBar.add(Box.createHorizontalStrut(12));
        menuBar.add(menuPreferences);
        menuBar.add(Box.createHorizontalStrut(12));
        menuBar.add(menuAction);
        menuBar.add(Box.createHorizontalGlue());
        menuBar.add(menuHelp);
        menuBar.add(Box.createHorizontalStrut(12));
        JMenuItem itemSave = new JMenuItem("Save");
        JMenuItem itemQuit = new JMenuItem("Quit");
        JMenuItem itemDone = new JMenuItem("Done");
        menuFile.add(itemSave);
        menuFile.addSeparator();
        menuFile.add(itemQuit);
        menuFile.addSeparator();
        menuFile.add(itemDone);
        itemSave.setMnemonic(83);
        itemQuit.setMnemonic(81);
        itemDone.setMnemonic(68);
        itemSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        itemQuit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        itemDone.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        AbstractButton itemCut = null;
        AbstractButton itemCopy = null;
        AbstractButton itemPaste = null;
        JTextArea dummy = new JTextArea();
        Action[] actionsArray = dummy.getActions();
        for (int i = 0; i < actionsArray.length; ++i) {
            Action a = actionsArray[i];
            if (a.getValue("Name").equals("cut-to-clipboard")) {
                itemCut = new JMenuItem(a);
            }
            if (a.getValue("Name").equals("copy-to-clipboard")) {
                itemCopy = new JMenuItem(a);
            }
            if (!a.getValue("Name").equals("paste-from-clipboard")) continue;
            itemPaste = new JMenuItem(a);
        }
        itemCut.setText("Cut");
        itemCopy.setText("Copy");
        itemPaste.setText("Paste");
        itemCut.setMnemonic(88);
        itemCopy.setMnemonic(67);
        itemPaste.setMnemonic(86);
        ((JMenuItem)itemCut).setAccelerator(KeyStroke.getKeyStroke(88, 2));
        ((JMenuItem)itemCopy).setAccelerator(KeyStroke.getKeyStroke(67, 2));
        ((JMenuItem)itemPaste).setAccelerator(KeyStroke.getKeyStroke(86, 2));
        menuEdit.add((JMenuItem)itemCut);
        menuEdit.addSeparator();
        menuEdit.add((JMenuItem)itemCopy);
        menuEdit.addSeparator();
        menuEdit.add((JMenuItem)itemPaste);
        this.itemHideWLK = new JCheckBoxMenuItem("Hide WLK");
        menuPreferences.add(this.itemHideWLK);
        JMenuItem itemUpload = new JMenuItem("Upload");
        JMenuItem itemDownload = new JMenuItem("Download");
        JMenuItem itemChangePassword = new JMenuItem("Change Password");
        menuAction.add(itemUpload);
        menuAction.addSeparator();
        menuAction.add(itemDownload);
        menuAction.addSeparator();
        menuAction.add(itemChangePassword);
        itemUpload.setMnemonic(85);
        itemDownload.setMnemonic(68);
        itemChangePassword.setMnemonic(67);
        itemUpload.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        itemDownload.setAccelerator(KeyStroke.getKeyStroke(68, 2));
        JMenuItem itemContents = new JMenuItem("Help Contents");
        JMenuItem itemAbout = new JMenuItem("About BP Client");
        menuHelp.add(itemContents);
        menuHelp.addSeparator();
        menuHelp.add(itemAbout);
        itemContents.setMnemonic(67);
        itemAbout.setMnemonic(65);
        itemContents.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        itemSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SaveOperation save = new SaveOperation(MainGui.this.clientData, MainGui.this);
                save.start();
            }
        });
        itemQuit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MainGui.this.isSaveNeeded()) {
                    int option = JOptionPane.showConfirmDialog(MainGui.this.myFrame, "Save changes before quitting?", "", 0);
                    if (option == 0) {
                        MainGui.this.finalSave = new SaveOperation(MainGui.this.clientData, MainGui.this);
                        MainGui.this.finalSave.start();
                        return;
                    }
                    System.exit(0);
                } else {
                    System.exit(0);
                }
            }
        });
        itemDone.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int option;
                if (MainGui.this.clientData.getManager().getUploadNeeded() && (option = JOptionPane.showConfirmDialog(MainGui.this.myFrame, "You have made local changes that have not yet\nbeen uploaded to the server. Do you still\nwant to exit?", "Upload Warning", 0, 2)) == 1) {
                    return;
                }
                MainGui.this.finalSave = new SaveOperation(MainGui.this.clientData, MainGui.this);
                MainGui.this.finalSave.start();
                MainGui.this.myFrame.setVisible(false);
                MainGui.this.myFrame.dispose();
            }
        });
        itemUpload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!MainGui.this.clientData.getEventEnabled() && MainGui.this.clientData.getManager().getEventEntryCount() > 0) {
                    JOptionPane.showMessageDialog(MainGui.this.myFrame, "One or more of your warriors is targeted for an Arena\nEvent, however there is currently no event in progress.\nPlease change all warriors to have valid fight options\nbefore uploading.", "Warrior Settings Error", 0);
                    return;
                }
                if (!MainGui.this.clientData.getManager().validateRunStatus()) {
                    JOptionPane.showMessageDialog(MainGui.this.myFrame, "One of the teams you have specified to run this turn\ncurrently has a dead or retired warrior on it. Teams\nwith less than 5 active warriors cannot be uploaded\nas set to run", "Team Settings Error", 0);
                    return;
                }
                if (!MainGui.this.clientData.getManager().validateTeamFights()) {
                    JOptionPane.showMessageDialog(MainGui.this.myFrame, "One of the teams you have specified to run\nthis turn has a single warrior in a team fight\nTeams with invalid team fight settings cannot\nbe uploaded as set to run.", "Team Settings Error", 0);
                    return;
                }
                if (MainGui.this.clientData.getManager().isActive()) {
                    ActiveTeamsCollectionVisitor activeTeamsVisitor = new ActiveTeamsCollectionVisitor();
                    MainGui.this.clientData.getManager().acceptTree(activeTeamsVisitor);
                    if (MainGui.this.clientData.getManager().getChildCount() > 0 && activeTeamsVisitor.getTeams().size() == 0) {
                        Object[] buttons = new Object[]{"Yes", "No"};
                        String msgText = "You have specified " + activeTeamsVisitor.getTeams().size() + " of your " + MainGui.this.clientData.getManager().getChildCount() + " teams to run next turn in your\n" + "team settings.  Do you still wish to proceed with this upload?";
                        int option = JOptionPane.showOptionDialog(MainGui.this.myFrame, msgText, "Team Settings Warning", 0, 2, null, buttons, buttons[1]);
                        if (option == 1) {
                            return;
                        }
                    }
                }
                if (!MainGui.this.clientData.getManager().isActive()) {
                    Object[] buttons = new Object[]{"Yes", "No"};
                    String msgText = "You have specified *NOT* to run next turn in your manager\nsettings.  Do you still wish to proceed with this upload?";
                    int option = JOptionPane.showOptionDialog(MainGui.this.myFrame, msgText, "Manager Settings Warning", 0, 2, null, buttons, buttons[1]);
                    if (option == 1) {
                        return;
                    }
                }
                UploadOperation upload = new UploadOperation(MainGui.this.clientData.getManager(), (Frame)MainGui.this.myFrame, MainGui.this);
                upload.start();
                upload.display(true);
            }
        });
        itemDownload.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (MainGui.this.clientData.getManager().getUploadNeeded()) {
                    Object[] buttons = new Object[]{"Yes", "No"};
                    String msgText = "You have made local changes that will be over-written by a\ndownload from the server.  Do you still wish to proceed\nwith this download?";
                    int option = JOptionPane.showOptionDialog(MainGui.this.myFrame, msgText, "Procedural Warning", 0, 2, null, buttons, buttons[1]);
                    if (option == 1) {
                        return;
                    }
                }
                DownloadOperation download = new DownloadOperation(MainGui.this.clientData.getManager(), (Frame)MainGui.this.myFrame, MainGui.this);
                download.start();
                download.display(true);
            }
        });
        itemChangePassword.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PasswordGui passwordGui = new PasswordGui(MainGui.this.clientData.getManager().getManagerNumber(), MainGui.this.myFrame, MainGui.this);
                passwordGui.display(true);
            }
        });
        this.itemHideWLK.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                ClientPreferences preferences = MainGui.this.getClientPreferences();
                preferences.setHideWLK(e.getStateChange() == 1);
                MainGui.this.allRefresh();
                ClientFileManager.saveClientPreferences(MainGui.this.clientData, preferences);
            }
        });
        itemAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AboutGui aboutGui = new AboutGui(MainGui.this.myFrame);
            }
        });
        this.mGui = new ManagerGui(this);
        this.tGui = new TeamGui(this);
        this.wGui = new WarriorGui(this);
        this.mtree = new JTree();
        this.mtreeRenderer = new ManagerDataTreeCellRenderer();
        this.mtreeRenderer.setFont(ClientGui.f1p);
        this.mtreeRenderer.setBackgroundSelectionColor(LIGHT_BROWN);
        this.mtreeRenderer.setBorderSelectionColor(BROWN);
        this.mtreePanel = new JPanel(new BorderLayout());
        this.mtreePanel.add(new JScrollPane(this.mtree));
        this.mtreePanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.mtree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)MainGui.this.mtree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                ((MainTreeAdapter)node.getUserObject()).userSelectEvent();
            }
        });
        this.dataPanelLayout = new CardLayout();
        this.dataPanel = new JPanel(this.dataPanelLayout);
        mainTop.setPreferredSize(this.dsm.getMainPanelDimension());
        mainTop.setMinimumSize(this.dsm.getMainPanelDimension());
        mainTop.add((Component)this.mtreePanel, "MTree");
        mainTop.add((Component)this.dataPanel, "Data");
        double mtreeWidthPercent = this.dsm.getMTreePanelWidth();
        mainLayout.addConstraint("MTree", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 0));
        mainLayout.addConstraint("MTree", AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.BOTTOM, 0));
        mainLayout.addConstraint("Data", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 0));
        mainLayout.addConstraint("Data", AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.BOTTOM, 0));
        mainLayout.addConstraint("MTree", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        mainLayout.addConstraint("Data", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, 0));
        mainLayout.addConstraint("MTree", AttributeType.RIGHT, new AxisConstraint("_container", AttributeAxis.HORIZONTAL, mtreeWidthPercent));
        mainLayout.addConstraint("Data", AttributeType.LEFT, new AttributeConstraint("MTree", AttributeType.RIGHT, 4));
        this.dataPanel.add((Component)this.mGui.getContentPane(), this.mGui.getScreenId());
        this.dataPanel.add((Component)this.tGui.getContentPane(), this.tGui.getScreenId());
        this.dataPanel.add((Component)this.wGui.getContentPane(), this.wGui.getScreenId());
        this.dataPanelLayout.layoutContainer(this.dataPanel);
        this.dataPanelLayout.first(this.dataPanel);
        return null;
    }

    public void finished() {
        this.observer.initCompletedEvent(this);
    }

    public JFrame getFrame() {
        return this.myFrame;
    }

    public void display(boolean flag) {
        if (this.clientData != null) {
            if (flag) {
                this.myFrame.pack();
                this.myFrame.setVisible(flag);
            } else {
                this.myFrame.dispose();
            }
        }
    }

    public DefaultMutableTreeNode createTree(ManagerDescriptor m) {
        ManagerMainTreeAdapter rootAdapter = new ManagerMainTreeAdapter(m, this.mGui);
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(rootAdapter);
        for (int i = 0; i < m.getChildCount(); ++i) {
            TeamDescriptor tempTeam = (TeamDescriptor)m.getChild(i);
            TeamMainTreeAdapter teamAdapter = new TeamMainTreeAdapter(tempTeam, this.tGui);
            DefaultMutableTreeNode teamNode = new DefaultMutableTreeNode(teamAdapter);
            rootNode.add(teamNode);
            for (int j = 0; j < tempTeam.getChildCount(); ++j) {
                WarriorDescriptor tempWarrior = (WarriorDescriptor)tempTeam.getChild(j);
                WarriorMainTreeAdapter warriorAdapter = new WarriorMainTreeAdapter(tempWarrior, this.getClientPreferences(), this.wGui);
                DefaultMutableTreeNode warriorNode = new DefaultMutableTreeNode(warriorAdapter);
                teamNode.add(warriorNode);
            }
        }
        return rootNode;
    }

    public synchronized void setClientDataFromLocal(ArenaCOM clientData) {
        this.saveNeeded = false;
        this.setClientData(clientData);
    }

    public synchronized void setClientDataFromRemote(ArenaCOM clientData) {
        this.saveNeeded = true;
        this.setClientData(clientData);
    }

    public void setClientData(ArenaCOM clientData) {
        this.clientData = clientData;
        ClientPreferences preferences = this.getClientPreferences();
        this.itemHideWLK.setSelected(preferences.getHideWLK());
        ((DefaultTreeModel)this.mtree.getModel()).setRoot(this.createTree(clientData.getManager()));
        if (this.mtree.getCellRenderer() != this.mtreeRenderer) {
            this.mtree.setCellRenderer(this.mtreeRenderer);
        }
        this.mGui.setClientData(clientData);
        this.tGui.setClientData(clientData);
        this.wGui.setClientData(clientData);
        this.mtree.setSelectionRow(0);
    }

    public void refreshClientDataEvent() {
        ((DefaultTreeModel)this.mtree.getModel()).reload();
        this.mGui.setClientData(this.clientData);
        this.tGui.setClientData(this.clientData);
        this.wGui.setClientData(this.clientData);
        this.mtree.setSelectionRow(0);
    }

    public void playerDataChangedEvent(int treeRefreshType) {
        if (treeRefreshType == 0) {
            this.treeRefresh();
        } else if (treeRefreshType == 2 && !this.clientData.getManager().getUploadNeeded()) {
            this.treeRefresh();
        }
        this.saveNeeded = true;
        this.clientData.getManager().setUploadNeeded(true);
    }

    public boolean isSaveNeeded() {
        return this.saveNeeded;
    }

    protected void allRefresh() {
        if (this.currentGui != null) {
            this.currentGui.refresh();
        }
        this.treeRefresh();
    }

    protected void treeRefresh() {
        this.mtree.repaint();
    }

    public void operationCompletedEvent(UploadOperation operation) {
        if (operation.getStatus() == UploadStatusEnum.SUCCESS) {
            this.setClientDataFromRemote(operation.getClientData());
            this.clientData.getManager().setUploadNeeded(false);
            if (operation == this.finalUpload) {
                this.finalSave = new SaveOperation(this.clientData, this);
                this.finalSave.start();
            }
        }
    }

    public void operationCompletedEvent(SaveOperation operation) {
        if (operation.getStatus() == SaveStatusEnum.SUCCESS) {
            this.saveNeeded = false;
        }
        if (operation == this.finalSave) {
            System.exit(0);
        }
    }

    public void operationCompletedEvent(DownloadOperation operation) {
        DownloadStatusEnum status = operation.getStatus();
        if (status == DownloadStatusEnum.SUCCESS) {
            this.setClientDataFromRemote(operation.getClientData());
            this.clientData.getManager().setUploadNeeded(false);
        }
    }

    public void changePasswordCompletedEvent(PasswordGui gui, ChangePasswordOperation operation) {
        if (operation.getStatus() == UploadStatusEnum.SUCCESS) {
            this.clientData.getManager().setPassword(gui.getNewPassword());
            SaveOperation save = new SaveOperation(this.clientData, this);
            save.start();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Observer {
        public void initCompletedEvent(MainGui var1);
    }

    protected class ManagerDataTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)value;
            MainTreeAdapter adapter = (MainTreeAdapter)n.getUserObject();
            this.setIcon(adapter.getIcon());
            this.setDisabledIcon(adapter.getIcon());
            return this;
        }
    }

    class WarriorMainTreeAdapter
    extends MainTreeAdapter {
        public WarriorMainTreeAdapter(WarriorDescriptor descriptor, ClientPreferences preferences, WarriorGui gui) {
            super(descriptor, preferences, gui);
            this.fileList = ClientFileManager.getFightList(descriptor);
        }
    }

    class TeamMainTreeAdapter
    extends MainTreeAdapter {
        public TeamMainTreeAdapter(TeamDescriptor descriptor, TeamGui gui) {
            super(descriptor, gui);
        }
    }

    class ManagerMainTreeAdapter
    extends MainTreeAdapter {
        public ManagerMainTreeAdapter(ManagerDescriptor descriptor, ManagerGui gui) {
            super(descriptor, gui);
            this.fileList = ClientFileManager.getNewsletterList((ArenaDescriptor)descriptor.getParent());
        }

        protected ImageIcon getIcon(ManagerDescriptor md) {
            ManagerCOM manager = (ManagerCOM)md;
            if (manager.getUploadNeeded()) {
                return manager.isActive() ? ACTIVE_MANAGER_UPLOAD_ICON : INACTIVE_MANAGER_UPLOAD_ICON;
            }
            return manager.isActive() ? ACTIVE_MANAGER_ICON : INACTIVE_MANAGER_ICON;
        }
    }

    abstract class MainTreeAdapter
    extends DescriptorDisplayAdapter {
        protected DependentGui gui;
        protected File[] fileList;

        public MainTreeAdapter(Descriptor descriptor, DependentGui gui) {
            super(descriptor);
            this.gui = gui;
            this.fileList = null;
        }

        public MainTreeAdapter(Descriptor descriptor, ClientPreferences preferences, DependentGui gui) {
            super(descriptor, preferences);
            this.gui = gui;
            this.fileList = null;
        }

        public void userSelectEvent() {
            this.gui.setTarget(this.descriptor, this.fileList);
            MainGui.this.currentGui = this.gui;
            MainGui.this.dataPanelLayout.show(MainGui.this.dataPanel, this.gui.getScreenId());
        }
    }
}

