/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.BPAsyncXMLDocLoader;
import client.BPComboBox;
import client.BPDisplayField;
import client.BPEmailField;
import client.BPTextField;
import client.ClientGui;
import client.DependentGui;
import client.DescriptorChooserGui;
import client.MainGui;
import client.NewTeamTableModel;
import client.data.ArenaCOM;
import client.data.ManagerCOM;
import client.data.TeamCOM;
import com.brunchboy.util.swing.relativelayout.AttributeAxis;
import com.brunchboy.util.swing.relativelayout.AttributeConstraint;
import com.brunchboy.util.swing.relativelayout.AttributeType;
import com.brunchboy.util.swing.relativelayout.AxisConstraint;
import com.brunchboy.util.swing.relativelayout.RelativeLayout;
import common.Constants;
import common.Descriptor;
import common.DescriptorCollectionVisitor;
import common.GenderEnum;
import common.NewTeamAdjustments;
import common.NewWarriorAdjustments;
import common.RaceEnum;
import common.RunEnum;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class ManagerGui
implements DependentGui,
Constants {
    private MainGui parentGui;
    private JTabbedPane managerTabbedPane;
    private ManagerCOM m;
    private BPAsyncXMLDocLoader docLoader;
    private File[] newsletters;
    private int newsIndex = 0;
    private NewTeamAdjustments newTeam = null;
    private BPDisplayField managerNameField;
    private BPDisplayField lastDownloadField;
    private BPDisplayField lastUploadField;
    private BPEmailField emailField;
    private BPDisplayField managerRecordField;
    private BPDisplayField managerNumberField;
    private BPDisplayField lastTurnRanField;
    private DocumentListener emailListener;
    private ActionListener runTypeListener;
    private BPComboBox runTypeField;
    private JTextArea mNewsText;
    private BPDisplayField mCurrentNewsField;
    private JButton mPrevNewsB;
    private JButton mNextNewsB;
    private JTable mNewTeamTable;
    private NewTeamTableModel newTeamTableModel;
    private BPTextField mTeamNameField;
    private JButton mTeamCreateButton;
    private JButton mTeamReplaceButton;
    private JPanel mNewWarriorPanel;
    private NewWarriorAdjustments newWarrior;
    private BPDisplayField nStrField;
    private BPDisplayField nDexField;
    private BPDisplayField nConField;
    private BPDisplayField nIntField;
    private BPDisplayField nPreField;
    private BPDisplayField nSizField;
    private JButton nStrDButton;
    private JButton nDexDButton;
    private JButton nConDButton;
    private JButton nIntDButton;
    private JButton nPreDButton;
    private JButton nSizDButton;
    private JButton nStrUButton;
    private JButton nDexUButton;
    private JButton nConUButton;
    private JButton nIntUButton;
    private JButton nPreUButton;
    private JButton nSizUButton;
    private BPTextField nNameField;
    private BPComboBox nRaceBox;
    private BPComboBox nGenderBox;
    private BPDisplayField nDistributeField;
    private JButton nResetButton;
    private JButton nSaveButton;

    public JTabbedPane getContentPane() {
        return this.managerTabbedPane;
    }

    public ManagerCOM getTarget() {
        return this.m;
    }

    public String getScreenId() {
        return "ManagerScreen";
    }

    public void setTarget(Descriptor d, File[] fileList) {
        ManagerCOM manager = (ManagerCOM)d;
        if (this.m != manager) {
            this.m = manager;
            this.newsletters = fileList;
            this.refresh();
        }
    }

    public void refresh() {
        if (this.m != null) {
            this.emailField.getDocument().removeDocumentListener(this.emailListener);
            this.runTypeField.removeActionListener(this.runTypeListener);
            if (this.m.getNewTeamBase() != null) {
                this.newTeamInitializeEvent();
            } else {
                this.newTeam = null;
            }
            this.attachManagerPanel();
            this.attachNewsPanel();
            this.attachNewTeamPanel();
            this.emailField.getDocument().addDocumentListener(this.emailListener);
            this.runTypeField.addActionListener(this.runTypeListener);
        }
    }

    public void setClientData(ArenaCOM clientData) {
        this.managerTabbedPane.setSelectedIndex(0);
    }

    protected void attachManagerPanel() {
        this.managerNameField.setText(this.m.getName());
        this.lastDownloadField.setText(this.m.getLastDownload().toString());
        this.lastUploadField.setText(this.m.getLastUpload().toString());
        this.emailField.setText(this.m.getEmailAddress());
        if (this.parentGui.getClientPreferences().getHideWLK()) {
            this.managerRecordField.setText("");
        } else {
            this.managerRecordField.setText(this.m.getRecordText());
        }
        this.managerNumberField.setText(this.m.getManagerNumber() + "");
        this.lastTurnRanField.setText(this.m.getLastTurnRan() + "");
        this.runTypeField.setSelectedItem(this.m.getRunNextTurn());
    }

    protected void attachNewsPanel() {
        this.newsIndex = this.newsletters.length - 1;
        this.attachNewsPane();
    }

    protected void attachNewsPane() {
        if (this.newsIndex >= 0 && this.newsIndex < this.newsletters.length) {
            try {
                this.docLoader = new BPAsyncXMLDocLoader(this.mCurrentNewsField, this.mNewsText, this.newsletters[this.newsIndex]);
                this.docLoader.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.mNewsText.setText("");
                this.mCurrentNewsField.setText("");
            }
        } else {
            this.mNewsText.setText("");
            this.mCurrentNewsField.setText("");
        }
    }

    protected void attachNewTeamPanel() {
        this.mNewTeamTable.getSelectionModel().clearSelection();
        if (this.newTeam == null || this.m.getNewTeamComplete() != null) {
            if (this.managerTabbedPane.getSelectedIndex() == 2) {
                this.managerTabbedPane.setSelectedIndex(0);
            }
            this.managerTabbedPane.setEnabledAt(2, false);
        } else {
            this.managerTabbedPane.setEnabledAt(2, true);
            this.newTeamTableModel.setNewTeam(this.newTeam);
            this.mTeamNameField.setText(this.newTeam.getName());
        }
        this.newTeamUpdatedEvent();
        this.newWarriorSelectedEvent();
    }

    public void newTeamInitializeEvent() {
        this.newTeam = new NewTeamAdjustments(this.m.getNewTeamBase());
        this.newTeam.resetTree();
    }

    protected void newTeamUpdatedEvent() {
        this.mTeamCreateButton.setEnabled(this.newTeam != null && this.m.getChildCount() < 5 ? this.newTeam.isCompleteAndValidTree() : false);
        this.mTeamReplaceButton.setEnabled(this.newTeam != null && this.m.getChildCount() > 0 ? this.newTeam.isCompleteAndValidTree() : false);
    }

    protected void newWarriorSelectedEvent() {
        if (this.getNewTeamSelectedRow() != -1) {
            this.newWarrior = (NewWarriorAdjustments)this.newTeam.getNewWarrior(this.getNewTeamSelectedRow()).clone();
            this.setEnabledNewWarriorPane(true);
        } else {
            this.newWarrior = null;
            this.setEnabledNewWarriorPane(false);
        }
        this.attachNewWarriorPanel();
    }

    protected void attachNewWarriorPanel() {
        if (this.newWarrior != null) {
            String tempStr = "";
            NewWarriorAdjustments w = this.newWarrior;
            tempStr = w.getStrAdd() == 0 ? w.getStr() + "" : w.getStr() + " (" + w.getBStr() + ")";
            this.nStrField.setText(tempStr);
            tempStr = w.getDexAdd() == 0 ? w.getDex() + "" : w.getDex() + " (" + w.getBDex() + ")";
            this.nDexField.setText(tempStr);
            tempStr = w.getConAdd() == 0 ? w.getCon() + "" : w.getCon() + " (" + w.getBCon() + ")";
            this.nConField.setText(tempStr);
            tempStr = w.getIntAdd() == 0 ? w.getInt() + "" : w.getInt() + " (" + w.getBInt() + ")";
            this.nIntField.setText(tempStr);
            tempStr = w.getPreAdd() == 0 ? w.getPre() + "" : w.getPre() + " (" + w.getBPre() + ")";
            this.nPreField.setText(tempStr);
            tempStr = w.getSizAdd() == 0 ? w.getSiz() + "" : w.getSiz() + " (" + w.getBSiz() + ")";
            this.nSizField.setText(tempStr);
            this.nNameField.setText(this.newWarrior.getName());
            this.nRaceBox.setSelectedItem(this.newWarrior.getRace());
            this.nGenderBox.setSelectedItem(this.newWarrior.getGender());
        }
        this.newWarriorUpdatedEvent();
    }

    protected void newWarriorUpdatedEvent() {
        if (this.newWarrior != null) {
            this.nDistributeField.setText(this.newWarrior.getPointsLeftToDistribute() + "");
            this.nSaveButton.setEnabled(this.newWarrior.isCompleteAndValidTree());
        }
    }

    protected void newWarriorResetEvent() {
        this.newTeam.getNewWarrior(this.getNewTeamSelectedRow()).reset();
        this.newWarrior = (NewWarriorAdjustments)this.newTeam.getNewWarrior(this.getNewTeamSelectedRow()).clone();
        this.newTeamTableModel.newTeamUpdatedEvent(this.getNewTeamSelectedRow());
        this.newTeamUpdatedEvent();
        this.attachNewWarriorPanel();
    }

    protected int getNewTeamSelectedRow() {
        return this.mNewTeamTable.getSelectionModel().getMinSelectionIndex();
    }

    protected void setEnabledNewWarriorPane(boolean flag) {
        this.mNewWarriorPanel.setVisible(flag);
    }

    public ManagerGui(MainGui parent) {
        this.parentGui = parent;
        this.managerTabbedPane = new JTabbedPane();
        this.managerTabbedPane.setFont(ClientGui.f1b);
        JPanel managerPane = new JPanel();
        JPanel mNewsPane = new JPanel();
        JPanel mNewTeamPane = new JPanel();
        this.managerTabbedPane.add("Account", managerPane);
        this.managerTabbedPane.add("Newsletters", mNewsPane);
        this.managerTabbedPane.add("New Team", mNewTeamPane);
        RelativeLayout managerPaneLayout = new RelativeLayout();
        managerPane.setLayout(managerPaneLayout);
        RelativeLayout mNewsPaneLayout = new RelativeLayout();
        mNewsPane.setLayout(mNewsPaneLayout);
        RelativeLayout mNewTeamPaneLayout = new RelativeLayout();
        mNewTeamPane.setLayout(mNewTeamPaneLayout);
        JPanel managerPanel = new JPanel();
        GridBagLayout ManagerLayout = new GridBagLayout();
        managerPanel.setLayout(ManagerLayout);
        Border managerPanelInnerEmptyBorder = BorderFactory.createEmptyBorder(0, 15, 6, 15);
        Border managerPanelEtchedBorder = BorderFactory.createEtchedBorder();
        CompoundBorder managerPanelEtchedEmptyBorder = BorderFactory.createCompoundBorder(managerPanelEtchedBorder, managerPanelInnerEmptyBorder);
        TitledBorder managerPanelTitledBorder = BorderFactory.createTitledBorder(managerPanelEtchedEmptyBorder, "Manager");
        managerPanel.setBorder(managerPanelTitledBorder);
        managerPane.add((Component)managerPanel, "managerPanel");
        JPanel ManagerP1 = new JPanel(new BorderLayout());
        JPanel ManagerP2 = new JPanel(new BorderLayout());
        GridBagConstraints gbConst1 = new GridBagConstraints();
        gbConst1.fill = 1;
        gbConst1.gridheight = 0;
        gbConst1.weightx = 3.0;
        gbConst1.weighty = 1.0;
        ManagerLayout.setConstraints(ManagerP1, gbConst1);
        managerPanel.add(ManagerP1);
        gbConst1.gridwidth = 0;
        gbConst1.weightx = 1.0;
        ManagerLayout.setConstraints(ManagerP2, gbConst1);
        managerPanel.add(ManagerP2);
        JPanel ManagerP1Labels = new JPanel(new GridLayout(0, 1));
        JPanel ManagerP1Fields = new JPanel(new GridLayout(0, 1));
        JPanel ManagerP2Labels = new JPanel(new GridLayout(0, 1));
        JPanel ManagerP2Fields = new JPanel(new GridLayout(0, 1));
        Border ManagerP1FieldsEmptyBorder = BorderFactory.createEmptyBorder(0, 4, 0, 35);
        Border ManagerP2FieldsEmptyBorder = BorderFactory.createEmptyBorder(0, 4, 0, 0);
        ManagerP1Fields.setBorder(ManagerP1FieldsEmptyBorder);
        ManagerP2Fields.setBorder(ManagerP2FieldsEmptyBorder);
        ManagerP1.add((Component)ManagerP1Labels, "West");
        ManagerP2.add((Component)ManagerP2Labels, "West");
        ManagerP1.add((Component)ManagerP1Fields, "Center");
        ManagerP2.add((Component)ManagerP2Fields, "Center");
        JLabel ManagerNameLabel = new JLabel("Name");
        JLabel lastUploadLabel = new JLabel("Last Upload");
        JLabel lastDownloadLabel = new JLabel("Last Download");
        JLabel emailLabel = new JLabel("Email Address");
        this.managerNameField = new BPDisplayField(22);
        this.lastUploadField = new BPDisplayField(22);
        this.lastDownloadField = new BPDisplayField(22);
        this.emailField = new BPEmailField(22, 36);
        ManagerP1Labels.add(ManagerNameLabel);
        ManagerP1Fields.add(this.managerNameField);
        ManagerP1Labels.add(lastUploadLabel);
        ManagerP1Fields.add(this.lastUploadField);
        ManagerP1Labels.add(lastDownloadLabel);
        ManagerP1Fields.add(this.lastDownloadField);
        ManagerP1Labels.add(emailLabel);
        ManagerP1Fields.add(this.emailField);
        JLabel ManagerRecordLabel = new JLabel("Record");
        JLabel ManagerNumberLabel = new JLabel("Account Number");
        JLabel lastTurnRanLabel = new JLabel("Last Turn Ran");
        JLabel runNextTurnLabel = new JLabel("Run Next Turn");
        this.managerRecordField = new BPDisplayField(22);
        this.managerNumberField = new BPDisplayField(22);
        this.lastTurnRanField = new BPDisplayField(22);
        this.runTypeField = new BPComboBox(RunEnum.values());
        ManagerP2Labels.add(ManagerRecordLabel);
        ManagerP2Fields.add(this.managerRecordField);
        ManagerP2Labels.add(ManagerNumberLabel);
        ManagerP2Fields.add(this.managerNumberField);
        ManagerP2Labels.add(lastTurnRanLabel);
        ManagerP2Fields.add(this.lastTurnRanField);
        ManagerP2Labels.add(runNextTurnLabel);
        ManagerP2Fields.add(this.runTypeField);
        this.managerNameField.setFont(ClientGui.f0b);
        this.lastUploadField.setFont(ClientGui.f0b);
        this.lastDownloadField.setFont(ClientGui.f0b);
        this.emailField.setFont(ClientGui.f0b);
        this.managerRecordField.setFont(ClientGui.f0b);
        this.managerNumberField.setFont(ClientGui.f0b);
        this.lastTurnRanField.setFont(ClientGui.f0b);
        managerPaneLayout.addConstraint("managerPanel", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 0));
        managerPaneLayout.addConstraint("managerPanel", AttributeType.WIDTH, new AttributeConstraint("_container", AttributeType.WIDTH, 0));
        managerPaneLayout.addConstraint("managerPanel", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        this.emailListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ManagerGui.this.m.setEmailAddress(ManagerGui.this.emailField.getText());
                ManagerGui.this.parentGui.playerDataChangedEvent(2);
            }

            public void removeUpdate(DocumentEvent e) {
                ManagerGui.this.m.setEmailAddress(ManagerGui.this.emailField.getText());
                ManagerGui.this.parentGui.playerDataChangedEvent(2);
            }

            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.emailField.getDocument().addDocumentListener(this.emailListener);
        this.runTypeListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ManagerGui.this.m.setRunNextTurn((RunEnum)ManagerGui.this.runTypeField.getSelectedItem());
                ManagerGui.this.parentGui.playerDataChangedEvent(0);
            }
        };
        this.runTypeField.addActionListener(this.runTypeListener);
        this.mNewsText = new JTextArea();
        this.mNewsText.setEditable(false);
        this.mNewsText.setBackground(Color.BLACK);
        this.mNewsText.setForeground(Color.WHITE);
        this.mNewsText.setFont(ClientGui.fixedWidthFont);
        JScrollPane mNewsScroll = new JScrollPane(this.mNewsText);
        mNewsScroll.setHorizontalScrollBarPolicy(31);
        MatteBorder mNewsScrollBorder = BorderFactory.createMatteBorder(3, 5, 3, 3, Color.BLACK);
        mNewsScroll.setBorder(mNewsScrollBorder);
        mNewsPane.add((Component)mNewsScroll, "mNewsScroll");
        Box mNewsControls = Box.createHorizontalBox();
        Border mNewsControlsBorder = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        mNewsControls.setBorder(mNewsControlsBorder);
        mNewsPane.add((Component)mNewsControls, "mNewsControls");
        this.mPrevNewsB = new JButton("Prev Newsletter");
        this.mCurrentNewsField = new BPDisplayField(15);
        this.mNextNewsB = new JButton("Next Newsletter");
        this.mCurrentNewsField.setHorizontalAlignment(0);
        mNewsControls.add(this.mPrevNewsB);
        mNewsControls.add(Box.createHorizontalStrut(30));
        mNewsControls.add(this.mCurrentNewsField);
        mNewsControls.add(Box.createHorizontalStrut(30));
        mNewsControls.add(this.mNextNewsB);
        mNewsPaneLayout.addConstraint("mNewsControls", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 5));
        mNewsPaneLayout.addConstraint("mNewsControls", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        mNewsPaneLayout.addConstraint("mNewsControls", AttributeType.WIDTH, new AttributeConstraint("_container", AttributeType.WIDTH, 0));
        mNewsPaneLayout.addConstraint("mNewsScroll", AttributeType.TOP, new AttributeConstraint("mNewsControls", AttributeType.BOTTOM, 0));
        mNewsPaneLayout.addConstraint("mNewsScroll", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        mNewsPaneLayout.addConstraint("mNewsScroll", AttributeType.WIDTH, new AttributeConstraint("_container", AttributeType.WIDTH, 0));
        mNewsPaneLayout.addConstraint("mNewsScroll", AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.BOTTOM, 0));
        this.mPrevNewsB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ManagerGui.this.newsIndex > 0) {
                    ManagerGui.this.newsIndex--;
                    ManagerGui.this.attachNewsPane();
                }
            }
        });
        this.mNextNewsB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ManagerGui.this.newsIndex < ManagerGui.this.newsletters.length - 1) {
                    ManagerGui.this.newsIndex++;
                    ManagerGui.this.attachNewsPane();
                }
            }
        });
        JPanel mNewTeamPanel = new JPanel(new BorderLayout());
        Border mNewTeamInnerEmptyBorder = BorderFactory.createEmptyBorder(6, 6, 6, 6);
        Border mNewTeamEtchedBorder = BorderFactory.createEtchedBorder();
        CompoundBorder mNewTeamEtchedEmptyBorder = BorderFactory.createCompoundBorder(mNewTeamEtchedBorder, mNewTeamInnerEmptyBorder);
        TitledBorder mNewTeamTitledBorder = BorderFactory.createTitledBorder(mNewTeamEtchedEmptyBorder, "New Team");
        mNewTeamPanel.setBorder(mNewTeamTitledBorder);
        mNewTeamPane.add((Component)mNewTeamPanel, "mNewTeamPanel");
        this.mNewTeamTable = new JTable(5, 9);
        this.newTeamTableModel = new NewTeamTableModel();
        this.mNewTeamTable.setModel(this.newTeamTableModel);
        mNewTeamPanel.add((Component)this.mNewTeamTable, "Center");
        this.mNewTeamTable.setColumnSelectionAllowed(false);
        this.mNewTeamTable.setRowHeight(24);
        this.mNewTeamTable.setFont(ClientGui.f1b);
        TableColumn column = this.mNewTeamTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(200);
        column.setHeaderValue("Warrior Name");
        column = this.mNewTeamTable.getColumnModel().getColumn(1);
        column.setPreferredWidth(70);
        column.setHeaderValue("Race");
        column = this.mNewTeamTable.getColumnModel().getColumn(2);
        column.setPreferredWidth(70);
        column.setHeaderValue("Gender");
        column = this.mNewTeamTable.getColumnModel().getColumn(3);
        column.setPreferredWidth(20);
        column.setHeaderValue("Str");
        column = this.mNewTeamTable.getColumnModel().getColumn(4);
        column.setPreferredWidth(20);
        column.setHeaderValue("Dex");
        column = this.mNewTeamTable.getColumnModel().getColumn(5);
        column.setPreferredWidth(20);
        column.setHeaderValue("Con");
        column = this.mNewTeamTable.getColumnModel().getColumn(6);
        column.setPreferredWidth(20);
        column.setHeaderValue("Int");
        column = this.mNewTeamTable.getColumnModel().getColumn(7);
        column.setPreferredWidth(20);
        column.setHeaderValue("Pre");
        column = this.mNewTeamTable.getColumnModel().getColumn(8);
        column.setPreferredWidth(20);
        column.setHeaderValue("Size");
        mNewTeamPanel.add((Component)this.mNewTeamTable.getTableHeader(), "North");
        JPanel mTeamDataPanel = new JPanel(new GridLayout(0, 2));
        Border mTeamDataEmptyBorder = BorderFactory.createEmptyBorder(15, 1, 6, 1);
        mTeamDataPanel.setBorder(mTeamDataEmptyBorder);
        mNewTeamPanel.add((Component)mTeamDataPanel, "South");
        JPanel mTeamNamePanel = new JPanel(new BorderLayout());
        RelativeLayout mTeamCreateLayout = new RelativeLayout();
        JPanel mTeamCreatePanel = new JPanel(mTeamCreateLayout);
        mTeamDataPanel.add(mTeamNamePanel);
        mTeamDataPanel.add(mTeamCreatePanel);
        JLabel mTeamNameLabel = new JLabel("Team Name");
        Border mTeamNameLabelBorder = BorderFactory.createEmptyBorder(0, 0, 0, 4);
        mTeamNameLabel.setBorder(mTeamNameLabelBorder);
        mTeamDataPanel.setBorder(mTeamDataEmptyBorder);
        this.mTeamNameField = new BPTextField(30, 20);
        mTeamNamePanel.add((Component)mTeamNameLabel, "West");
        mTeamNamePanel.add(this.mTeamNameField);
        JLabel mTeamCreateLabel = new JLabel("Create Team as");
        this.mTeamCreateButton = new JButton("New");
        this.mTeamReplaceButton = new JButton("Replacement");
        mTeamCreatePanel.add((Component)mTeamCreateLabel, "Label");
        mTeamCreatePanel.add((Component)this.mTeamCreateButton, "New");
        mTeamCreatePanel.add((Component)this.mTeamReplaceButton, "Replacement");
        mTeamCreateLayout.addConstraint("Label", AttributeType.VERTICAL_CENTER, new AxisConstraint("_container", AttributeAxis.VERTICAL, 0.5));
        mTeamCreateLayout.addConstraint("New", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 0));
        mTeamCreateLayout.addConstraint("New", AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.BOTTOM, 0));
        mTeamCreateLayout.addConstraint("Replacement", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 0));
        mTeamCreateLayout.addConstraint("Replacement", AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.BOTTOM, 0));
        mTeamCreateLayout.addConstraint("Label", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 28));
        mTeamCreateLayout.addConstraint("New", AttributeType.LEFT, new AttributeConstraint("Label", AttributeType.RIGHT, 12));
        mTeamCreateLayout.addConstraint("Replacement", AttributeType.LEFT, new AttributeConstraint("New", AttributeType.RIGHT, 5));
        mTeamCreateLayout.addConstraint("Replacement", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, 0));
        this.mNewTeamTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    ManagerGui.this.newWarriorSelectedEvent();
                } else {
                    ManagerGui.this.newWarriorSelectedEvent();
                }
            }
        });
        this.mTeamNameField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ManagerGui.this.newTeam.setName(ManagerGui.this.mTeamNameField.getText());
                ManagerGui.this.newTeamUpdatedEvent();
            }

            public void removeUpdate(DocumentEvent e) {
                ManagerGui.this.newTeam.setName(ManagerGui.this.mTeamNameField.getText());
                ManagerGui.this.newTeamUpdatedEvent();
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.mTeamCreateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ManagerGui.this.m.createTeamAsNew(ManagerGui.this.newTeam);
                ManagerGui.this.refresh();
                ManagerGui.this.parentGui.playerDataChangedEvent(2);
            }
        });
        this.mTeamReplaceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DescriptorCollectionVisitor dcv = new DescriptorCollectionVisitor();
                ManagerGui.this.m.acceptTree(dcv);
                TeamCOM replaceableTeam = (TeamCOM)DescriptorChooserGui.show("Team to Replace", dcv.getTeams(), ManagerGui.this.parentGui.getFrame());
                if (replaceableTeam != null) {
                    ManagerGui.this.m.createTeamAsReplacement(replaceableTeam, ManagerGui.this.newTeam);
                    ManagerGui.this.refresh();
                    ManagerGui.this.parentGui.refreshClientDataEvent();
                }
            }
        });
        this.mNewWarriorPanel = new JPanel();
        GridBagLayout mNewWarriorLayout = new GridBagLayout();
        this.mNewWarriorPanel.setLayout(mNewWarriorLayout);
        Border mNewWarriorInnerEmptyBorder = BorderFactory.createEmptyBorder(0, 10, 6, 10);
        Border mNewWarriorEtchedBorder = BorderFactory.createEtchedBorder();
        CompoundBorder mNewWarriorEtchedEmptyBorder = BorderFactory.createCompoundBorder(mNewWarriorEtchedBorder, mNewWarriorInnerEmptyBorder);
        TitledBorder mNewWarriorTitledBorder = BorderFactory.createTitledBorder(mNewWarriorEtchedEmptyBorder, "New Warrior");
        this.mNewWarriorPanel.setBorder(mNewWarriorTitledBorder);
        mNewTeamPane.add((Component)this.mNewWarriorPanel, "mNewWarriorPanel");
        JPanel mNewWarriorP1 = new JPanel(new BorderLayout());
        JPanel mNewWarriorP2 = new JPanel(new BorderLayout());
        JPanel mNewWarriorP3 = new JPanel();
        GridBagLayout mNewWarriorP3Layout = new GridBagLayout();
        mNewWarriorP3.setLayout(mNewWarriorP3Layout);
        gbConst1 = new GridBagConstraints();
        gbConst1.fill = 1;
        gbConst1.weightx = 1.0;
        gbConst1.weighty = 1.0;
        gbConst1.gridwidth = 1;
        gbConst1.gridheight = 2;
        mNewWarriorLayout.setConstraints(mNewWarriorP1, gbConst1);
        this.mNewWarriorPanel.add(mNewWarriorP1);
        gbConst1.gridwidth = 0;
        gbConst1.gridheight = 1;
        mNewWarriorLayout.setConstraints(mNewWarriorP2, gbConst1);
        this.mNewWarriorPanel.add(mNewWarriorP2);
        mNewWarriorLayout.setConstraints(mNewWarriorP3, gbConst1);
        this.mNewWarriorPanel.add(mNewWarriorP3);
        JPanel mNewWarriorP1Labels = new JPanel(new GridLayout(0, 1));
        JPanel mNewWarriorP1Fields = new JPanel(new GridLayout(0, 1));
        JPanel mNewWarriorP1Buttons = new JPanel(new GridLayout(0, 2));
        Border mNewWarriorP1FieldsBorder = BorderFactory.createEmptyBorder(0, 4, 0, 10);
        Border mNewWarriorP1ButtonsBorder = BorderFactory.createEmptyBorder(0, 0, 0, 30);
        mNewWarriorP1Fields.setBorder(mNewWarriorP1FieldsBorder);
        mNewWarriorP1Buttons.setBorder(mNewWarriorP1ButtonsBorder);
        mNewWarriorP1.add((Component)mNewWarriorP1Labels, "West");
        mNewWarriorP1.add((Component)mNewWarriorP1Fields, "Center");
        mNewWarriorP1.add((Component)mNewWarriorP1Buttons, "East");
        JLabel nStrLabel = new JLabel("Strength");
        JLabel nDexLabel = new JLabel("Dexterity");
        JLabel nConLabel = new JLabel("Constitution");
        JLabel nIntLabel = new JLabel("Intelligence");
        JLabel nPreLabel = new JLabel("Presence");
        JLabel nSizLabel = new JLabel("Size");
        this.nStrField = new BPDisplayField(7);
        this.nDexField = new BPDisplayField(7);
        this.nConField = new BPDisplayField(7);
        this.nIntField = new BPDisplayField(7);
        this.nPreField = new BPDisplayField(7);
        this.nSizField = new BPDisplayField(7);
        this.nStrDButton = new JButton("-");
        this.nDexDButton = new JButton("-");
        this.nConDButton = new JButton("-");
        this.nIntDButton = new JButton("-");
        this.nPreDButton = new JButton("-");
        this.nSizDButton = new JButton("-");
        this.nStrUButton = new JButton("+");
        this.nDexUButton = new JButton("+");
        this.nConUButton = new JButton("+");
        this.nIntUButton = new JButton("+");
        this.nPreUButton = new JButton("+");
        this.nSizUButton = new JButton("+");
        Border mNewWarriorInnerBB = BorderFactory.createEmptyBorder(0, 3, 0, 3);
        Border mNewWarriorBevelBB = BorderFactory.createEtchedBorder();
        Border mNewWarriorOuterBB = BorderFactory.createEmptyBorder(2, 3, 2, 3);
        CompoundBorder mNewWarriorButtonBorder = BorderFactory.createCompoundBorder(mNewWarriorBevelBB, mNewWarriorInnerBB);
        mNewWarriorButtonBorder = BorderFactory.createCompoundBorder(mNewWarriorOuterBB, mNewWarriorButtonBorder);
        this.nStrDButton.setBorder(mNewWarriorButtonBorder);
        this.nDexDButton.setBorder(mNewWarriorButtonBorder);
        this.nConDButton.setBorder(mNewWarriorButtonBorder);
        this.nIntDButton.setBorder(mNewWarriorButtonBorder);
        this.nPreDButton.setBorder(mNewWarriorButtonBorder);
        this.nSizDButton.setBorder(mNewWarriorButtonBorder);
        this.nStrUButton.setBorder(mNewWarriorButtonBorder);
        this.nDexUButton.setBorder(mNewWarriorButtonBorder);
        this.nConUButton.setBorder(mNewWarriorButtonBorder);
        this.nIntUButton.setBorder(mNewWarriorButtonBorder);
        this.nPreUButton.setBorder(mNewWarriorButtonBorder);
        this.nSizUButton.setBorder(mNewWarriorButtonBorder);
        mNewWarriorP1Labels.add(nStrLabel);
        mNewWarriorP1Labels.add(nDexLabel);
        mNewWarriorP1Labels.add(nConLabel);
        mNewWarriorP1Labels.add(nIntLabel);
        mNewWarriorP1Labels.add(nPreLabel);
        mNewWarriorP1Labels.add(nSizLabel);
        mNewWarriorP1Fields.add(this.nStrField);
        mNewWarriorP1Fields.add(this.nDexField);
        mNewWarriorP1Fields.add(this.nConField);
        mNewWarriorP1Fields.add(this.nIntField);
        mNewWarriorP1Fields.add(this.nPreField);
        mNewWarriorP1Fields.add(this.nSizField);
        mNewWarriorP1Buttons.add(this.nStrDButton);
        mNewWarriorP1Buttons.add(this.nStrUButton);
        mNewWarriorP1Buttons.add(this.nDexDButton);
        mNewWarriorP1Buttons.add(this.nDexUButton);
        mNewWarriorP1Buttons.add(this.nConDButton);
        mNewWarriorP1Buttons.add(this.nConUButton);
        mNewWarriorP1Buttons.add(this.nIntDButton);
        mNewWarriorP1Buttons.add(this.nIntUButton);
        mNewWarriorP1Buttons.add(this.nPreDButton);
        mNewWarriorP1Buttons.add(this.nPreUButton);
        mNewWarriorP1Buttons.add(this.nSizDButton);
        mNewWarriorP1Buttons.add(this.nSizUButton);
        JPanel mNewWarriorP2Labels = new JPanel(new GridLayout(0, 1));
        JPanel mNewWarriorP2Fields = new JPanel(new GridLayout(0, 1));
        Border mNewWarriorP2LabelsBorder = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        Border mNewWarriorP2FieldsBorder = BorderFactory.createEmptyBorder(0, 4, 0, 0);
        mNewWarriorP2Fields.setBorder(mNewWarriorP2FieldsBorder);
        mNewWarriorP2.add((Component)mNewWarriorP2Labels, "West");
        mNewWarriorP2.add((Component)mNewWarriorP2Fields, "Center");
        JLabel nNameLabel = new JLabel("Name");
        JLabel nRaceLabel = new JLabel("Race");
        JLabel nGenderLabel = new JLabel("Gender");
        this.nNameField = new BPTextField(25, 20);
        this.nRaceBox = new BPComboBox(RaceEnum.publicValues());
        this.nGenderBox = new BPComboBox(GenderEnum.values());
        mNewWarriorP2Labels.add(nNameLabel);
        mNewWarriorP2Labels.add(nRaceLabel);
        mNewWarriorP2Labels.add(nGenderLabel);
        mNewWarriorP2Fields.add(this.nNameField);
        mNewWarriorP2Fields.add(this.nRaceBox);
        mNewWarriorP2Fields.add(this.nGenderBox);
        Border mNewWarriorP3Border1 = BorderFactory.createEmptyBorder(6, 4, 4, 4);
        Border mNewWarriorP3Border2 = BorderFactory.createLineBorder(Color.black);
        Border mNewWarriorP3Border3 = BorderFactory.createEmptyBorder(8, 48, 0, 0);
        CompoundBorder mNewWarriorP3Border = BorderFactory.createCompoundBorder(mNewWarriorP3Border2, mNewWarriorP3Border1);
        mNewWarriorP3Border = BorderFactory.createCompoundBorder(mNewWarriorP3Border3, mNewWarriorP3Border);
        mNewWarriorP3.setBorder(mNewWarriorP3Border);
        JLabel nDistributeLabel = new JLabel("Points Left to Distribute");
        this.nDistributeField = new BPDisplayField(5);
        this.nResetButton = new JButton("Reset");
        this.nSaveButton = new JButton("Save");
        this.nDistributeField.setHorizontalAlignment(0);
        Border mNewWarriorP3Border4 = BorderFactory.createEmptyBorder(4, 6, 4, 6);
        Border mNewWarriorP3Border5 = BorderFactory.createRaisedBevelBorder();
        Border mNewWarriorP3Border6 = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        Border mNewWarriorP3Border7 = BorderFactory.createEmptyBorder(4, 8, 4, 8);
        Border mNewWarriorP3Border8 = BorderFactory.createRaisedBevelBorder();
        Border mNewWarriorP3Border9 = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        gbConst1.fill = 0;
        gbConst1.weightx = 1.0;
        gbConst1.weighty = 1.0;
        gbConst1.gridwidth = 0;
        gbConst1.gridheight = 1;
        mNewWarriorP3Layout.setConstraints(nDistributeLabel, gbConst1);
        mNewWarriorP3.add(nDistributeLabel);
        mNewWarriorP3Layout.setConstraints(this.nDistributeField, gbConst1);
        mNewWarriorP3.add(this.nDistributeField);
        gbConst1.gridwidth = -1;
        mNewWarriorP3Layout.setConstraints(this.nResetButton, gbConst1);
        mNewWarriorP3.add(this.nResetButton);
        gbConst1.gridwidth = 0;
        mNewWarriorP3Layout.setConstraints(this.nSaveButton, gbConst1);
        mNewWarriorP3.add(this.nSaveButton);
        this.nSaveButton.setEnabled(false);
        this.nStrField.setFont(ClientGui.f0b);
        this.nDexField.setFont(ClientGui.f0b);
        this.nConField.setFont(ClientGui.f0b);
        this.nIntField.setFont(ClientGui.f0b);
        this.nPreField.setFont(ClientGui.f0b);
        this.nSizField.setFont(ClientGui.f0b);
        this.nNameField.setFont(ClientGui.f0b);
        this.nDistributeField.setFont(ClientGui.f0b);
        mNewTeamPaneLayout.addConstraint("mNewTeamPanel", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 0));
        mNewTeamPaneLayout.addConstraint("mNewTeamPanel", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        mNewTeamPaneLayout.addConstraint("mNewTeamPanel", AttributeType.WIDTH, new AttributeConstraint("_container", AttributeType.WIDTH, 0));
        mNewTeamPaneLayout.addConstraint("mNewWarriorPanel", AttributeType.TOP, new AttributeConstraint("mNewTeamPanel", AttributeType.BOTTOM, 5));
        mNewTeamPaneLayout.addConstraint("mNewWarriorPanel", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        mNewTeamPaneLayout.addConstraint("mNewWarriorPanel", AttributeType.WIDTH, new AttributeConstraint("_container", AttributeType.WIDTH, 0));
        this.nStrDButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ManagerGui.this.newWarrior.decrementStr()) {
                    NewWarriorAdjustments w = ManagerGui.this.newWarrior;
                    ManagerGui.this.nStrField.setText(w.getStrAdd() == 0 ? w.getStr() + "" : w.getStr() + " (" + w.getBStr() + ")");
                    ManagerGui.this.newWarriorUpdatedEvent();
                }
            }
        });
        this.nStrUButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ManagerGui.this.newWarrior.incrementStr()) {
                    NewWarriorAdjustments w = ManagerGui.this.newWarrior;
                    ManagerGui.this.nStrField.setText(w.getStrAdd() == 0 ? w.getStr() + "" : w.getStr() + " (" + w.getBStr() + ")");
                    ManagerGui.this.newWarriorUpdatedEvent();
                }
            }
        });
        this.nDexDButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ManagerGui.this.newWarrior.decrementDex()) {
                    NewWarriorAdjustments w = ManagerGui.this.newWarrior;
                    ManagerGui.this.nDexField.setText(w.getDexAdd() == 0 ? w.getDex() + "" : w.getDex() + " (" + w.getBDex() + ")");
                    ManagerGui.this.newWarriorUpdatedEvent();
                }
            }
        });
        this.nDexUButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ManagerGui.this.newWarrior.incrementDex()) {
                    NewWarriorAdjustments w = ManagerGui.this.newWarrior;
                    ManagerGui.this.nDexField.setText(w.getDexAdd() == 0 ? w.getDex() + "" : w.getDex() + " (" + w.getBDex() + ")");
                    ManagerGui.this.newWarriorUpdatedEvent();
                }
            }
        });
        this.nConDButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ManagerGui.this.newWarrior.decrementCon()) {
                    NewWarriorAdjustments w = ManagerGui.this.newWarrior;
                    ManagerGui.this.nConField.setText(w.getConAdd() == 0 ? w.getCon() + "" : w.getCon() + " (" + w.getBCon() + ")");
                    ManagerGui.this.newWarriorUpdatedEvent();
                }
            }
        });
        this.nConUButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ManagerGui.this.newWarrior.incrementCon()) {
                    NewWarriorAdjustments w = ManagerGui.this.newWarrior;
                    ManagerGui.this.nConField.setText(w.getConAdd() == 0 ? w.getCon() + "" : w.getCon() + " (" + w.getBCon() + ")");
                    ManagerGui.this.newWarriorUpdatedEvent();
                }
            }
        });
        this.nIntDButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ManagerGui.this.newWarrior.decrementInt()) {
                    NewWarriorAdjustments w = ManagerGui.this.newWarrior;
                    ManagerGui.this.nIntField.setText(w.getIntAdd() == 0 ? w.getInt() + "" : w.getInt() + " (" + w.getBInt() + ")");
                    ManagerGui.this.newWarriorUpdatedEvent();
                }
            }
        });
        this.nIntUButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ManagerGui.this.newWarrior.incrementInt()) {
                    NewWarriorAdjustments w = ManagerGui.this.newWarrior;
                    ManagerGui.this.nIntField.setText(w.getIntAdd() == 0 ? w.getInt() + "" : w.getInt() + " (" + w.getBInt() + ")");
                    ManagerGui.this.newWarriorUpdatedEvent();
                }
            }
        });
        this.nPreDButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ManagerGui.this.newWarrior.decrementPre()) {
                    NewWarriorAdjustments w = ManagerGui.this.newWarrior;
                    ManagerGui.this.nPreField.setText(w.getPreAdd() == 0 ? w.getPre() + "" : w.getPre() + " (" + w.getBPre() + ")");
                    ManagerGui.this.newWarriorUpdatedEvent();
                }
            }
        });
        this.nPreUButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ManagerGui.this.newWarrior.incrementPre()) {
                    NewWarriorAdjustments w = ManagerGui.this.newWarrior;
                    ManagerGui.this.nPreField.setText(w.getPreAdd() == 0 ? w.getPre() + "" : w.getPre() + " (" + w.getBPre() + ")");
                    ManagerGui.this.newWarriorUpdatedEvent();
                }
            }
        });
        this.nSizDButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ManagerGui.this.newWarrior.decrementSiz()) {
                    NewWarriorAdjustments w = ManagerGui.this.newWarrior;
                    ManagerGui.this.nSizField.setText(w.getSizAdd() == 0 ? w.getSiz() + "" : w.getSiz() + " (" + w.getBSiz() + ")");
                    ManagerGui.this.newWarriorUpdatedEvent();
                }
            }
        });
        this.nSizUButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ManagerGui.this.newWarrior.incrementSiz()) {
                    NewWarriorAdjustments w = ManagerGui.this.newWarrior;
                    ManagerGui.this.nSizField.setText(w.getSizAdd() == 0 ? w.getSiz() + "" : w.getSiz() + " (" + w.getBSiz() + ")");
                    ManagerGui.this.newWarriorUpdatedEvent();
                }
            }
        });
        this.nNameField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ManagerGui.this.newWarrior.setName(ManagerGui.this.nNameField.getText());
                ManagerGui.this.newWarriorUpdatedEvent();
            }

            public void removeUpdate(DocumentEvent e) {
                ManagerGui.this.newWarrior.setName(ManagerGui.this.nNameField.getText());
                ManagerGui.this.newWarriorUpdatedEvent();
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.nRaceBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ManagerGui.this.newWarrior.setRace((RaceEnum)ManagerGui.this.nRaceBox.getSelectedItem());
            }
        });
        this.nGenderBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ManagerGui.this.newWarrior.setGender((GenderEnum)ManagerGui.this.nGenderBox.getSelectedItem());
            }
        });
        this.nResetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ManagerGui.this.newWarriorResetEvent();
            }
        });
        this.nSaveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ManagerGui.this.newTeam.setNewWarrior(ManagerGui.this.getNewTeamSelectedRow(), (NewWarriorAdjustments)ManagerGui.this.newWarrior.clone());
                ManagerGui.this.newTeamTableModel.newTeamUpdatedEvent(ManagerGui.this.getNewTeamSelectedRow());
                ManagerGui.this.newTeamUpdatedEvent();
                ManagerGui.this.mNewTeamTable.getSelectionModel().clearSelection();
            }
        });
    }
}

