/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ClientFileManager;
import client.SaveStatusEnum;
import client.SwingWorkerII;
import client.data.ArenaCOM;
import java.io.FileNotFoundException;
import java.io.IOException;

public class SaveOperation
extends SwingWorkerII {
    private Observer observer;
    private ArenaCOM clientData;
    private SaveStatusEnum status = SaveStatusEnum.NONE;

    public SaveOperation(ArenaCOM clientData, Observer observer) {
        this.clientData = clientData;
        this.observer = observer;
    }

    public Object construct() {
        try {
            ClientFileManager.savePlayerData(this.clientData);
            this.status = SaveStatusEnum.SUCCESS;
        }
        catch (FileNotFoundException e) {
            this.status = SaveStatusEnum.FILE_NOT_FOUND;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.status = SaveStatusEnum.UNEXPECTED_ERROR;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.status = SaveStatusEnum.UNEXPECTED_ERROR;
        }
        return null;
    }

    public void finished() {
        this.observer.operationCompletedEvent(this);
    }

    public SaveStatusEnum getStatus() {
        return this.status;
    }

    public static interface Observer {
        public void operationCompletedEvent(SaveOperation var1);
    }
}

