/*
 * Decompiled with CFR 0.152.
 */
package client;

import java.io.Serializable;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.Vector;

public class SaveStatusEnum
implements Serializable,
Comparable {
    private static TreeMap VALUE2NAME = new TreeMap();
    private static HashMap NAME2VALUE = new HashMap();
    public static int MIN_VALUE = Integer.MAX_VALUE;
    public static int MAX_VALUE = Integer.MIN_VALUE;
    public static SaveStatusEnum NONE = new SaveStatusEnum(0, "None", "No load status available");
    public static SaveStatusEnum SUCCESS = new SaveStatusEnum(1, "Success", "Load operation succeeded");
    public static SaveStatusEnum FILE_NOT_FOUND = new SaveStatusEnum(2, "File Not Found", "File not found");
    public static SaveStatusEnum UNEXPECTED_ERROR = new SaveStatusEnum(3, "Unexpected Error", "Stack trace in debug log");
    private Integer value;
    private String name;
    private String description;

    protected SaveStatusEnum(int value, String name) {
        this.value = new Integer(value);
        this.name = name;
        this.description = name;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    protected SaveStatusEnum(int value, String name, String description) {
        this.value = new Integer(value);
        this.name = name;
        this.description = description;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    public static boolean contains(String name) {
        return NAME2VALUE.containsKey(name);
    }

    public static boolean contains(int value) {
        return VALUE2NAME.containsKey(new Integer(value));
    }

    public static int valueOf(String name) {
        return ((SaveStatusEnum)NAME2VALUE.get(name)).value();
    }

    public static String nameOf(int value) {
        return ((SaveStatusEnum)VALUE2NAME.get(new Integer(value))).name();
    }

    public static SaveStatusEnum get(String name) {
        return (SaveStatusEnum)NAME2VALUE.get(name);
    }

    public static SaveStatusEnum get(int value) {
        return (SaveStatusEnum)VALUE2NAME.get(new Integer(value));
    }

    public int value() {
        return this.value;
    }

    public String name() {
        return this.name;
    }

    public int compareTo(Object o) {
        Integer anIntegerValue = ((SaveStatusEnum)o).value;
        return this.value.compareTo(anIntegerValue);
    }

    public static Vector values() {
        Vector<SaveStatusEnum> v = new Vector<SaveStatusEnum>(MAX_VALUE);
        for (int i = MIN_VALUE; i <= MAX_VALUE; ++i) {
            v.add(SaveStatusEnum.get(i));
        }
        return v;
    }

    public String toString() {
        return this.description;
    }

    public String toStringFull() {
        return super.toString() + " Name=" + this.name + " Value=" + this.value.toString();
    }
}

