/*
 * Decompiled with CFR 0.152.
 */
package client;

import javax.swing.SwingUtilities;

public abstract class SwingWorkerII {
    private Object value;
    private Thread thread;
    private boolean hasRun = false;
    private boolean hasFinished = false;
    private ThreadVar threadVar;

    protected synchronized Object getValue() {
        return this.value;
    }

    private synchronized void setValue(Object x) {
        this.value = x;
    }

    public abstract Object construct();

    public void finished() {
    }

    public void interrupt() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.interrupt();
        }
        this.threadVar.clear();
    }

    public Object get() {
        Thread t;
        while ((t = this.threadVar.get()) != null) {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        return this.getValue();
    }

    public SwingWorkerII() {
        final Runnable doFinished = new Runnable(){

            public void run() {
                SwingWorkerII.this.finished();
                SwingWorkerII.this.hasFinished = true;
            }
        };
        Runnable doConstruct = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    SwingWorkerII.this.setValue(SwingWorkerII.this.construct());
                }
                finally {
                    SwingWorkerII.this.threadVar.clear();
                }
                SwingWorkerII.this.hasRun = true;
                SwingUtilities.invokeLater(doFinished);
            }
        };
        Thread t = new Thread(doConstruct);
        this.threadVar = new ThreadVar(t);
    }

    public void start() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.start();
        }
    }

    public boolean hasRun() {
        return this.hasRun;
    }

    public boolean hasFinished() {
        return this.hasFinished;
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread t) {
            this.thread = t;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

