/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.BPDisplayField;
import client.ClientGui;
import client.DependentGui;
import client.MainGui;
import client.data.ArenaCOM;
import client.data.TeamCOM;
import com.brunchboy.util.swing.relativelayout.AttributeConstraint;
import com.brunchboy.util.swing.relativelayout.AttributeType;
import com.brunchboy.util.swing.relativelayout.RelativeLayout;
import common.Descriptor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class TeamGui
implements DependentGui {
    private MainGui parentGui;
    private JPanel teamPane;
    private TeamCOM t;
    private BPDisplayField teamNameField;
    private BPDisplayField teamNumberField;
    private BPDisplayField teamRecordField;
    private BPDisplayField teamTurnField;
    private JCheckBox teamRunButton;
    private ItemListener teamRunListener;

    public JPanel getContentPane() {
        return this.teamPane;
    }

    public TeamCOM getTarget() {
        return this.t;
    }

    public String getScreenId() {
        return "TeamScreen";
    }

    public void setTarget(Descriptor d, File[] fileList) {
        TeamCOM team = (TeamCOM)d;
        if (this.t != team) {
            this.t = team;
            this.refresh();
        }
    }

    public void refresh() {
        this.teamRunButton.removeItemListener(this.teamRunListener);
        this.teamNameField.setText(this.t.getName());
        String teamNumberStr = new Integer(this.t.getTeamNumber()).toString();
        this.teamNumberField.setText(teamNumberStr);
        if (this.parentGui.getClientPreferences().getHideWLK()) {
            this.teamRecordField.setText("");
        } else {
            this.teamRecordField.setText(this.t.getRecordText());
        }
        String lastRanStr = this.t.getLastTurnRan().toString();
        this.teamTurnField.setText(lastRanStr);
        this.teamRunButton.setSelected(this.t.isActive());
        this.teamRunButton.addItemListener(this.teamRunListener);
    }

    public void setClientData(ArenaCOM clientData) {
    }

    public TeamGui(MainGui parent) {
        this.parentGui = parent;
        this.teamPane = new JPanel();
        RelativeLayout teamPaneLayout = new RelativeLayout();
        this.teamPane.setLayout(teamPaneLayout);
        JPanel teamPanel = new JPanel();
        GridBagLayout teamLayout = new GridBagLayout();
        teamPanel.setLayout(teamLayout);
        Border teamPanelInnerEmptyBorder = BorderFactory.createEmptyBorder(0, 15, 6, 15);
        Border teamPanelEtchedBorder = BorderFactory.createEtchedBorder();
        CompoundBorder teamPanelEtchedEmptyBorder = BorderFactory.createCompoundBorder(teamPanelEtchedBorder, teamPanelInnerEmptyBorder);
        TitledBorder teamPanelTitledBorder = BorderFactory.createTitledBorder(teamPanelEtchedEmptyBorder, "Team");
        teamPanel.setBorder(teamPanelTitledBorder);
        this.teamPane.add((Component)teamPanel, "teamPanel");
        JPanel teamP1 = new JPanel(new BorderLayout());
        JPanel teamP2 = new JPanel(new BorderLayout());
        GridBagConstraints gbConst1 = new GridBagConstraints();
        gbConst1.fill = 1;
        gbConst1.gridheight = 0;
        gbConst1.weightx = 3.0;
        gbConst1.weighty = 1.0;
        teamLayout.setConstraints(teamP1, gbConst1);
        teamPanel.add(teamP1);
        gbConst1.gridwidth = 0;
        gbConst1.weightx = 1.0;
        teamLayout.setConstraints(teamP2, gbConst1);
        teamPanel.add(teamP2);
        JPanel teamP1Labels = new JPanel(new GridLayout(0, 1));
        JPanel teamP1Fields = new JPanel(new GridLayout(0, 1));
        JPanel teamP2Labels = new JPanel(new GridLayout(0, 1));
        JPanel teamP2Fields = new JPanel(new GridLayout(0, 1));
        Border teamP1FieldsEmptyBorder = BorderFactory.createEmptyBorder(0, 4, 0, 35);
        Border teamP2FieldsEmptyBorder = BorderFactory.createEmptyBorder(0, 4, 0, 0);
        teamP1Fields.setBorder(teamP1FieldsEmptyBorder);
        teamP2Fields.setBorder(teamP2FieldsEmptyBorder);
        teamP1.add((Component)teamP1Labels, "West");
        teamP2.add((Component)teamP2Labels, "West");
        teamP1.add((Component)teamP1Fields, "Center");
        teamP2.add((Component)teamP2Fields, "Center");
        JLabel teamNameLabel = new JLabel("Name");
        JLabel teamRecordLabel = new JLabel("Record");
        JLabel teamNumberLabel = new JLabel("Team Number");
        this.teamNameField = new BPDisplayField(29);
        this.teamRecordField = new BPDisplayField(14);
        this.teamNumberField = new BPDisplayField(14);
        teamP1Labels.add(teamNameLabel);
        teamP1Labels.add(teamRecordLabel);
        teamP1Labels.add(teamNumberLabel);
        teamP1Fields.add(this.teamNameField);
        teamP1Fields.add(this.teamRecordField);
        teamP1Fields.add(this.teamNumberField);
        JLabel teamTurnLabel = new JLabel("Last Turn Ran");
        JLabel teamRunLabel = new JLabel("Run This Team");
        JLabel dummyLabel1 = new JLabel("");
        this.teamTurnField = new BPDisplayField(10);
        this.teamRunButton = new JCheckBox();
        JPanel dummyField1 = new JPanel();
        teamP2Labels.add(teamTurnLabel);
        teamP2Labels.add(teamRunLabel);
        teamP2Labels.add(dummyLabel1);
        teamP2Fields.add(this.teamTurnField);
        teamP2Fields.add(this.teamRunButton);
        teamP2Fields.add(dummyField1);
        this.teamNameField.setFont(ClientGui.f0b);
        this.teamRecordField.setFont(ClientGui.f0b);
        this.teamNumberField.setFont(ClientGui.f0b);
        this.teamTurnField.setFont(ClientGui.f0b);
        teamPaneLayout.addConstraint("teamPanel", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 0));
        teamPaneLayout.addConstraint("teamPanel", AttributeType.WIDTH, new AttributeConstraint("_container", AttributeType.WIDTH, 0));
        teamPaneLayout.addConstraint("teamPanel", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        this.teamRunListener = new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                TeamGui.this.t.setActive(e.getStateChange() == 1);
                TeamGui.this.parentGui.playerDataChangedEvent(0);
            }
        };
        this.teamRunButton.addItemListener(this.teamRunListener);
    }
}

