/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ClientFileManager;
import client.HttpNamingOperation;
import client.UploadStatusEnum;
import client.data.ArenaCOM;
import client.data.ManagerCOM;
import client.rmi.AuthenticationException;
import client.rmi.ClientRmiInterface;
import client.rmi.DataSyncException;
import client.rmi.LockoutException;
import client.rmi.ServerStatusException;
import client.rmi.ValidationException;
import client.rmi.VersionException;
import java.awt.Frame;
import java.rmi.ConnectException;
import java.rmi.MarshalException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Vector;

public class UploadOperation
extends HttpNamingOperation {
    private int accountNumber = -1;
    private String password = "";
    private ManagerCOM upManager = null;
    private ArenaCOM clientData = null;
    private Observer observer;
    private ClientRmiInterface pdi;
    private UploadStatusEnum status = UploadStatusEnum.NONE;

    public UploadOperation(ManagerCOM upManager, Frame owner, Observer myObserver) {
        super("Upload", owner);
        this.accountNumber = upManager.getManagerNumber();
        this.password = upManager.getPassword();
        this.upManager = (ManagerCOM)upManager.cloneTree();
        this.observer = myObserver;
        this.init();
    }

    protected void init() {
        Vector<String> tasks = new Vector<String>();
        tasks.add("Connecting to server");
        tasks.add("Checking server status");
        tasks.add("Checking client version");
        tasks.add("Authenticating user");
        tasks.add("Sending player data");
        tasks.add("Synchronizing arena data");
        tasks.add("Synchronizing player data");
        super.init(tasks);
    }

    public Object construct() {
        try {
            Thread.yield();
            this.startTasks();
            this.doNamingLookup();
            this.pdi = (ClientRmiInterface)Naming.lookup(ClientFileManager.getRMIProperties().getRemoteInterfaceName());
            this.finishedTask();
            this.pdi.statusCheck();
            this.finishedTask();
            this.pdi.compatibilityCheck("v1.2a");
            this.finishedTask();
            this.pdi.authenticatePlayer(this.accountNumber, this.password);
            this.finishedTask();
            this.pdi.setPlayerData(this.accountNumber, this.password, this.upManager);
            this.finishedTask();
            this.clientData = this.pdi.getArenaData(1);
            this.finishedTask();
            ManagerCOM downManager = this.pdi.getPlayerData(this.accountNumber, this.password);
            this.finishedTask();
            this.clientData.setManager(downManager);
            this.clientData.localizeTree();
            this.status = UploadStatusEnum.SUCCESS;
            this.operationSuccess();
            return null;
        }
        catch (ConnectException e) {
            this.status = UploadStatusEnum.CONNECT_FAILURE;
            this.operationFailure(this.status.name(), this.status.toString());
            e.printStackTrace();
            return null;
        }
        catch (MarshalException e) {
            this.status = UploadStatusEnum.SERIALIZATION_ERROR;
            this.operationFailure(this.status.name(), this.status.toString());
            e.printStackTrace();
            return null;
        }
        catch (NotBoundException e) {
            this.status = UploadStatusEnum.RMI_FAILURE;
            this.operationFailure(this.status.name(), this.status.toString());
            e.printStackTrace();
            return null;
        }
        catch (RemoteException e) {
            this.status = UploadStatusEnum.RMI_FAILURE;
            try {
                if (e.getCause() != null) {
                    throw e.getCause();
                }
            }
            catch (ServerStatusException cause) {
                this.status = UploadStatusEnum.SERVER_UNAVAILABLE;
                cause.printStackTrace();
            }
            catch (LockoutException cause) {
                this.status = UploadStatusEnum.ACCOUNT_LOCKED;
                cause.printStackTrace();
            }
            catch (AuthenticationException cause) {
                this.status = UploadStatusEnum.AUTH_FAILURE;
                cause.printStackTrace();
            }
            catch (DataSyncException cause) {
                this.status = UploadStatusEnum.DATA_SYNC_FAILURE;
                cause.printStackTrace();
            }
            catch (ValidationException cause) {
                this.status = UploadStatusEnum.VALIDATION_FAILURE;
                cause.printStackTrace();
            }
            catch (VersionException cause) {
                this.status = UploadStatusEnum.VERSION_ERROR;
                cause.printStackTrace();
            }
            catch (Throwable cause) {
                cause.printStackTrace();
            }
            this.operationFailure(this.status.name(), this.status.toString());
            return null;
        }
        catch (Exception e) {
            this.status = UploadStatusEnum.UNEXPECTED_ERROR;
            this.operationFailure(this.status.name(), this.status.toString());
            e.printStackTrace();
            return null;
        }
    }

    public void operationCompletedEvent() {
        this.observer.operationCompletedEvent(this);
    }

    public UploadStatusEnum getStatus() {
        return this.status;
    }

    public ArenaCOM getClientData() {
        return this.clientData;
    }

    static interface Observer {
        public void operationCompletedEvent(UploadOperation var1);
    }
}

