/*
 * Decompiled with CFR 0.152.
 */
package client;

import java.io.Serializable;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.Vector;

public class UploadStatusEnum
implements Serializable,
Comparable {
    private static TreeMap VALUE2NAME = new TreeMap();
    private static HashMap NAME2VALUE = new HashMap();
    public static int MIN_VALUE = Integer.MAX_VALUE;
    public static int MAX_VALUE = Integer.MIN_VALUE;
    public static UploadStatusEnum NONE = new UploadStatusEnum(0, "None", "No upload status available");
    public static UploadStatusEnum SUCCESS = new UploadStatusEnum(1, "Success", "Upload succeeded");
    public static UploadStatusEnum AUTH_FAILURE = new UploadStatusEnum(2, "Authorization Failure", "Invalid password");
    public static UploadStatusEnum DATA_SYNC_FAILURE = new UploadStatusEnum(3, "Data Sync Failure", "Attempted to upload old data");
    public static UploadStatusEnum VALIDATION_FAILURE = new UploadStatusEnum(4, "Validation Failure", "Invalid data");
    public static UploadStatusEnum SERVER_UNAVAILABLE = new UploadStatusEnum(5, "Server Unavailable", "Maintanence in progress");
    public static UploadStatusEnum CONNECT_FAILURE = new UploadStatusEnum(6, "Connect Failure", "Server connection refused");
    public static UploadStatusEnum SERIALIZATION_ERROR = new UploadStatusEnum(7, "Serialization Error", "Data model incompatible");
    public static UploadStatusEnum RMI_FAILURE = new UploadStatusEnum(8, "RMI Failure", "Server-side error");
    public static UploadStatusEnum ABORTED = new UploadStatusEnum(9, "Aborted", "Operation Cancelled");
    public static UploadStatusEnum VERSION_ERROR = new UploadStatusEnum(10, "Version Error", "Client version incompatible");
    public static UploadStatusEnum ACCOUNT_LOCKED = new UploadStatusEnum(11, "Account Locked", "Contact your administrator");
    public static UploadStatusEnum UNEXPECTED_ERROR = new UploadStatusEnum(12, "Unexpected Error", "Stack trace in debug log");
    private Integer value;
    private String name;
    private String description;

    protected UploadStatusEnum(int value, String name) {
        this.value = new Integer(value);
        this.name = name;
        this.description = name;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    protected UploadStatusEnum(int value, String name, String description) {
        this.value = new Integer(value);
        this.name = name;
        this.description = description;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    public static boolean contains(String name) {
        return NAME2VALUE.containsKey(name);
    }

    public static boolean contains(int value) {
        return VALUE2NAME.containsKey(new Integer(value));
    }

    public static int valueOf(String name) {
        return ((UploadStatusEnum)NAME2VALUE.get(name)).value();
    }

    public static String nameOf(int value) {
        return ((UploadStatusEnum)VALUE2NAME.get(new Integer(value))).name();
    }

    public static UploadStatusEnum get(String name) {
        return (UploadStatusEnum)NAME2VALUE.get(name);
    }

    public static UploadStatusEnum get(int value) {
        return (UploadStatusEnum)VALUE2NAME.get(new Integer(value));
    }

    public int value() {
        return this.value;
    }

    public String name() {
        return this.name;
    }

    public int compareTo(Object o) {
        Integer anIntegerValue = ((UploadStatusEnum)o).value;
        return this.value.compareTo(anIntegerValue);
    }

    public static Vector values() {
        Vector<UploadStatusEnum> v = new Vector<UploadStatusEnum>(MAX_VALUE);
        for (int i = MIN_VALUE; i <= MAX_VALUE; ++i) {
            v.add(UploadStatusEnum.get(i));
        }
        return v;
    }

    public String toString() {
        return this.description;
    }

    public String toStringFull() {
        return super.toString() + " Name=" + this.name + " Value=" + this.value.toString();
    }
}

