/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.DSModel;
import com.brunchboy.util.swing.relativelayout.AttributeAxis;
import com.brunchboy.util.swing.relativelayout.AttributeConstraint;
import com.brunchboy.util.swing.relativelayout.AttributeType;
import com.brunchboy.util.swing.relativelayout.AxisConstraint;
import com.brunchboy.util.swing.relativelayout.RelativeLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class UserAgreementGui {
    private boolean accepted = false;
    private Frame owner;
    private JEditorPane agreementTextPane;
    private JDialog dialog;
    private JButton acceptButton;
    private JButton cancelButton;

    public static boolean show(URL agreementURL, Frame owner) {
        UserAgreementGui chooser = new UserAgreementGui(agreementURL, owner);
        chooser.display(true);
        return chooser.getAccepted();
    }

    public UserAgreementGui(URL agreementURL, Frame owner) {
        this.owner = owner;
        this.dialog = new JDialog(owner, "Blood Pit User Agreement", true);
        JPanel cp = new JPanel(new BorderLayout());
        Border b0 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        cp.setBorder(b0);
        this.dialog.setContentPane(cp);
        this.dialog.setLocation(DSModel.instance().getAgreementLocation());
        this.dialog.setDefaultCloseOperation(2);
        JPanel listPanel = new JPanel(new BorderLayout());
        Border b1 = BorderFactory.createEtchedBorder();
        Border b2 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        CompoundBorder b3 = BorderFactory.createCompoundBorder(b1, b2);
        listPanel.setBorder(b3);
        cp.add((Component)listPanel, "Center");
        try {
            this.agreementTextPane = new JEditorPane(agreementURL);
        }
        catch (IOException e) {
            throw new RuntimeException("User agreements not found");
        }
        this.agreementTextPane.setPreferredSize(new Dimension(420, 460));
        JScrollPane agreementPaneScroll = new JScrollPane(this.agreementTextPane);
        this.agreementTextPane.setEditable(false);
        listPanel.add((Component)agreementPaneScroll, "Center");
        RelativeLayout buttonLayout = new RelativeLayout();
        JPanel buttonPanel = new JPanel(buttonLayout);
        cp.add((Component)buttonPanel, "South");
        this.acceptButton = new JButton("I Accept");
        Border outer = BorderFactory.createEtchedBorder();
        Border inner = BorderFactory.createEmptyBorder(5, 8, 5, 8);
        CompoundBorder okBorder = BorderFactory.createCompoundBorder(outer, inner);
        this.cancelButton = new JButton("Cancel");
        buttonPanel.add((Component)this.acceptButton, "Accept");
        buttonPanel.add((Component)this.cancelButton, "Cancel");
        buttonLayout.addConstraint("Accept", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 10));
        buttonLayout.addConstraint("Accept", AttributeType.HORIZONTAL_CENTER, new AxisConstraint("_container", AttributeAxis.HORIZONTAL, 0.35));
        buttonLayout.addConstraint("Cancel", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 10));
        buttonLayout.addConstraint("Cancel", AttributeType.HORIZONTAL_CENTER, new AxisConstraint("_container", AttributeAxis.HORIZONTAL, 0.65));
        this.acceptButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserAgreementGui.this.display(false);
                UserAgreementGui.this.accepted = true;
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserAgreementGui.this.display(false);
            }
        });
    }

    public boolean getAccepted() {
        return this.accepted;
    }

    public void display(boolean flag) {
        if (flag) {
            this.dialog.pack();
            this.dialog.setVisible(flag);
        } else {
            this.dialog.dispose();
        }
    }
}

