/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.BPAsyncXMLDocLoader;
import client.BPComboBox;
import client.BPDisplayField;
import client.BPIconLabel;
import client.BPTextField;
import client.ClientGui;
import client.DSModel;
import client.DependentGui;
import client.DescriptorDisplayAdapter;
import client.DisplaySizeEnum;
import client.MainGui;
import client.StrategiesTableModel;
import client.data.ArenaCOM;
import client.data.TeamCOM;
import client.data.WarriorCOM;
import com.brunchboy.util.swing.relativelayout.AttributeAxis;
import com.brunchboy.util.swing.relativelayout.AttributeConstraint;
import com.brunchboy.util.swing.relativelayout.AttributeType;
import com.brunchboy.util.swing.relativelayout.AxisConstraint;
import com.brunchboy.util.swing.relativelayout.RelativeLayout;
import common.ActivityLevelEnum;
import common.AimingPointEnum;
import common.ArenaDescriptor;
import common.ArmorEnum;
import common.BCTriggerEnum;
import common.BloodChallenge;
import common.BloodChallenges;
import common.Challenges;
import common.Constants;
import common.Descriptor;
import common.DescriptorIdentifier;
import common.FightOptionsEnum;
import common.GenderEnum;
import common.HelmEnum;
import common.HitLocationEnum;
import common.ManagerDescriptor;
import common.NewWarriorAdjustments;
import common.NullDescriptor;
import common.PermLevelEnum;
import common.Perms;
import common.RaceEnum;
import common.Refusals;
import common.SkillEnum;
import common.SkillLevelEnum;
import common.Skills;
import common.StyleEnum;
import common.TeamDescriptor;
import common.TextHelper;
import common.TrainEnum;
import common.TriggerEnum;
import common.WarriorDescriptor;
import common.WeaponEnum;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

public class WarriorGui
implements DependentGui,
Constants {
    public static int CHALLENGE_DETAIL_ROWS = 8;
    public static String RANKING_TAB_NAME = "Ranking";
    public static String BLOOD_CHALLENGE_TAB_NAME = "Blood Challenge";
    public static String ARENA_TAB_NAME = "Arena";
    public static Color BLOOD_RED = new Color(192, 16, 16);
    private MainGui parentGui;
    private JTabbedPane warriorPane;
    private WarriorCOM w;
    private TeamCOM t;
    private ArenaCOM clientData;
    private BPAsyncXMLDocLoader docLoader;
    private File[] fights;
    private int fightIndex = -1;
    private NewWarriorAdjustments replacement;
    private Vector bloodChallengeDescriptors;
    private BPDisplayField wNameField;
    private BPDisplayField wRecordField;
    private BPDisplayField wRaceField;
    private BPDisplayField wGenderField;
    private BPDisplayField wHeightField;
    private BPDisplayField wWeightField;
    private BPDisplayField wStrField;
    private BPDisplayField wDexField;
    private BPDisplayField wConField;
    private BPDisplayField wIntField;
    private BPDisplayField wPreField;
    private BPDisplayField wSizField;
    private BPComboBox wArmorField;
    private BPComboBox wHelmField;
    private BPComboBox wPWeaponField;
    private BPComboBox wSWeaponField;
    private BPComboBox wBWeaponField;
    private BPComboBox wTrain1Field;
    private BPComboBox wTrain2Field;
    private BPComboBox wTrain3Field;
    private JTextArea wSkillsTextArea;
    private JTextArea wPermsTextArea;
    private JTable wStrategiesTable;
    private StrategiesTableModel wStrategiesTableModel;
    private BPComboBox wTriggerField;
    private BPComboBox wStyleField;
    private BPComboBox wActivityField;
    private BPComboBox wAimPointField;
    private BPComboBox wDefPointField;
    private JRadioButton wSinglesFightButton;
    private JRadioButton wTeamFightButton;
    private JRadioButton wMonsterButton;
    private JRadioButton wRetireButton;
    private JRadioButton wEventButton;
    private BPComboBox wBloodcry1Trigger;
    private BPTextField wBloodcry1Field;
    private BPComboBox wBloodcry2Trigger;
    private BPTextField wBloodcry2Field;
    private ActionListener wArmorListener;
    private ActionListener wHelmListener;
    private ActionListener wPWeaponListener;
    private ActionListener wSWeaponListener;
    private ActionListener wBWeaponListener;
    private ActionListener wTrain1Listener;
    private ActionListener wTrain2Listener;
    private ActionListener wTrain3Listener;
    private TableModelListener strategiesTableListener;
    private ActionListener wSinglesFightListener;
    private ActionListener wTeamFightListener;
    private ActionListener wMonsterListener;
    private ActionListener wRetireListener;
    private ActionListener wEventFightListener;
    private ActionListener wBloodcry1TriggerListener;
    private ActionListener wBloodcry2TriggerListener;
    private DocumentListener wBloodcry1FieldListener;
    private DocumentListener wBloodcry2FieldListener;
    private JEditorPane wFightsText;
    private JButton wPrevFightB;
    private BPDisplayField wCurrentFightField;
    private JButton wNextFightB;
    private JPanel wChallengePanel;
    private JTabbedPane wRankingRosterPane;
    private JList wRankingList;
    private JList bloodChallengeList;
    private JTree wRosterTree;
    private BPIconLabel wSelectChallenge1Field;
    private BPIconLabel wSelectChallenge2Field;
    private BPIconLabel wSelectChallenge3Field;
    private BPIconLabel wSelectRefusal1Field;
    private BPIconLabel wSelectRefusal2Field;
    private BPIconLabel wSelectRefusal3Field;
    private JButton wSelectChallenge1B;
    private JButton wSelectChallenge2B;
    private JButton wSelectChallenge3B;
    private JButton wClearChallenge1B;
    private JButton wClearChallenge2B;
    private JButton wClearChallenge3B;
    private JButton wSelectRefusal1B;
    private JButton wSelectRefusal2B;
    private JButton wSelectRefusal3B;
    private JButton wClearRefusal1B;
    private JButton wClearRefusal2B;
    private JButton wClearRefusal3B;
    private JTable wSelectDetailText;
    private BPDisplayField rStrField;
    private BPDisplayField rDexField;
    private BPDisplayField rConField;
    private BPDisplayField rIntField;
    private BPDisplayField rPreField;
    private BPDisplayField rSizField;
    private JTextField rNameField;
    private BPComboBox rRaceBox;
    private BPComboBox rGenderBox;
    private BPDisplayField rDistributeField;
    private JButton rResetButton;
    private JButton rSaveButton;

    public JTabbedPane getContentPane() {
        return this.warriorPane;
    }

    public WarriorCOM getTarget() {
        return this.w;
    }

    public String getScreenId() {
        return "WarriorScreen";
    }

    public void setTarget(Descriptor d, File[] fileList) {
        WarriorCOM warrior = (WarriorCOM)d;
        if (this.w != warrior) {
            this.w = warrior;
            this.t = (TeamCOM)this.w.getParent();
            this.fights = fileList;
            this.refresh();
        }
    }

    public void refresh() {
        this.wArmorField.removeActionListener(this.wArmorListener);
        this.wHelmField.removeActionListener(this.wHelmListener);
        this.wPWeaponField.removeActionListener(this.wPWeaponListener);
        this.wSWeaponField.removeActionListener(this.wSWeaponListener);
        this.wBWeaponField.removeActionListener(this.wBWeaponListener);
        this.wTrain1Field.removeActionListener(this.wTrain1Listener);
        this.wTrain2Field.removeActionListener(this.wTrain2Listener);
        this.wTrain3Field.removeActionListener(this.wTrain3Listener);
        this.wStrategiesTableModel.removeTableModelListener(this.strategiesTableListener);
        this.wSinglesFightButton.removeActionListener(this.wSinglesFightListener);
        this.wTeamFightButton.removeActionListener(this.wTeamFightListener);
        this.wMonsterButton.removeActionListener(this.wMonsterListener);
        this.wRetireButton.removeActionListener(this.wRetireListener);
        this.wEventButton.removeActionListener(this.wEventFightListener);
        this.wBloodcry1Trigger.removeActionListener(this.wBloodcry1TriggerListener);
        this.wBloodcry2Trigger.removeActionListener(this.wBloodcry2TriggerListener);
        this.wBloodcry1Field.getDocument().removeDocumentListener(this.wBloodcry1FieldListener);
        this.wBloodcry2Field.getDocument().removeDocumentListener(this.wBloodcry2FieldListener);
        this.attachAll();
        this.wArmorField.addActionListener(this.wArmorListener);
        this.wHelmField.addActionListener(this.wHelmListener);
        this.wPWeaponField.addActionListener(this.wPWeaponListener);
        this.wSWeaponField.addActionListener(this.wSWeaponListener);
        this.wBWeaponField.addActionListener(this.wBWeaponListener);
        this.wTrain1Field.addActionListener(this.wTrain1Listener);
        this.wTrain2Field.addActionListener(this.wTrain2Listener);
        this.wTrain3Field.addActionListener(this.wTrain3Listener);
        this.wStrategiesTableModel.addTableModelListener(this.strategiesTableListener);
        this.wSinglesFightButton.addActionListener(this.wSinglesFightListener);
        this.wTeamFightButton.addActionListener(this.wTeamFightListener);
        this.wMonsterButton.addActionListener(this.wMonsterListener);
        this.wRetireButton.addActionListener(this.wRetireListener);
        this.wEventButton.addActionListener(this.wEventFightListener);
        this.wBloodcry1Trigger.addActionListener(this.wBloodcry1TriggerListener);
        this.wBloodcry2Trigger.addActionListener(this.wBloodcry2TriggerListener);
        this.wBloodcry1Field.getDocument().addDocumentListener(this.wBloodcry1FieldListener);
        this.wBloodcry2Field.getDocument().addDocumentListener(this.wBloodcry2FieldListener);
    }

    public void setClientData(ArenaCOM clientData) {
        ((DefaultTreeModel)this.wRosterTree.getModel()).setRoot(this.createDDATree(clientData));
        if (this.clientData == null) {
            this.wRosterTree.setCellRenderer(new DescriptorTreeCellRenderer());
        }
        this.wRankingList.setListData(this.createDDAList(clientData.getWarriorsByRanking()));
        this.clientData = clientData;
        this.warriorPane.setSelectedIndex(0);
    }

    protected void setRankingData() {
        this.wRankingList.setListData(this.createDDAList(this.clientData.getWarriorsByRanking()));
    }

    protected void attachAll() {
        this.attachStats();
        this.attachFightOptions();
        this.attachChallenge();
        this.attachFights();
        this.attachReplacement();
    }

    protected void attachStats() {
        String tempStr = "";
        this.wNameField.setText(this.w.getName());
        if (this.parentGui.getClientPreferences().getHideWLK()) {
            this.wRecordField.setText("");
        } else {
            this.wRecordField.setText(this.w.getRecordText());
        }
        this.wRaceField.setText(this.w.getRace().toString());
        this.wGenderField.setText(this.w.getGender().toString());
        this.wHeightField.setText(TextHelper.getHeightText(this.w.getHeight()));
        this.wWeightField.setText(TextHelper.getWeightText(this.w.getWeight()));
        tempStr = this.w.getStr() == this.w.getSStr() ? this.w.getStr() + "" : this.w.getStr() + " (" + this.w.getSStr() + ")";
        this.wStrField.setText(tempStr);
        tempStr = this.w.getDex() == this.w.getSDex() ? this.w.getDex() + "" : this.w.getDex() + " (" + this.w.getSDex() + ")";
        this.wDexField.setText(tempStr);
        tempStr = this.w.getCon() == this.w.getSCon() ? this.w.getCon() + "" : this.w.getCon() + " (" + this.w.getSCon() + ")";
        this.wConField.setText(tempStr);
        tempStr = this.w.getInt() == this.w.getSInt() ? this.w.getInt() + "" : this.w.getInt() + " (" + this.w.getSInt() + ")";
        this.wIntField.setText(tempStr);
        tempStr = this.w.getPre() == this.w.getSPre() ? this.w.getPre() + "" : this.w.getPre() + " (" + this.w.getSPre() + ")";
        this.wPreField.setText(tempStr);
        tempStr = this.w.getSiz() == this.w.getSSiz() ? this.w.getSiz() + "" : this.w.getSiz() + " (" + this.w.getSSiz() + ")";
        this.wSizField.setText(tempStr);
        this.wArmorField.setSelectedItem(this.w.getArmor());
        this.wHelmField.setSelectedItem(this.w.getHelm());
        this.wPWeaponField.setSelectedItem(this.w.getPWeapon());
        this.wSWeaponField.setSelectedItem(this.w.getSWeapon());
        this.wBWeaponField.setSelectedItem(this.w.getBWeapon());
        this.wTrain1Field.setSelectedItem(this.w.getTrains().getTrain(0));
        this.wTrain2Field.setSelectedItem(this.w.getTrains().getTrain(1));
        this.wTrain3Field.setSelectedItem(this.w.getTrains().getTrain(2));
        tempStr = "";
        Skills skills = this.w.getSkillLevels();
        Iterator skillNameIterator = SkillEnum.iterator();
        while (skillNameIterator.hasNext()) {
            SkillEnum name = (SkillEnum)skillNameIterator.next();
            SkillLevelEnum level = skills.getSkillLevel(name);
            if (level == SkillLevelEnum.NONE) continue;
            tempStr = tempStr + level + " (" + level.value() + ") in " + name + "\n";
        }
        this.wSkillsTextArea.setText(tempStr);
        tempStr = "";
        Perms perms = this.w.getPermLevels();
        Iterator hitLocationIterator = HitLocationEnum.iterator();
        while (hitLocationIterator.hasNext()) {
            HitLocationEnum location = (HitLocationEnum)hitLocationIterator.next();
            PermLevelEnum permLevel = perms.getPermLevel(location);
            if (permLevel == PermLevelEnum.NONE) continue;
            tempStr = tempStr + permLevel + " (" + permLevel.value() + ") injury to the " + location + "\n";
        }
        this.wPermsTextArea.setText(tempStr);
        this.wStrategiesTable.removeEditor();
        this.wStrategiesTableModel.setStrategies(this.w.getStrategies());
    }

    protected void attachChallenge() {
        this.setRankingData();
        Challenges challenges = this.w.getChallenges();
        Refusals refusals = this.w.getRefusals();
        this.attachBloodChallenges();
        this.setChallengeFieldContents(this.wSelectChallenge1Field, challenges.getChallenge(0));
        this.setChallengeFieldContents(this.wSelectChallenge2Field, challenges.getChallenge(1));
        this.setChallengeFieldContents(this.wSelectChallenge3Field, challenges.getChallenge(2));
        this.setChallengeFieldContents(this.wSelectRefusal1Field, refusals.getRefusal(0));
        this.setChallengeFieldContents(this.wSelectRefusal2Field, refusals.getRefusal(1));
        this.setChallengeFieldContents(this.wSelectRefusal3Field, refusals.getRefusal(2));
        if (this.wRankingRosterPane.getSelectedIndex() == 0) {
            this.wRankingList.repaint();
        }
        if (this.wRankingRosterPane.getSelectedIndex() == 1) {
            this.wRosterTree.repaint();
        }
    }

    protected void setChallengeFieldContents(BPIconLabel field, DescriptorIdentifier target) {
        DescriptorDisplayAdapter dda = new DescriptorDisplayAdapter(this.clientData.findDescriptor(target));
        this.setChallengeFieldContents(field, dda);
    }

    protected void setChallengeFieldContents(BPIconLabel field, DescriptorDisplayAdapter adapter) {
        field.setText(adapter.getDisplayString());
        field.setIcon(adapter.getIcon());
        field.setForeground(Color.BLACK);
        if (this.bloodChallengeDescriptors != null) {
            for (int i = 0; i < this.bloodChallengeDescriptors.size(); ++i) {
                if (this.bloodChallengeDescriptors.get(i) != adapter.getDescriptor()) continue;
                field.setForeground(BLOOD_RED);
            }
        }
    }

    protected void attachBloodChallenges() {
        this.bloodChallengeDescriptors = new Vector();
        BloodChallenges bloodChallenges = this.t.getBloodChallenges();
        Iterator bloodChallengesIterator = bloodChallenges.iterator();
        while (bloodChallengesIterator.hasNext()) {
            BloodChallenge bloodChallenge = (BloodChallenge)bloodChallengesIterator.next();
            Descriptor bloodChallengeDescriptor = this.clientData.findDescriptor(bloodChallenge);
            if (bloodChallengeDescriptor == NullDescriptor.NONE) continue;
            this.bloodChallengeDescriptors.add(bloodChallengeDescriptor);
        }
        this.bloodChallengeList.setListData(this.createDDAList(this.bloodChallengeDescriptors));
    }

    protected void attachFightOptions() {
        if (!this.clientData.getEventLock()) {
            this.wSinglesFightButton.setEnabled(true);
            this.wTeamFightButton.setEnabled(true);
            this.wMonsterButton.setEnabled(true);
            this.wRetireButton.setEnabled(this.w.getTotalFights() >= 100);
            if (this.clientData.getEventEnabled()) {
                if (this.clientData.getManager().getEventEntryCount() < this.clientData.getMaxEventEntries()) {
                    this.wEventButton.setEnabled(true);
                } else {
                    this.wEventButton.setEnabled(false);
                }
            } else {
                this.wEventButton.setEnabled(false);
            }
        } else {
            this.wSinglesFightButton.setEnabled(false);
            this.wTeamFightButton.setEnabled(false);
            this.wMonsterButton.setEnabled(false);
            this.wRetireButton.setEnabled(false);
            this.wEventButton.setEnabled(false);
        }
        switch (this.w.getFightOptions().value()) {
            case 0: {
                this.wSinglesFightButton.setSelected(true);
                this.setChallengeSelectionAllowed(true);
                break;
            }
            case 1: {
                this.wTeamFightButton.setSelected(true);
                this.setChallengeSelectionAllowed(false);
                break;
            }
            case 2: {
                this.wMonsterButton.setSelected(true);
                this.setChallengeSelectionAllowed(false);
                break;
            }
            case 3: {
                this.wRetireButton.setSelected(true);
                this.setChallengeSelectionAllowed(false);
                break;
            }
            case 4: {
                this.wEventButton.setSelected(true);
                this.setChallengeSelectionAllowed(false);
                break;
            }
            default: {
                this.w.setFightOptions(FightOptionsEnum.SINGLES_FIGHT);
                this.setChallengeSelectionAllowed(true);
                this.wSinglesFightButton.setSelected(true);
            }
        }
        this.wBloodcry1Trigger.setSelectedItem(this.w.getBloodCrys().getBloodCry(0).getTrigger());
        this.wBloodcry1Field.setText(this.w.getBloodCrys().getBloodCry(0).getText());
        this.wBloodcry2Trigger.setSelectedItem(this.w.getBloodCrys().getBloodCry(1).getTrigger());
        this.wBloodcry2Field.setText(this.w.getBloodCrys().getBloodCry(1).getText());
    }

    protected void attachReplacement() {
        if (this.w.isDeadOrRetired()) {
            this.warriorPane.setEnabledAt(4, true);
            this.replacementInitializeEvent();
        } else {
            this.warriorPane.setEnabledAt(4, false);
            if (this.warriorPane.getSelectedIndex() == 4) {
                this.warriorPane.setSelectedIndex(0);
            }
        }
    }

    protected void attachFights() {
        this.fightIndex = this.fights.length - 1;
        this.attachFightPane();
    }

    protected void attachFightPane() {
        if (this.fightIndex >= 0 && this.fightIndex < this.fights.length) {
            try {
                this.docLoader = new BPAsyncXMLDocLoader(this.wCurrentFightField, this.wFightsText, this.fights[this.fightIndex]);
                this.docLoader.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.wFightsText.setText("");
                this.wCurrentFightField.setText("");
            }
        } else {
            this.wFightsText.setText("");
            this.wCurrentFightField.setText("");
        }
    }

    protected void setChallengeSelectionAllowed(boolean flag) {
    }

    protected void replacementInitializeEvent() {
        this.replacement = new NewWarriorAdjustments(this.w.getReplacementBase());
        this.attachReplacementPane();
    }

    protected void attachReplacementPane() {
        NewWarriorAdjustments r = this.replacement;
        this.rStrField.setText(r.getStrAdd() == 0 ? r.getStr() + "" : r.getStr() + " (" + r.getBStr() + ")");
        this.rDexField.setText(r.getDexAdd() == 0 ? r.getDex() + "" : r.getDex() + " (" + r.getBDex() + ")");
        this.rConField.setText(r.getConAdd() == 0 ? r.getCon() + "" : r.getCon() + " (" + r.getBCon() + ")");
        this.rIntField.setText(r.getIntAdd() == 0 ? r.getInt() + "" : r.getInt() + " (" + r.getBInt() + ")");
        this.rPreField.setText(r.getPreAdd() == 0 ? r.getPre() + "" : r.getPre() + " (" + r.getBPre() + ")");
        this.rSizField.setText(r.getSizAdd() == 0 ? r.getSiz() + "" : r.getSiz() + " (" + r.getBSiz() + ")");
        this.rNameField.setText(r.getName() + "");
        this.rRaceBox.setSelectedItem(r.getRace());
        this.rGenderBox.setSelectedItem(r.getGender());
        this.replacementUpdatedEvent();
    }

    protected void replacementUpdatedEvent() {
        this.rDistributeField.setText(this.replacement.getPointsLeftToDistribute() + "");
        this.rSaveButton.setEnabled(this.replacement.isCompleteAndValidTree());
    }

    protected void replacementResetEvent() {
        this.replacement.reset();
        this.attachReplacementPane();
    }

    public WarriorGui(MainGui parent) {
        this.parentGui = parent;
        this.warriorPane = new JTabbedPane();
        this.warriorPane.setFont(ClientGui.f1b);
        JPanel wStatsPane = new JPanel();
        JPanel wFightOptionsPane = new JPanel();
        JPanel wFightsPane = new JPanel();
        JPanel wChallengesPane = new JPanel();
        JPanel wReplacementPane = new JPanel();
        this.warriorPane.add("Stats/Strats", wStatsPane);
        this.warriorPane.add("Fight Options", wFightOptionsPane);
        this.warriorPane.add("Fights", wFightsPane);
        this.warriorPane.add("Challenges", wChallengesPane);
        this.warriorPane.add("Replacement", wReplacementPane);
        this.warriorPane.setSelectedIndex(0);
        this.warriorPane.setEnabledAt(4, false);
        RelativeLayout wStatsPaneLayout = new RelativeLayout();
        wStatsPane.setLayout(wStatsPaneLayout);
        wChallengesPane.setLayout(new BorderLayout());
        RelativeLayout wFightOptionsLayout = new RelativeLayout();
        wFightOptionsPane.setLayout(wFightOptionsLayout);
        BorderLayout wFightsPaneLayout = new BorderLayout();
        wFightsPane.setLayout(wFightsPaneLayout);
        RelativeLayout wReplacementPaneLayout = new RelativeLayout();
        wReplacementPane.setLayout(wReplacementPaneLayout);
        JPanel wHeader = new JPanel();
        GridBagLayout wHeaderLayout = new GridBagLayout();
        wHeader.setLayout(wHeaderLayout);
        Border wHeaderInnerEmptyBorder = BorderFactory.createEmptyBorder(0, 0, 5, 0);
        Border wHeaderEtchedBorder = BorderFactory.createEtchedBorder();
        CompoundBorder wHeaderEtchedEmptyBorder = BorderFactory.createCompoundBorder(wHeaderEtchedBorder, wHeaderInnerEmptyBorder);
        TitledBorder wHeaderTitledBorder = BorderFactory.createTitledBorder(wHeaderEtchedEmptyBorder, "Warrior");
        wHeader.setBorder(wHeaderTitledBorder);
        wStatsPane.add((Component)wHeader, "wHeader");
        JPanel wHeaderP1 = new JPanel(new BorderLayout());
        JPanel wHeaderP2 = new JPanel(new BorderLayout());
        JPanel wHeaderP3 = new JPanel(new BorderLayout());
        GridBagConstraints wHeaderConst = new GridBagConstraints();
        wHeaderConst.fill = 1;
        wHeaderConst.gridheight = 0;
        wHeaderConst.weightx = 3.0;
        wHeaderConst.weighty = 1.0;
        wHeaderLayout.setConstraints(wHeaderP1, wHeaderConst);
        wHeader.add(wHeaderP1);
        wHeaderConst.gridwidth = -1;
        wHeaderConst.weightx = 1.0;
        wHeaderLayout.setConstraints(wHeaderP2, wHeaderConst);
        wHeader.add(wHeaderP2);
        wHeaderConst.gridwidth = 0;
        wHeaderConst.weightx = 1.0;
        wHeaderLayout.setConstraints(wHeaderP3, wHeaderConst);
        wHeader.add(wHeaderP3);
        JPanel wHeaderP1Labels = new JPanel(new GridLayout(0, 1));
        JPanel wHeaderP1Fields = new JPanel(new GridLayout(0, 1));
        JPanel wHeaderP2Labels = new JPanel(new GridLayout(0, 1));
        JPanel wHeaderP2Fields = new JPanel(new GridLayout(0, 1));
        JPanel wHeaderP3Labels = new JPanel(new GridLayout(0, 1));
        JPanel wHeaderP3Fields = new JPanel(new GridLayout(0, 1));
        Border wHeaderP1FieldsEmptyBorder = BorderFactory.createEmptyBorder(0, 4, 0, 25);
        Border wHeaderP3FieldsEmptyBorder = BorderFactory.createEmptyBorder(0, 4, 0, 0);
        wHeaderP1Fields.setBorder(wHeaderP1FieldsEmptyBorder);
        wHeaderP2Fields.setBorder(wHeaderP1FieldsEmptyBorder);
        wHeaderP3Fields.setBorder(wHeaderP3FieldsEmptyBorder);
        wHeaderP1.add((Component)wHeaderP1Labels, "West");
        wHeaderP2.add((Component)wHeaderP2Labels, "West");
        wHeaderP3.add((Component)wHeaderP3Labels, "West");
        wHeaderP1.add((Component)wHeaderP1Fields, "Center");
        wHeaderP2.add((Component)wHeaderP2Fields, "Center");
        wHeaderP3.add((Component)wHeaderP3Fields, "Center");
        JLabel wNameLabel = new JLabel("Name");
        JLabel wRecordLabel = new JLabel("Record");
        this.wNameField = new BPDisplayField(25);
        this.wRecordField = new BPDisplayField(25);
        wHeaderP1Labels.add(wNameLabel);
        wHeaderP1Labels.add(wRecordLabel);
        wHeaderP1Fields.add(this.wNameField);
        wHeaderP1Fields.add(this.wRecordField);
        JLabel wRaceLabel = new JLabel("Race");
        JLabel wGenderLabel = new JLabel("Gender");
        this.wRaceField = new BPDisplayField(10);
        this.wGenderField = new BPDisplayField(10);
        wHeaderP2Labels.add(wRaceLabel);
        wHeaderP2Labels.add(wGenderLabel);
        wHeaderP2Fields.add(this.wRaceField);
        wHeaderP2Fields.add(this.wGenderField);
        JLabel wHeightLabel = new JLabel("Height");
        JLabel wWeightLabel = new JLabel("Weight");
        this.wHeightField = new BPDisplayField(10);
        this.wWeightField = new BPDisplayField(10);
        wHeaderP3Labels.add(wHeightLabel);
        wHeaderP3Labels.add(wWeightLabel);
        wHeaderP3Fields.add(this.wHeightField);
        wHeaderP3Fields.add(this.wWeightField);
        this.wNameField.setFont(ClientGui.f0b);
        this.wRecordField.setFont(ClientGui.f0b);
        this.wRaceField.setFont(ClientGui.f0b);
        this.wGenderField.setFont(ClientGui.f0b);
        this.wHeightField.setFont(ClientGui.f0b);
        this.wWeightField.setFont(ClientGui.f0b);
        Box wArmor = Box.createHorizontalBox();
        Border wArmorInnerEmptyBorder = BorderFactory.createEmptyBorder(5, 6, 5, 4);
        wArmor.setBorder(wArmorInnerEmptyBorder);
        wStatsPane.add((Component)wArmor, "wArmor");
        JPanel wArmorP1 = new JPanel(new BorderLayout());
        JPanel wArmorP2 = new JPanel(new BorderLayout());
        JPanel wArmorP3 = new JPanel(new BorderLayout());
        Border wTrainEtchedBorder = BorderFactory.createEtchedBorder();
        TitledBorder wTrainTitledBorder = BorderFactory.createTitledBorder(wTrainEtchedBorder, "Trains");
        Border wTrainInnerBorder = BorderFactory.createEmptyBorder(6, 2, 10, 2);
        CompoundBorder wTrainBorder = BorderFactory.createCompoundBorder(wTrainTitledBorder, wTrainInnerBorder);
        wArmorP3.setBorder(wTrainBorder);
        wArmor.add(wArmorP1);
        wArmor.add(wArmorP2);
        wArmor.add(wArmorP3);
        JPanel wArmorP1Labels = new JPanel(new GridLayout(0, 1));
        JPanel wArmorP1Fields = new JPanel(new GridLayout(0, 1));
        JPanel wArmorP2Labels = new JPanel(new GridLayout(0, 1));
        JPanel wArmorP2Fields = new JPanel(new GridLayout(0, 1));
        JPanel wArmorP3Labels = new JPanel(new GridLayout(0, 1));
        JPanel wArmorP3Fields = new JPanel(new GridLayout(0, 1));
        Border wArmorP1FieldsEmptyBorder = BorderFactory.createEmptyBorder(0, 4, 0, 25);
        Border wArmorP3FieldsEmptyBorder = BorderFactory.createEmptyBorder(0, 4, 0, 0);
        wArmorP1Fields.setBorder(wArmorP1FieldsEmptyBorder);
        wArmorP2Fields.setBorder(wArmorP1FieldsEmptyBorder);
        wArmorP3Fields.setBorder(wArmorP3FieldsEmptyBorder);
        wArmorP1.add((Component)wArmorP1Labels, "West");
        wArmorP2.add((Component)wArmorP2Labels, "West");
        wArmorP3.add((Component)wArmorP3Labels, "West");
        wArmorP1.add((Component)wArmorP1Fields, "Center");
        wArmorP2.add((Component)wArmorP2Fields, "Center");
        wArmorP3.add((Component)wArmorP3Fields, "Center");
        JLabel wStrLabel = new JLabel("Strength");
        JLabel wDexLabel = new JLabel("Dexterity");
        JLabel wConLabel = new JLabel("Constitution");
        JLabel wIntLabel = new JLabel("Intelligence");
        JLabel wPreLabel = new JLabel("Presence");
        JLabel wSizLabel = new JLabel("Size");
        this.wStrField = new BPDisplayField(7);
        this.wDexField = new BPDisplayField(7);
        this.wConField = new BPDisplayField(7);
        this.wIntField = new BPDisplayField(7);
        this.wPreField = new BPDisplayField(7);
        this.wSizField = new BPDisplayField(7);
        wArmorP1Labels.add(wStrLabel);
        wArmorP1Labels.add(wDexLabel);
        wArmorP1Labels.add(wConLabel);
        wArmorP1Labels.add(wIntLabel);
        wArmorP1Labels.add(wPreLabel);
        wArmorP1Labels.add(wSizLabel);
        wArmorP1Fields.add(this.wStrField);
        wArmorP1Fields.add(this.wDexField);
        wArmorP1Fields.add(this.wConField);
        wArmorP1Fields.add(this.wIntField);
        wArmorP1Fields.add(this.wPreField);
        wArmorP1Fields.add(this.wSizField);
        this.wStrField.setFont(ClientGui.f0b);
        this.wDexField.setFont(ClientGui.f0b);
        this.wConField.setFont(ClientGui.f0b);
        this.wIntField.setFont(ClientGui.f0b);
        this.wPreField.setFont(ClientGui.f0b);
        this.wSizField.setFont(ClientGui.f0b);
        JLabel wArmorLabel = new JLabel("Armor");
        JLabel wHelmLabel = new JLabel("Helm");
        JLabel wPWeaponLabel = new JLabel("Primary");
        JLabel wSWeaponLabel = new JLabel("Secondary");
        JLabel wBWeaponLabel = new JLabel("Backup");
        this.wArmorField = new BPComboBox(ArmorEnum.values());
        this.wHelmField = new BPComboBox(HelmEnum.values());
        this.wPWeaponField = new BPComboBox(WeaponEnum.values());
        this.wSWeaponField = new BPComboBox(WeaponEnum.values());
        this.wBWeaponField = new BPComboBox(WeaponEnum.values());
        wArmorP2Labels.add(wArmorLabel);
        wArmorP2Labels.add(wHelmLabel);
        wArmorP2Labels.add(wPWeaponLabel);
        wArmorP2Labels.add(wSWeaponLabel);
        wArmorP2Labels.add(wBWeaponLabel);
        wArmorP2Fields.add(this.wArmorField);
        wArmorP2Fields.add(this.wHelmField);
        wArmorP2Fields.add(this.wPWeaponField);
        wArmorP2Fields.add(this.wSWeaponField);
        wArmorP2Fields.add(this.wBWeaponField);
        CompoundBorder wTrainsSelectButtonBorder = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(0, 1, 0, 1));
        JButton wTrain1Button = new JButton("1st");
        JButton wTrain2Button = new JButton("2nd");
        JButton wTrain3Button = new JButton("3rd");
        wTrain1Button.setBorder(wTrainsSelectButtonBorder);
        wTrain2Button.setBorder(wTrainsSelectButtonBorder);
        wTrain3Button.setBorder(wTrainsSelectButtonBorder);
        this.wTrain1Field = new BPComboBox(TrainEnum.values());
        this.wTrain2Field = new BPComboBox(TrainEnum.values());
        this.wTrain3Field = new BPComboBox(TrainEnum.values());
        wArmorP3Labels.add(wTrain1Button);
        wArmorP3Labels.add(wTrain2Button);
        wArmorP3Labels.add(wTrain3Button);
        wArmorP3Fields.add(this.wTrain1Field);
        wArmorP3Fields.add(this.wTrain2Field);
        wArmorP3Fields.add(this.wTrain3Field);
        wTrain1Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.wTrain2Field.setSelectedItem(WarriorGui.this.wTrain1Field.getSelectedItem());
                WarriorGui.this.wTrain3Field.setSelectedItem(WarriorGui.this.wTrain1Field.getSelectedItem());
            }
        });
        wTrain2Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.wTrain1Field.setSelectedItem(WarriorGui.this.wTrain2Field.getSelectedItem());
                WarriorGui.this.wTrain3Field.setSelectedItem(WarriorGui.this.wTrain2Field.getSelectedItem());
            }
        });
        wTrain3Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.wTrain1Field.setSelectedItem(WarriorGui.this.wTrain3Field.getSelectedItem());
                WarriorGui.this.wTrain2Field.setSelectedItem(WarriorGui.this.wTrain3Field.getSelectedItem());
            }
        });
        this.wArmorListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.w.setArmor((ArmorEnum)WarriorGui.this.wArmorField.getSelectedItem());
                WarriorGui.this.parentGui.playerDataChangedEvent(2);
            }
        };
        this.wArmorField.addActionListener(this.wArmorListener);
        this.wHelmListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.w.setHelm((HelmEnum)WarriorGui.this.wHelmField.getSelectedItem());
                WarriorGui.this.parentGui.playerDataChangedEvent(2);
            }
        };
        this.wHelmField.addActionListener(this.wHelmListener);
        this.wPWeaponListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.w.setPWeapon((WeaponEnum)WarriorGui.this.wPWeaponField.getSelectedItem());
                WarriorGui.this.parentGui.playerDataChangedEvent(2);
            }
        };
        this.wPWeaponField.addActionListener(this.wPWeaponListener);
        this.wSWeaponListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.w.setSWeapon((WeaponEnum)WarriorGui.this.wSWeaponField.getSelectedItem());
                WarriorGui.this.parentGui.playerDataChangedEvent(2);
            }
        };
        this.wSWeaponField.addActionListener(this.wSWeaponListener);
        this.wBWeaponListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.w.setBWeapon((WeaponEnum)WarriorGui.this.wBWeaponField.getSelectedItem());
                WarriorGui.this.parentGui.playerDataChangedEvent(2);
            }
        };
        this.wBWeaponField.addActionListener(this.wBWeaponListener);
        this.wTrain1Listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.w.getTrains().setTrain(0, (TrainEnum)WarriorGui.this.wTrain1Field.getSelectedItem());
                WarriorGui.this.parentGui.playerDataChangedEvent(2);
            }
        };
        this.wTrain1Field.addActionListener(this.wTrain1Listener);
        this.wTrain2Listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.w.getTrains().setTrain(1, (TrainEnum)WarriorGui.this.wTrain2Field.getSelectedItem());
                WarriorGui.this.parentGui.playerDataChangedEvent(2);
            }
        };
        this.wTrain2Field.addActionListener(this.wTrain2Listener);
        this.wTrain3Listener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.w.getTrains().setTrain(2, (TrainEnum)WarriorGui.this.wTrain3Field.getSelectedItem());
                WarriorGui.this.parentGui.playerDataChangedEvent(2);
            }
        };
        this.wTrain3Field.addActionListener(this.wTrain3Listener);
        JPanel wStrategy = new JPanel();
        BorderLayout wStrategyLayout = new BorderLayout();
        wStrategy.setLayout(wStrategyLayout);
        Border wStrategyEtchedBorder = BorderFactory.createEtchedBorder();
        TitledBorder wStrategyTitledBorder = BorderFactory.createTitledBorder(wStrategyEtchedBorder, "Strategies");
        Border wStrategyInnerEmptyBorder = BorderFactory.createEmptyBorder(5, 4, 5, 4);
        CompoundBorder wStrategyEtchedEmptyBorder = BorderFactory.createCompoundBorder(wStrategyTitledBorder, wStrategyInnerEmptyBorder);
        wStrategy.setBorder(wStrategyEtchedEmptyBorder);
        wStatsPane.add((Component)wStrategy, "wStrategy");
        this.wStrategiesTable = new JTable(6, 6);
        this.wStrategiesTableModel = new StrategiesTableModel();
        this.wStrategiesTable.setModel(this.wStrategiesTableModel);
        this.wStrategiesTable.setColumnSelectionAllowed(false);
        this.wStrategiesTable.setRowSelectionAllowed(false);
        this.wStrategiesTable.setSelectionForeground(Color.WHITE);
        this.wStrategiesTable.setFont(ClientGui.f1b);
        if (DSModel.instance().getDisplaySize().value() < DisplaySizeEnum.LARGE.value()) {
            this.wStrategiesTable.setRowHeight(20);
        } else {
            this.wStrategiesTable.setRowHeight(23);
        }
        wStrategy.add((Component)this.wStrategiesTable, "Center");
        TableColumn column = this.wStrategiesTable.getColumnModel().getColumn(0);
        column.setMaxWidth(17);
        column.setMinWidth(17);
        column.setHeaderValue("#");
        column = this.wStrategiesTable.getColumnModel().getColumn(1);
        column.setPreferredWidth(270);
        column.setHeaderValue("Trigger");
        column = this.wStrategiesTable.getColumnModel().getColumn(2);
        column.setPreferredWidth(150);
        column.setHeaderValue("Style");
        column = this.wStrategiesTable.getColumnModel().getColumn(3);
        column.setMaxWidth(50);
        column.setMinWidth(50);
        column.setHeaderValue("Activity");
        column = this.wStrategiesTable.getColumnModel().getColumn(4);
        column.setMaxWidth(99);
        column.setMinWidth(99);
        column.setHeaderValue("Aiming Point");
        column = this.wStrategiesTable.getColumnModel().getColumn(5);
        column.setMaxWidth(99);
        column.setMinWidth(99);
        column.setHeaderValue("Defense Point");
        wStrategy.add((Component)this.wStrategiesTable.getTableHeader(), "North");
        this.wTriggerField = new BPComboBox(TriggerEnum.values());
        this.wStyleField = new BPComboBox(StyleEnum.values());
        this.wActivityField = new BPComboBox(ActivityLevelEnum.values());
        this.wAimPointField = new BPComboBox(AimingPointEnum.values());
        this.wDefPointField = new BPComboBox(AimingPointEnum.values());
        this.wTriggerField.setFont(ClientGui.f1b);
        this.wStyleField.setFont(ClientGui.f1b);
        this.wActivityField.setFont(ClientGui.f1b);
        this.wAimPointField.setFont(ClientGui.f1b);
        this.wDefPointField.setFont(ClientGui.f1b);
        this.wStrategiesTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(this.wTriggerField));
        this.wStrategiesTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(this.wStyleField));
        this.wStrategiesTable.getColumnModel().getColumn(3).setCellEditor(new DefaultCellEditor(this.wActivityField));
        this.wStrategiesTable.getColumnModel().getColumn(4).setCellEditor(new DefaultCellEditor(this.wAimPointField));
        this.wStrategiesTable.getColumnModel().getColumn(5).setCellEditor(new DefaultCellEditor(this.wDefPointField));
        this.strategiesTableListener = new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                WarriorGui.this.parentGui.playerDataChangedEvent(2);
            }
        };
        this.wStrategiesTableModel.addTableModelListener(this.strategiesTableListener);
        JPanel wSkills = new JPanel(new GridLayout(0, 2));
        Border wSkillsInnerEmptyBorder = BorderFactory.createEmptyBorder(6, 4, 2, 4);
        wSkills.setBorder(wSkillsInnerEmptyBorder);
        wStatsPane.add((Component)wSkills, "wSkills");
        JPanel wSkillsP1 = new JPanel(new BorderLayout());
        JPanel wSkillsP2 = new JPanel(new BorderLayout());
        Border wSkillsP1EmptyBorder = BorderFactory.createEmptyBorder(0, 0, 0, 2);
        Border wSkillsP2EmptyBorder = BorderFactory.createEmptyBorder(0, 2, 0, 0);
        wSkillsP1.setBorder(wSkillsP1EmptyBorder);
        wSkillsP2.setBorder(wSkillsP2EmptyBorder);
        wSkills.add(wSkillsP1);
        wSkills.add(wSkillsP2);
        JLabel wSkillsLabel = new JLabel("Skills");
        JLabel wPermsLabel = new JLabel("Permanent Injuries");
        wSkillsLabel.setHorizontalAlignment(0);
        wPermsLabel.setHorizontalAlignment(0);
        wSkillsP1.add((Component)wSkillsLabel, "North");
        wSkillsP2.add((Component)wPermsLabel, "North");
        this.wSkillsTextArea = new JTextArea();
        this.wPermsTextArea = new JTextArea();
        this.wSkillsTextArea.setRows(11);
        this.wPermsTextArea.setRows(11);
        JScrollPane wSkillsScrollPane = new JScrollPane();
        JScrollPane wPermsScrollPane = new JScrollPane();
        wSkillsScrollPane.getViewport().add(this.wSkillsTextArea);
        wPermsScrollPane.getViewport().add(this.wPermsTextArea);
        wSkillsP1.add((Component)wSkillsScrollPane, "Center");
        wSkillsP2.add((Component)wPermsScrollPane, "Center");
        wSkillsScrollPane.setHorizontalScrollBarPolicy(31);
        wPermsScrollPane.setHorizontalScrollBarPolicy(31);
        this.wSkillsTextArea.setEditable(false);
        this.wPermsTextArea.setEditable(false);
        this.wSkillsTextArea.setMargin(new Insets(2, 4, 2, 0));
        this.wPermsTextArea.setMargin(new Insets(2, 4, 2, 0));
        this.wSkillsTextArea.setFont(ClientGui.f0b);
        this.wPermsTextArea.setFont(ClientGui.f0b);
        wStatsPaneLayout.addConstraint("wHeader", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 0));
        wStatsPaneLayout.addConstraint("wHeader", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wStatsPaneLayout.addConstraint("wHeader", AttributeType.WIDTH, new AttributeConstraint("_container", AttributeType.WIDTH, 0));
        wStatsPaneLayout.addConstraint("wArmor", AttributeType.TOP, new AttributeConstraint("wHeader", AttributeType.BOTTOM, 0));
        wStatsPaneLayout.addConstraint("wArmor", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wStatsPaneLayout.addConstraint("wArmor", AttributeType.WIDTH, new AttributeConstraint("_container", AttributeType.WIDTH, 0));
        wStatsPaneLayout.addConstraint("wStrategy", AttributeType.TOP, new AttributeConstraint("wArmor", AttributeType.BOTTOM, 5));
        wStatsPaneLayout.addConstraint("wStrategy", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wStatsPaneLayout.addConstraint("wStrategy", AttributeType.WIDTH, new AttributeConstraint("_container", AttributeType.WIDTH, 0));
        wStatsPaneLayout.addConstraint("wSkills", AttributeType.TOP, new AttributeConstraint("wStrategy", AttributeType.BOTTOM, 0));
        wStatsPaneLayout.addConstraint("wSkills", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wStatsPaneLayout.addConstraint("wSkills", AttributeType.WIDTH, new AttributeConstraint("_container", AttributeType.WIDTH, 0));
        wStatsPaneLayout.addConstraint("wSkills", AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.BOTTOM, 0));
        JPanel wFightOpt = new JPanel();
        BoxLayout wFightOptLayout = new BoxLayout(wFightOpt, 0);
        Border wFightOptInnerEmptyBorder = BorderFactory.createEmptyBorder(0, 10, 6, 0);
        Border wFightOptEtchedBorder = BorderFactory.createEtchedBorder();
        CompoundBorder wFightOptEtchedEmptyBorder = BorderFactory.createCompoundBorder(wFightOptEtchedBorder, wFightOptInnerEmptyBorder);
        TitledBorder wFightOptTitledBorder = BorderFactory.createTitledBorder(wFightOptEtchedEmptyBorder, "Fight Options");
        wFightOpt.setBorder(wFightOptTitledBorder);
        wFightOptionsPane.add((Component)wFightOpt, "wFightOpt");
        this.wSinglesFightButton = new JRadioButton("Singles Fight");
        this.wTeamFightButton = new JRadioButton("Team Fight");
        this.wMonsterButton = new JRadioButton("Monster Warrior");
        this.wRetireButton = new JRadioButton("Retire Warrior");
        this.wEventButton = new JRadioButton("Arena Event");
        Border wTeamFightEmptyBorder = BorderFactory.createEmptyBorder(0, 0, 0, 12);
        this.wSinglesFightButton.setBorder(wTeamFightEmptyBorder);
        this.wTeamFightButton.setBorder(wTeamFightEmptyBorder);
        this.wMonsterButton.setBorder(wTeamFightEmptyBorder);
        this.wRetireButton.setBorder(wTeamFightEmptyBorder);
        wFightOpt.add(this.wSinglesFightButton);
        wFightOpt.add(this.wTeamFightButton);
        wFightOpt.add(this.wMonsterButton);
        wFightOpt.add(this.wRetireButton);
        wFightOpt.add(this.wEventButton);
        this.wSinglesFightButton.setSelected(true);
        ButtonGroup wFightOptGroup = new ButtonGroup();
        wFightOptGroup.add(this.wSinglesFightButton);
        wFightOptGroup.add(this.wTeamFightButton);
        wFightOptGroup.add(this.wMonsterButton);
        wFightOptGroup.add(this.wRetireButton);
        wFightOptGroup.add(this.wEventButton);
        this.wSinglesFightListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.w.setFightOptions(FightOptionsEnum.SINGLES_FIGHT);
                WarriorGui.this.setChallengeSelectionAllowed(true);
                WarriorGui.this.parentGui.playerDataChangedEvent(0);
                WarriorGui.this.wRosterTree.repaint();
                WarriorGui.this.wRankingList.repaint();
            }
        };
        this.wSinglesFightButton.addActionListener(this.wSinglesFightListener);
        this.wTeamFightListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.w.setFightOptions(FightOptionsEnum.TEAM_FIGHT);
                WarriorGui.this.setChallengeSelectionAllowed(false);
                WarriorGui.this.parentGui.playerDataChangedEvent(0);
                WarriorGui.this.wRosterTree.repaint();
                WarriorGui.this.wRankingList.repaint();
            }
        };
        this.wTeamFightButton.addActionListener(this.wTeamFightListener);
        this.wMonsterListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.w.setFightOptions(FightOptionsEnum.MONSTER);
                WarriorGui.this.setChallengeSelectionAllowed(false);
                WarriorGui.this.parentGui.playerDataChangedEvent(0);
                WarriorGui.this.wRosterTree.repaint();
                WarriorGui.this.wRankingList.repaint();
            }
        };
        this.wMonsterButton.addActionListener(this.wMonsterListener);
        this.wRetireListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.w.setFightOptions(FightOptionsEnum.RETIRE);
                WarriorGui.this.setChallengeSelectionAllowed(false);
                WarriorGui.this.parentGui.playerDataChangedEvent(0);
                WarriorGui.this.wRosterTree.repaint();
                WarriorGui.this.wRankingList.repaint();
            }
        };
        this.wRetireButton.addActionListener(this.wRetireListener);
        this.wEventFightListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.w.setFightOptions(FightOptionsEnum.EVENT);
                WarriorGui.this.parentGui.playerDataChangedEvent(0);
                WarriorGui.this.setChallengeSelectionAllowed(false);
                WarriorGui.this.wRosterTree.repaint();
                WarriorGui.this.wRankingList.repaint();
            }
        };
        this.wEventButton.addActionListener(this.wEventFightListener);
        JPanel wBloodcry1 = new JPanel();
        RelativeLayout wBloodcry1Layout = new RelativeLayout();
        wBloodcry1.setLayout(wBloodcry1Layout);
        Border wBloodcry1InnerEmptyBorder = BorderFactory.createEmptyBorder(0, 20, 6, 20);
        Border wBloodcry1EtchedBorder = BorderFactory.createEtchedBorder();
        CompoundBorder wBloodcry1EtchedEmptyBorder = BorderFactory.createCompoundBorder(wBloodcry1EtchedBorder, wBloodcry1InnerEmptyBorder);
        TitledBorder wBloodcry1TitledBorder = BorderFactory.createTitledBorder(wBloodcry1EtchedEmptyBorder, "Blood Cry 1");
        wBloodcry1.setBorder(wBloodcry1TitledBorder);
        wFightOptionsPane.add((Component)wBloodcry1, "wBloodcry1");
        this.wBloodcry1Trigger = new BPComboBox(BCTriggerEnum.values());
        this.wBloodcry1Field = new BPTextField(50, 76);
        wBloodcry1.add((Component)this.wBloodcry1Trigger, "Trigger");
        wBloodcry1.add((Component)this.wBloodcry1Field, "Text");
        wBloodcry1Layout.addConstraint("Trigger", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 0));
        wBloodcry1Layout.addConstraint("Trigger", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wBloodcry1Layout.addConstraint("Text", AttributeType.TOP, new AttributeConstraint("Trigger", AttributeType.BOTTOM, 10));
        wBloodcry1Layout.addConstraint("Text", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wBloodcry1Layout.addConstraint("Text", AttributeType.WIDTH, new AttributeConstraint("_container", AttributeType.WIDTH, 0));
        JPanel wBloodcry2 = new JPanel();
        RelativeLayout wBloodcry2Layout = new RelativeLayout();
        wBloodcry2.setLayout(wBloodcry2Layout);
        Border wBloodcry2InnerEmptyBorder = BorderFactory.createEmptyBorder(0, 20, 6, 20);
        Border wBloodcry2EtchedBorder = BorderFactory.createEtchedBorder();
        CompoundBorder wBloodcry2EtchedEmptyBorder = BorderFactory.createCompoundBorder(wBloodcry2EtchedBorder, wBloodcry2InnerEmptyBorder);
        TitledBorder wBloodcry2TitledBorder = BorderFactory.createTitledBorder(wBloodcry2EtchedEmptyBorder, "Blood Cry 2");
        wBloodcry2.setBorder(wBloodcry2TitledBorder);
        wFightOptionsPane.add((Component)wBloodcry2, "wBloodcry2");
        this.wBloodcry2Trigger = new BPComboBox(BCTriggerEnum.values());
        this.wBloodcry2Field = new BPTextField(50, 76);
        wBloodcry2.add((Component)this.wBloodcry2Trigger, "Trigger");
        wBloodcry2.add((Component)this.wBloodcry2Field, "Text");
        wBloodcry2Layout.addConstraint("Trigger", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 0));
        wBloodcry2Layout.addConstraint("Trigger", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wBloodcry2Layout.addConstraint("Text", AttributeType.TOP, new AttributeConstraint("Trigger", AttributeType.BOTTOM, 10));
        wBloodcry2Layout.addConstraint("Text", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wBloodcry2Layout.addConstraint("Text", AttributeType.WIDTH, new AttributeConstraint("_container", AttributeType.WIDTH, 0));
        this.wBloodcry1Field.setFont(ClientGui.f1b);
        this.wBloodcry2Field.setFont(ClientGui.f1b);
        wFightOptionsLayout.addConstraint("wFightOpt", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 0));
        wFightOptionsLayout.addConstraint("wFightOpt", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wFightOptionsLayout.addConstraint("wFightOpt", AttributeType.WIDTH, new AttributeConstraint("_container", AttributeType.WIDTH, 0));
        wFightOptionsLayout.addConstraint("wBloodcry1", AttributeType.TOP, new AttributeConstraint("wFightOpt", AttributeType.BOTTOM, 0));
        wFightOptionsLayout.addConstraint("wBloodcry1", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wFightOptionsLayout.addConstraint("wBloodcry1", AttributeType.WIDTH, new AttributeConstraint("_container", AttributeType.WIDTH, 0));
        wFightOptionsLayout.addConstraint("wBloodcry2", AttributeType.TOP, new AttributeConstraint("wBloodcry1", AttributeType.BOTTOM, 0));
        wFightOptionsLayout.addConstraint("wBloodcry2", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wFightOptionsLayout.addConstraint("wBloodcry2", AttributeType.WIDTH, new AttributeConstraint("_container", AttributeType.WIDTH, 0));
        this.wBloodcry1TriggerListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.w.getBloodCrys().getBloodCry(0).setTrigger((BCTriggerEnum)WarriorGui.this.wBloodcry1Trigger.getSelectedItem());
                WarriorGui.this.parentGui.playerDataChangedEvent(2);
            }
        };
        this.wBloodcry1Trigger.addActionListener(this.wBloodcry1TriggerListener);
        this.wBloodcry2TriggerListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.w.getBloodCrys().getBloodCry(1).setTrigger((BCTriggerEnum)WarriorGui.this.wBloodcry2Trigger.getSelectedItem());
                WarriorGui.this.parentGui.playerDataChangedEvent(2);
            }
        };
        this.wBloodcry2Trigger.addActionListener(this.wBloodcry2TriggerListener);
        this.wBloodcry1FieldListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                WarriorGui.this.w.getBloodCrys().getBloodCry(0).setText(WarriorGui.this.wBloodcry1Field.getText());
                WarriorGui.this.parentGui.playerDataChangedEvent(2);
            }

            public void removeUpdate(DocumentEvent e) {
                WarriorGui.this.w.getBloodCrys().getBloodCry(0).setText(WarriorGui.this.wBloodcry1Field.getText());
                WarriorGui.this.parentGui.playerDataChangedEvent(2);
            }

            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.wBloodcry1Field.getDocument().addDocumentListener(this.wBloodcry1FieldListener);
        this.wBloodcry2FieldListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                WarriorGui.this.w.getBloodCrys().getBloodCry(1).setText(WarriorGui.this.wBloodcry2Field.getText());
                WarriorGui.this.parentGui.playerDataChangedEvent(2);
            }

            public void removeUpdate(DocumentEvent e) {
                WarriorGui.this.w.getBloodCrys().getBloodCry(1).setText(WarriorGui.this.wBloodcry2Field.getText());
                WarriorGui.this.parentGui.playerDataChangedEvent(2);
            }

            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.wBloodcry2Field.getDocument().addDocumentListener(this.wBloodcry2FieldListener);
        RelativeLayout wChallengePanelLayout = new RelativeLayout();
        this.wChallengePanel = new JPanel(wChallengePanelLayout);
        TitledBorder wChallengeTitledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Challenges/Refusals");
        this.wChallengePanel.setBorder(wChallengeTitledBorder);
        wChallengesPane.add((Component)this.wChallengePanel, "Center");
        this.wRankingRosterPane = new JTabbedPane();
        Border wRankingRosterEmptyBorder = BorderFactory.createEmptyBorder(5, 6, 3, 3);
        this.wRankingRosterPane.setBorder(wRankingRosterEmptyBorder);
        this.wRankingRosterPane.setFont(ClientGui.f1b);
        this.wChallengePanel.add((Component)this.wRankingRosterPane, "RankingRoster");
        JPanel wRankingPanel = new JPanel(new BorderLayout());
        this.wRankingRosterPane.add(RANKING_TAB_NAME, wRankingPanel);
        this.wRankingList = new JList();
        this.wRankingList.setCellRenderer(new DescriptorListCellRenderer());
        this.wRankingList.setSelectionMode(0);
        this.wRankingList.setFixedCellHeight(20);
        JScrollPane wRankingScroll = new JScrollPane(this.wRankingList);
        wRankingPanel.add((Component)wRankingScroll, "Center");
        this.wRankingList.setFont(ClientGui.f1p);
        JPanel bloodChallengePanel = new JPanel(new BorderLayout());
        this.wRankingRosterPane.add(BLOOD_CHALLENGE_TAB_NAME, bloodChallengePanel);
        this.bloodChallengeList = new JList();
        this.bloodChallengeList.setCellRenderer(new BCDescriptorListCellRenderer());
        this.bloodChallengeList.setSelectionMode(0);
        this.bloodChallengeList.setFixedCellHeight(20);
        JScrollPane bloodChallengeScroll = new JScrollPane(this.bloodChallengeList);
        bloodChallengePanel.add((Component)bloodChallengeScroll, "Center");
        this.bloodChallengeList.setFont(ClientGui.f1p);
        JPanel wRosterPanel = new JPanel(new BorderLayout());
        this.wRankingRosterPane.add(ARENA_TAB_NAME, wRosterPanel);
        this.wRosterTree = new JTree();
        JScrollPane wRosterScroll = new JScrollPane(this.wRosterTree);
        wRosterPanel.add((Component)wRosterScroll, "Center");
        this.wRankingRosterPane.setSelectedIndex(0);
        this.wRosterTree.setFont(ClientGui.f1p);
        BorderLayout wChallengeSelectLayout = new BorderLayout();
        JPanel wChallengeSelect = new JPanel(wChallengeSelectLayout);
        Border wChallengeSelectEmptyBorder = BorderFactory.createEmptyBorder(15, 10, 8, 5);
        wChallengeSelect.setBorder(wChallengeSelectEmptyBorder);
        this.wChallengePanel.add((Component)wChallengeSelect, "ChallengeSelect");
        wChallengePanelLayout.addConstraint("RankingRoster", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 0));
        wChallengePanelLayout.addConstraint("RankingRoster", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wChallengePanelLayout.addConstraint("RankingRoster", AttributeType.RIGHT, new AxisConstraint("_container", AttributeAxis.HORIZONTAL, 0.45));
        wChallengePanelLayout.addConstraint("RankingRoster", AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.BOTTOM, 0));
        wChallengePanelLayout.addConstraint("ChallengeSelect", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 0));
        wChallengePanelLayout.addConstraint("ChallengeSelect", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, 0));
        wChallengePanelLayout.addConstraint("ChallengeSelect", AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.BOTTOM, 0));
        wChallengePanelLayout.addConstraint("ChallengeSelect", AttributeType.LEFT, new AttributeConstraint("RankingRoster", AttributeType.RIGHT, 0));
        RelativeLayout wSelectChallenge1Layout = new RelativeLayout();
        RelativeLayout wSelectChallenge2Layout = new RelativeLayout();
        RelativeLayout wSelectChallenge3Layout = new RelativeLayout();
        RelativeLayout wSelectDetailLayout = new RelativeLayout();
        RelativeLayout wSelectRefusal1Layout = new RelativeLayout();
        RelativeLayout wSelectRefusal2Layout = new RelativeLayout();
        RelativeLayout wSelectRefusal3Layout = new RelativeLayout();
        JPanel wSelectChallengeP1 = new JPanel(wSelectChallenge1Layout);
        JPanel wSelectChallengeP2 = new JPanel(wSelectChallenge2Layout);
        JPanel wSelectChallengeP3 = new JPanel(wSelectChallenge3Layout);
        JPanel wSelectDetail = new JPanel(wSelectDetailLayout);
        JPanel wSelectRefusalP1 = new JPanel(wSelectRefusal1Layout);
        JPanel wSelectRefusalP2 = new JPanel(wSelectRefusal2Layout);
        JPanel wSelectRefusalP3 = new JPanel(wSelectRefusal3Layout);
        JPanel wSelectChallengeTop = new JPanel(new GridLayout(3, 0));
        JPanel wSelectChallengeBottom = new JPanel(new GridLayout(3, 0));
        wSelectChallengeTop.add(wSelectChallengeP1);
        wSelectChallengeTop.add(wSelectChallengeP2);
        wSelectChallengeTop.add(wSelectChallengeP3);
        wSelectChallengeBottom.add(wSelectRefusalP1);
        wSelectChallengeBottom.add(wSelectRefusalP2);
        wSelectChallengeBottom.add(wSelectRefusalP3);
        wChallengeSelect.add((Component)wSelectChallengeTop, "North");
        wChallengeSelect.add((Component)wSelectDetail, "Center");
        wChallengeSelect.add((Component)wSelectChallengeBottom, "South");
        JLabel wSelectChallenge1Label = new JLabel("Challenge 1");
        JLabel wSelectChallenge2Label = new JLabel("Challenge 2");
        JLabel wSelectChallenge3Label = new JLabel("Challenge 3");
        JLabel wSelectRefusal1Label = new JLabel("Refusal 1");
        JLabel wSelectRefusal2Label = new JLabel("Refusal 2");
        JLabel wSelectRefusal3Label = new JLabel("Refusal 3");
        wSelectChallenge1Label.setHorizontalAlignment(0);
        wSelectChallenge2Label.setHorizontalAlignment(0);
        wSelectChallenge3Label.setHorizontalAlignment(0);
        wSelectRefusal1Label.setHorizontalAlignment(0);
        wSelectRefusal2Label.setHorizontalAlignment(0);
        wSelectRefusal3Label.setHorizontalAlignment(0);
        this.wSelectChallenge1Field = new BPIconLabel();
        this.wSelectChallenge2Field = new BPIconLabel();
        this.wSelectChallenge3Field = new BPIconLabel();
        this.wSelectChallenge1Field.setFont(ClientGui.f1p);
        this.wSelectChallenge2Field.setFont(ClientGui.f1p);
        this.wSelectChallenge3Field.setFont(ClientGui.f1p);
        this.wSelectRefusal1Field = new BPIconLabel();
        this.wSelectRefusal2Field = new BPIconLabel();
        this.wSelectRefusal3Field = new BPIconLabel();
        this.wSelectRefusal1Field.setFont(ClientGui.f1p);
        this.wSelectRefusal2Field.setFont(ClientGui.f1p);
        this.wSelectRefusal3Field.setFont(ClientGui.f1p);
        CompoundBorder wChallengeSelectButtonBorder = BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 3, 2, 3));
        this.wSelectChallenge1B = new JButton(MainGui.RIGHT_ARROW_ICON);
        this.wSelectChallenge2B = new JButton(MainGui.RIGHT_ARROW_ICON);
        this.wSelectChallenge3B = new JButton(MainGui.RIGHT_ARROW_ICON);
        this.wSelectChallenge1B.setBorder(wChallengeSelectButtonBorder);
        this.wSelectChallenge2B.setBorder(wChallengeSelectButtonBorder);
        this.wSelectChallenge3B.setBorder(wChallengeSelectButtonBorder);
        this.wSelectChallenge1B.setHorizontalAlignment(0);
        this.wSelectChallenge2B.setHorizontalAlignment(0);
        this.wSelectChallenge3B.setHorizontalAlignment(0);
        this.wSelectDetailText = new JTable(10, 3);
        this.wSelectDetailText.setBorder(BorderFactory.createLoweredBevelBorder());
        this.wSelectDetailText.getColumnModel().getColumn(0).setMaxWidth(1);
        this.wSelectDetailText.getColumnModel().getColumn(1).setMaxWidth(155);
        this.wSelectDetailText.setRowMargin(2);
        this.wSelectDetailText.setShowGrid(false);
        this.wSelectDetailText.setCellSelectionEnabled(false);
        this.wSelectDetailText.setEnabled(false);
        this.wSelectDetailText.setFont(ClientGui.f1p);
        this.wSelectRefusal1B = new JButton(MainGui.RIGHT_ARROW_ICON);
        this.wSelectRefusal2B = new JButton(MainGui.RIGHT_ARROW_ICON);
        this.wSelectRefusal3B = new JButton(MainGui.RIGHT_ARROW_ICON);
        this.wSelectRefusal1B.setBorder(wChallengeSelectButtonBorder);
        this.wSelectRefusal2B.setBorder(wChallengeSelectButtonBorder);
        this.wSelectRefusal3B.setBorder(wChallengeSelectButtonBorder);
        this.wSelectRefusal1B.setHorizontalAlignment(0);
        this.wSelectRefusal2B.setHorizontalAlignment(0);
        this.wSelectRefusal3B.setHorizontalAlignment(0);
        this.wClearChallenge1B = new JButton(MainGui.CLEAR_SELECTION_ICON);
        this.wClearChallenge2B = new JButton(MainGui.CLEAR_SELECTION_ICON);
        this.wClearChallenge3B = new JButton(MainGui.CLEAR_SELECTION_ICON);
        this.wClearRefusal1B = new JButton(MainGui.CLEAR_SELECTION_ICON);
        this.wClearRefusal2B = new JButton(MainGui.CLEAR_SELECTION_ICON);
        this.wClearRefusal3B = new JButton(MainGui.CLEAR_SELECTION_ICON);
        wSelectChallengeP1.add((Component)wSelectChallenge1Label, "Label");
        wSelectChallengeP1.add((Component)this.wSelectChallenge1Field, "Field");
        wSelectChallengeP1.add((Component)this.wSelectChallenge1B, "Select");
        wSelectChallengeP1.add((Component)this.wClearChallenge1B, "Clear");
        wSelectChallenge1Layout.addConstraint("Label", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 12));
        wSelectChallenge1Layout.addConstraint("Label", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wSelectChallenge1Layout.addConstraint("Label", AttributeType.HORIZONTAL_CENTER, new AxisConstraint("Field", AttributeAxis.HORIZONTAL, 0.5));
        wSelectChallenge1Layout.addConstraint("Select", AttributeType.TOP, new AttributeConstraint("Label", AttributeType.BOTTOM, 3));
        wSelectChallenge1Layout.addConstraint("Select", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wSelectChallenge1Layout.addConstraint("Field", AttributeType.TOP, new AttributeConstraint("Label", AttributeType.BOTTOM, 3));
        wSelectChallenge1Layout.addConstraint("Field", AttributeType.LEFT, new AttributeConstraint("Select", AttributeType.RIGHT, 3));
        wSelectChallenge1Layout.addConstraint("Field", AttributeType.RIGHT, new AxisConstraint("_container", AttributeAxis.HORIZONTAL, 0.91));
        wSelectChallenge1Layout.addConstraint("Field", AttributeType.BOTTOM, new AttributeConstraint("Select", AttributeType.BOTTOM, 0));
        wSelectChallenge1Layout.addConstraint("Clear", AttributeType.TOP, new AttributeConstraint("Label", AttributeType.BOTTOM, 3));
        wSelectChallenge1Layout.addConstraint("Clear", AttributeType.LEFT, new AttributeConstraint("Field", AttributeType.RIGHT, 5));
        wSelectChallenge1Layout.addConstraint("Clear", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, 0));
        wSelectChallenge1Layout.addConstraint("Clear", AttributeType.BOTTOM, new AttributeConstraint("Select", AttributeType.BOTTOM, 0));
        wSelectChallengeP2.add((Component)wSelectChallenge2Label, "Label");
        wSelectChallengeP2.add((Component)this.wSelectChallenge2Field, "Field");
        wSelectChallengeP2.add((Component)this.wSelectChallenge2B, "Select");
        wSelectChallengeP2.add((Component)this.wClearChallenge2B, "Clear");
        wSelectChallenge2Layout.addConstraint("Label", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 15));
        wSelectChallenge2Layout.addConstraint("Label", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wSelectChallenge2Layout.addConstraint("Label", AttributeType.HORIZONTAL_CENTER, new AxisConstraint("Field", AttributeAxis.HORIZONTAL, 0.5));
        wSelectChallenge2Layout.addConstraint("Select", AttributeType.TOP, new AttributeConstraint("Label", AttributeType.BOTTOM, 3));
        wSelectChallenge2Layout.addConstraint("Select", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wSelectChallenge2Layout.addConstraint("Field", AttributeType.TOP, new AttributeConstraint("Label", AttributeType.BOTTOM, 3));
        wSelectChallenge2Layout.addConstraint("Field", AttributeType.LEFT, new AttributeConstraint("Select", AttributeType.RIGHT, 3));
        wSelectChallenge2Layout.addConstraint("Field", AttributeType.RIGHT, new AxisConstraint("_container", AttributeAxis.HORIZONTAL, 0.91));
        wSelectChallenge2Layout.addConstraint("Field", AttributeType.BOTTOM, new AttributeConstraint("Select", AttributeType.BOTTOM, 0));
        wSelectChallenge2Layout.addConstraint("Clear", AttributeType.TOP, new AttributeConstraint("Label", AttributeType.BOTTOM, 3));
        wSelectChallenge2Layout.addConstraint("Clear", AttributeType.LEFT, new AttributeConstraint("Field", AttributeType.RIGHT, 5));
        wSelectChallenge2Layout.addConstraint("Clear", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, 0));
        wSelectChallenge2Layout.addConstraint("Clear", AttributeType.BOTTOM, new AttributeConstraint("Select", AttributeType.BOTTOM, 0));
        wSelectChallengeP3.add((Component)wSelectChallenge3Label, "Label");
        wSelectChallengeP3.add((Component)this.wSelectChallenge3Field, "Field");
        wSelectChallengeP3.add((Component)this.wSelectChallenge3B, "Select");
        wSelectChallengeP3.add((Component)this.wClearChallenge3B, "Clear");
        wSelectChallenge3Layout.addConstraint("Label", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 15));
        wSelectChallenge3Layout.addConstraint("Label", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wSelectChallenge3Layout.addConstraint("Label", AttributeType.HORIZONTAL_CENTER, new AxisConstraint("Field", AttributeAxis.HORIZONTAL, 0.5));
        wSelectChallenge3Layout.addConstraint("Select", AttributeType.TOP, new AttributeConstraint("Label", AttributeType.BOTTOM, 3));
        wSelectChallenge3Layout.addConstraint("Select", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wSelectChallenge3Layout.addConstraint("Field", AttributeType.TOP, new AttributeConstraint("Label", AttributeType.BOTTOM, 3));
        wSelectChallenge3Layout.addConstraint("Field", AttributeType.LEFT, new AttributeConstraint("Select", AttributeType.RIGHT, 3));
        wSelectChallenge3Layout.addConstraint("Field", AttributeType.RIGHT, new AxisConstraint("_container", AttributeAxis.HORIZONTAL, 0.91));
        wSelectChallenge3Layout.addConstraint("Field", AttributeType.BOTTOM, new AttributeConstraint("Select", AttributeType.BOTTOM, 0));
        wSelectChallenge3Layout.addConstraint("Clear", AttributeType.TOP, new AttributeConstraint("Label", AttributeType.BOTTOM, 3));
        wSelectChallenge3Layout.addConstraint("Clear", AttributeType.LEFT, new AttributeConstraint("Field", AttributeType.RIGHT, 5));
        wSelectChallenge3Layout.addConstraint("Clear", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, 0));
        wSelectChallenge3Layout.addConstraint("Clear", AttributeType.BOTTOM, new AttributeConstraint("Select", AttributeType.BOTTOM, 0));
        wSelectDetail.add((Component)this.wSelectDetailText, "Text");
        wSelectDetailLayout.addConstraint("Text", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 25));
        wSelectDetailLayout.addConstraint("Text", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 10));
        wSelectDetailLayout.addConstraint("Text", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, -15));
        wSelectDetailLayout.addConstraint("Text", AttributeType.BOTTOM, new AttributeConstraint("_container", AttributeType.BOTTOM, -2));
        wSelectRefusalP1.add((Component)wSelectRefusal1Label, "Label");
        wSelectRefusalP1.add((Component)this.wSelectRefusal1Field, "Field");
        wSelectRefusalP1.add((Component)this.wSelectRefusal1B, "Select");
        wSelectRefusalP1.add((Component)this.wClearRefusal1B, "Clear");
        wSelectRefusal1Layout.addConstraint("Label", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 15));
        wSelectRefusal1Layout.addConstraint("Label", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wSelectRefusal1Layout.addConstraint("Label", AttributeType.HORIZONTAL_CENTER, new AxisConstraint("Field", AttributeAxis.HORIZONTAL, 0.5));
        wSelectRefusal1Layout.addConstraint("Select", AttributeType.TOP, new AttributeConstraint("Label", AttributeType.BOTTOM, 3));
        wSelectRefusal1Layout.addConstraint("Select", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wSelectRefusal1Layout.addConstraint("Field", AttributeType.TOP, new AttributeConstraint("Label", AttributeType.BOTTOM, 3));
        wSelectRefusal1Layout.addConstraint("Field", AttributeType.LEFT, new AttributeConstraint("Select", AttributeType.RIGHT, 3));
        wSelectRefusal1Layout.addConstraint("Field", AttributeType.RIGHT, new AxisConstraint("_container", AttributeAxis.HORIZONTAL, 0.91));
        wSelectRefusal1Layout.addConstraint("Field", AttributeType.BOTTOM, new AttributeConstraint("Select", AttributeType.BOTTOM, 0));
        wSelectRefusal1Layout.addConstraint("Clear", AttributeType.TOP, new AttributeConstraint("Label", AttributeType.BOTTOM, 3));
        wSelectRefusal1Layout.addConstraint("Clear", AttributeType.LEFT, new AttributeConstraint("Field", AttributeType.RIGHT, 5));
        wSelectRefusal1Layout.addConstraint("Clear", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, 0));
        wSelectRefusal1Layout.addConstraint("Clear", AttributeType.BOTTOM, new AttributeConstraint("Select", AttributeType.BOTTOM, 0));
        wSelectRefusalP2.add((Component)wSelectRefusal2Label, "Label");
        wSelectRefusalP2.add((Component)this.wSelectRefusal2Field, "Field");
        wSelectRefusalP2.add((Component)this.wSelectRefusal2B, "Select");
        wSelectRefusalP2.add((Component)this.wClearRefusal2B, "Clear");
        wSelectRefusal2Layout.addConstraint("Label", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 15));
        wSelectRefusal2Layout.addConstraint("Label", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wSelectRefusal2Layout.addConstraint("Label", AttributeType.HORIZONTAL_CENTER, new AxisConstraint("Field", AttributeAxis.HORIZONTAL, 0.5));
        wSelectRefusal2Layout.addConstraint("Select", AttributeType.TOP, new AttributeConstraint("Label", AttributeType.BOTTOM, 3));
        wSelectRefusal2Layout.addConstraint("Select", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wSelectRefusal2Layout.addConstraint("Field", AttributeType.TOP, new AttributeConstraint("Label", AttributeType.BOTTOM, 3));
        wSelectRefusal2Layout.addConstraint("Field", AttributeType.LEFT, new AttributeConstraint("Select", AttributeType.RIGHT, 3));
        wSelectRefusal2Layout.addConstraint("Field", AttributeType.RIGHT, new AxisConstraint("_container", AttributeAxis.HORIZONTAL, 0.91));
        wSelectRefusal2Layout.addConstraint("Field", AttributeType.BOTTOM, new AttributeConstraint("Select", AttributeType.BOTTOM, 0));
        wSelectRefusal2Layout.addConstraint("Clear", AttributeType.TOP, new AttributeConstraint("Label", AttributeType.BOTTOM, 3));
        wSelectRefusal2Layout.addConstraint("Clear", AttributeType.LEFT, new AttributeConstraint("Field", AttributeType.RIGHT, 5));
        wSelectRefusal2Layout.addConstraint("Clear", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, 0));
        wSelectRefusal2Layout.addConstraint("Clear", AttributeType.BOTTOM, new AttributeConstraint("Select", AttributeType.BOTTOM, 0));
        wSelectRefusalP3.add((Component)wSelectRefusal3Label, "Label");
        wSelectRefusalP3.add((Component)this.wSelectRefusal3Field, "Field");
        wSelectRefusalP3.add((Component)this.wSelectRefusal3B, "Select");
        wSelectRefusalP3.add((Component)this.wClearRefusal3B, "Clear");
        wSelectRefusal3Layout.addConstraint("Label", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 15));
        wSelectRefusal3Layout.addConstraint("Label", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wSelectRefusal3Layout.addConstraint("Label", AttributeType.HORIZONTAL_CENTER, new AxisConstraint("Field", AttributeAxis.HORIZONTAL, 0.5));
        wSelectRefusal3Layout.addConstraint("Select", AttributeType.TOP, new AttributeConstraint("Label", AttributeType.BOTTOM, 3));
        wSelectRefusal3Layout.addConstraint("Select", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wSelectRefusal3Layout.addConstraint("Field", AttributeType.TOP, new AttributeConstraint("Label", AttributeType.BOTTOM, 3));
        wSelectRefusal3Layout.addConstraint("Field", AttributeType.LEFT, new AttributeConstraint("Select", AttributeType.RIGHT, 3));
        wSelectRefusal3Layout.addConstraint("Field", AttributeType.RIGHT, new AxisConstraint("_container", AttributeAxis.HORIZONTAL, 0.91));
        wSelectRefusal3Layout.addConstraint("Field", AttributeType.BOTTOM, new AttributeConstraint("Select", AttributeType.BOTTOM, 0));
        wSelectRefusal3Layout.addConstraint("Clear", AttributeType.TOP, new AttributeConstraint("Label", AttributeType.BOTTOM, 3));
        wSelectRefusal3Layout.addConstraint("Clear", AttributeType.LEFT, new AttributeConstraint("Field", AttributeType.RIGHT, 5));
        wSelectRefusal3Layout.addConstraint("Clear", AttributeType.RIGHT, new AttributeConstraint("_container", AttributeType.RIGHT, 0));
        wSelectRefusal3Layout.addConstraint("Clear", AttributeType.BOTTOM, new AttributeConstraint("Select", AttributeType.BOTTOM, 0));
        this.wRankingList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                block5: {
                    block4: {
                        if (e.getValueIsAdjusting()) {
                            return;
                        }
                        JList theList = (JList)e.getSource();
                        if (!WarriorGui.this.wRankingList.isSelectionEmpty()) break block4;
                        for (int i = 0; i < CHALLENGE_DETAIL_ROWS; ++i) {
                            WarriorGui.this.wSelectDetailText.setValueAt("", i, 1);
                            WarriorGui.this.wSelectDetailText.setValueAt("", i, 2);
                        }
                        break block5;
                    }
                    DescriptorDisplayAdapter dda = (DescriptorDisplayAdapter)WarriorGui.this.wRankingList.getSelectedValue();
                    if (dda == null) break block5;
                    Vector detail = dda.getDetail();
                    for (int i = 0; i < CHALLENGE_DETAIL_ROWS; ++i) {
                        if (i < detail.size()) {
                            WarriorGui.this.wSelectDetailText.setValueAt(((DescriptorDisplayAdapter.NVPair)detail.get((int)i)).name, i, 1);
                            WarriorGui.this.wSelectDetailText.setValueAt(((DescriptorDisplayAdapter.NVPair)detail.get((int)i)).value, i, 2);
                            continue;
                        }
                        WarriorGui.this.wSelectDetailText.setValueAt("", i, 1);
                        WarriorGui.this.wSelectDetailText.setValueAt("", i, 2);
                    }
                }
            }
        });
        this.wRosterTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)WarriorGui.this.wRosterTree.getLastSelectedPathComponent();
                if (node == null) {
                    for (int i = 0; i < CHALLENGE_DETAIL_ROWS; ++i) {
                        WarriorGui.this.wSelectDetailText.setValueAt("", i, 1);
                        WarriorGui.this.wSelectDetailText.setValueAt("", i, 2);
                    }
                    return;
                }
                DescriptorDisplayAdapter dda = (DescriptorDisplayAdapter)node.getUserObject();
                if (dda != null) {
                    Vector detail = dda.getDetail();
                    for (int i = 0; i < CHALLENGE_DETAIL_ROWS; ++i) {
                        if (i < detail.size()) {
                            WarriorGui.this.wSelectDetailText.setValueAt(((DescriptorDisplayAdapter.NVPair)detail.get((int)i)).name, i, 1);
                            WarriorGui.this.wSelectDetailText.setValueAt(((DescriptorDisplayAdapter.NVPair)detail.get((int)i)).value, i, 2);
                            continue;
                        }
                        WarriorGui.this.wSelectDetailText.setValueAt("", i, 1);
                        WarriorGui.this.wSelectDetailText.setValueAt("", i, 2);
                    }
                }
            }
        });
        this.bloodChallengeList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                block5: {
                    block4: {
                        if (e.getValueIsAdjusting()) {
                            return;
                        }
                        JList theList = (JList)e.getSource();
                        if (!WarriorGui.this.bloodChallengeList.isSelectionEmpty()) break block4;
                        for (int i = 0; i < CHALLENGE_DETAIL_ROWS; ++i) {
                            WarriorGui.this.wSelectDetailText.setValueAt("", i, 1);
                            WarriorGui.this.wSelectDetailText.setValueAt("", i, 2);
                        }
                        break block5;
                    }
                    DescriptorDisplayAdapter dda = (DescriptorDisplayAdapter)WarriorGui.this.bloodChallengeList.getSelectedValue();
                    if (dda == null) break block5;
                    Vector detail = dda.getDetail();
                    for (int i = 0; i < CHALLENGE_DETAIL_ROWS; ++i) {
                        if (i < detail.size()) {
                            WarriorGui.this.wSelectDetailText.setValueAt(((DescriptorDisplayAdapter.NVPair)detail.get((int)i)).name, i, 1);
                            WarriorGui.this.wSelectDetailText.setValueAt(((DescriptorDisplayAdapter.NVPair)detail.get((int)i)).value, i, 2);
                            continue;
                        }
                        WarriorGui.this.wSelectDetailText.setValueAt("", i, 1);
                        WarriorGui.this.wSelectDetailText.setValueAt("", i, 2);
                    }
                }
            }
        });
        this.wSelectChallenge1B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DescriptorDisplayAdapter dda = null;
                String tabName = WarriorGui.this.wRankingRosterPane.getTitleAt(WarriorGui.this.wRankingRosterPane.getSelectedIndex());
                if (tabName.equals(RANKING_TAB_NAME)) {
                    if (!WarriorGui.this.wRankingList.isSelectionEmpty()) {
                        dda = (DescriptorDisplayAdapter)WarriorGui.this.wRankingList.getSelectedValue();
                    }
                } else if (tabName.equals(BLOOD_CHALLENGE_TAB_NAME)) {
                    if (!WarriorGui.this.bloodChallengeList.isSelectionEmpty()) {
                        dda = (DescriptorDisplayAdapter)WarriorGui.this.bloodChallengeList.getSelectedValue();
                    }
                } else if (tabName.equals(ARENA_TAB_NAME) && !WarriorGui.this.wRosterTree.isSelectionEmpty()) {
                    DefaultMutableTreeNode n = (DefaultMutableTreeNode)WarriorGui.this.wRosterTree.getLastSelectedPathComponent();
                    dda = (DescriptorDisplayAdapter)n.getUserObject();
                }
                if (dda != null) {
                    Descriptor d = dda.getDescriptor();
                    if (dda.isChallengable()) {
                        WarriorGui.this.w.getChallenges().setChallenge(0, d.createDescriptorIdentifier());
                        WarriorGui.this.parentGui.playerDataChangedEvent(2);
                        WarriorGui.this.setChallengeFieldContents(WarriorGui.this.wSelectChallenge1Field, dda);
                    }
                }
            }
        });
        this.wSelectChallenge2B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DescriptorDisplayAdapter dda = null;
                String tabName = WarriorGui.this.wRankingRosterPane.getTitleAt(WarriorGui.this.wRankingRosterPane.getSelectedIndex());
                if (tabName.equals(RANKING_TAB_NAME)) {
                    if (!WarriorGui.this.wRankingList.isSelectionEmpty()) {
                        dda = (DescriptorDisplayAdapter)WarriorGui.this.wRankingList.getSelectedValue();
                    }
                } else if (tabName.equals(BLOOD_CHALLENGE_TAB_NAME)) {
                    if (!WarriorGui.this.bloodChallengeList.isSelectionEmpty()) {
                        dda = (DescriptorDisplayAdapter)WarriorGui.this.bloodChallengeList.getSelectedValue();
                    }
                } else if (tabName.equals(ARENA_TAB_NAME) && !WarriorGui.this.wRosterTree.isSelectionEmpty()) {
                    DefaultMutableTreeNode n = (DefaultMutableTreeNode)WarriorGui.this.wRosterTree.getLastSelectedPathComponent();
                    dda = (DescriptorDisplayAdapter)n.getUserObject();
                }
                if (dda != null) {
                    Descriptor d = dda.getDescriptor();
                    if (dda.isChallengable()) {
                        WarriorGui.this.w.getChallenges().setChallenge(1, d.createDescriptorIdentifier());
                        WarriorGui.this.parentGui.playerDataChangedEvent(2);
                        WarriorGui.this.setChallengeFieldContents(WarriorGui.this.wSelectChallenge2Field, dda);
                    }
                }
            }
        });
        this.wSelectChallenge3B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DescriptorDisplayAdapter dda = null;
                String tabName = WarriorGui.this.wRankingRosterPane.getTitleAt(WarriorGui.this.wRankingRosterPane.getSelectedIndex());
                if (tabName.equals(RANKING_TAB_NAME)) {
                    if (!WarriorGui.this.wRankingList.isSelectionEmpty()) {
                        dda = (DescriptorDisplayAdapter)WarriorGui.this.wRankingList.getSelectedValue();
                    }
                } else if (tabName.equals(BLOOD_CHALLENGE_TAB_NAME)) {
                    if (!WarriorGui.this.bloodChallengeList.isSelectionEmpty()) {
                        dda = (DescriptorDisplayAdapter)WarriorGui.this.bloodChallengeList.getSelectedValue();
                    }
                } else if (tabName.equals(ARENA_TAB_NAME) && !WarriorGui.this.wRosterTree.isSelectionEmpty()) {
                    DefaultMutableTreeNode n = (DefaultMutableTreeNode)WarriorGui.this.wRosterTree.getLastSelectedPathComponent();
                    dda = (DescriptorDisplayAdapter)n.getUserObject();
                }
                if (dda != null) {
                    Descriptor d = dda.getDescriptor();
                    if (dda.isChallengable()) {
                        WarriorGui.this.w.getChallenges().setChallenge(2, d.createDescriptorIdentifier());
                        WarriorGui.this.parentGui.playerDataChangedEvent(2);
                        WarriorGui.this.setChallengeFieldContents(WarriorGui.this.wSelectChallenge3Field, dda);
                    }
                }
            }
        });
        this.wSelectRefusal1B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DescriptorDisplayAdapter dda = null;
                String tabName = WarriorGui.this.wRankingRosterPane.getTitleAt(WarriorGui.this.wRankingRosterPane.getSelectedIndex());
                if (tabName.equals(RANKING_TAB_NAME)) {
                    if (!WarriorGui.this.wRankingList.isSelectionEmpty()) {
                        dda = (DescriptorDisplayAdapter)WarriorGui.this.wRankingList.getSelectedValue();
                    }
                } else if (tabName.equals(BLOOD_CHALLENGE_TAB_NAME)) {
                    if (!WarriorGui.this.bloodChallengeList.isSelectionEmpty()) {
                        dda = (DescriptorDisplayAdapter)WarriorGui.this.bloodChallengeList.getSelectedValue();
                    }
                } else if (tabName.equals(ARENA_TAB_NAME) && !WarriorGui.this.wRosterTree.isSelectionEmpty()) {
                    DefaultMutableTreeNode n = (DefaultMutableTreeNode)WarriorGui.this.wRosterTree.getLastSelectedPathComponent();
                    dda = (DescriptorDisplayAdapter)n.getUserObject();
                }
                if (dda != null) {
                    Descriptor d = dda.getDescriptor();
                    if (dda.isChallengable()) {
                        WarriorGui.this.w.getRefusals().setRefusal(0, d.createDescriptorIdentifier());
                        WarriorGui.this.parentGui.playerDataChangedEvent(2);
                        WarriorGui.this.setChallengeFieldContents(WarriorGui.this.wSelectRefusal1Field, dda);
                    }
                }
            }
        });
        this.wSelectRefusal2B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DescriptorDisplayAdapter dda = null;
                String tabName = WarriorGui.this.wRankingRosterPane.getTitleAt(WarriorGui.this.wRankingRosterPane.getSelectedIndex());
                if (tabName.equals(RANKING_TAB_NAME)) {
                    if (!WarriorGui.this.wRankingList.isSelectionEmpty()) {
                        dda = (DescriptorDisplayAdapter)WarriorGui.this.wRankingList.getSelectedValue();
                    }
                } else if (tabName.equals(BLOOD_CHALLENGE_TAB_NAME)) {
                    if (!WarriorGui.this.bloodChallengeList.isSelectionEmpty()) {
                        dda = (DescriptorDisplayAdapter)WarriorGui.this.bloodChallengeList.getSelectedValue();
                    }
                } else if (tabName.equals(ARENA_TAB_NAME) && !WarriorGui.this.wRosterTree.isSelectionEmpty()) {
                    DefaultMutableTreeNode n = (DefaultMutableTreeNode)WarriorGui.this.wRosterTree.getLastSelectedPathComponent();
                    dda = (DescriptorDisplayAdapter)n.getUserObject();
                }
                if (dda != null) {
                    Descriptor d = dda.getDescriptor();
                    if (dda.isChallengable()) {
                        WarriorGui.this.w.getRefusals().setRefusal(1, d.createDescriptorIdentifier());
                        WarriorGui.this.parentGui.playerDataChangedEvent(2);
                        WarriorGui.this.setChallengeFieldContents(WarriorGui.this.wSelectRefusal2Field, dda);
                    }
                }
            }
        });
        this.wSelectRefusal3B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DescriptorDisplayAdapter dda = null;
                String tabName = WarriorGui.this.wRankingRosterPane.getTitleAt(WarriorGui.this.wRankingRosterPane.getSelectedIndex());
                if (tabName.equals(RANKING_TAB_NAME)) {
                    if (!WarriorGui.this.wRankingList.isSelectionEmpty()) {
                        dda = (DescriptorDisplayAdapter)WarriorGui.this.wRankingList.getSelectedValue();
                    }
                } else if (tabName.equals(BLOOD_CHALLENGE_TAB_NAME)) {
                    if (!WarriorGui.this.bloodChallengeList.isSelectionEmpty()) {
                        dda = (DescriptorDisplayAdapter)WarriorGui.this.bloodChallengeList.getSelectedValue();
                    }
                } else if (tabName.equals(ARENA_TAB_NAME) && !WarriorGui.this.wRosterTree.isSelectionEmpty()) {
                    DefaultMutableTreeNode n = (DefaultMutableTreeNode)WarriorGui.this.wRosterTree.getLastSelectedPathComponent();
                    dda = (DescriptorDisplayAdapter)n.getUserObject();
                }
                if (dda != null) {
                    Descriptor d = dda.getDescriptor();
                    if (dda.isChallengable()) {
                        WarriorGui.this.w.getRefusals().setRefusal(2, d.createDescriptorIdentifier());
                        WarriorGui.this.parentGui.playerDataChangedEvent(2);
                        WarriorGui.this.setChallengeFieldContents(WarriorGui.this.wSelectRefusal3Field, dda);
                    }
                }
            }
        });
        this.wClearChallenge1B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.w.getChallenges().setChallenge(0, DescriptorIdentifier.NONE);
                WarriorGui.this.parentGui.playerDataChangedEvent(2);
                WarriorGui.this.setChallengeFieldContents(WarriorGui.this.wSelectChallenge1Field, DescriptorDisplayAdapter.NONE);
            }
        });
        this.wClearChallenge2B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.w.getChallenges().setChallenge(1, DescriptorIdentifier.NONE);
                WarriorGui.this.parentGui.playerDataChangedEvent(2);
                WarriorGui.this.setChallengeFieldContents(WarriorGui.this.wSelectChallenge2Field, DescriptorDisplayAdapter.NONE);
            }
        });
        this.wClearChallenge3B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.w.getChallenges().setChallenge(2, DescriptorIdentifier.NONE);
                WarriorGui.this.parentGui.playerDataChangedEvent(2);
                WarriorGui.this.setChallengeFieldContents(WarriorGui.this.wSelectChallenge3Field, DescriptorDisplayAdapter.NONE);
            }
        });
        this.wClearRefusal1B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.w.getRefusals().setRefusal(0, DescriptorIdentifier.NONE);
                WarriorGui.this.parentGui.playerDataChangedEvent(2);
                WarriorGui.this.setChallengeFieldContents(WarriorGui.this.wSelectRefusal1Field, DescriptorDisplayAdapter.NONE);
            }
        });
        this.wClearRefusal2B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.w.getRefusals().setRefusal(1, DescriptorIdentifier.NONE);
                WarriorGui.this.parentGui.playerDataChangedEvent(2);
                WarriorGui.this.setChallengeFieldContents(WarriorGui.this.wSelectRefusal2Field, DescriptorDisplayAdapter.NONE);
            }
        });
        this.wClearRefusal3B.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.w.getRefusals().setRefusal(2, DescriptorIdentifier.NONE);
                WarriorGui.this.parentGui.playerDataChangedEvent(2);
                WarriorGui.this.setChallengeFieldContents(WarriorGui.this.wSelectRefusal3Field, DescriptorDisplayAdapter.NONE);
            }
        });
        this.wFightsText = new JEditorPane();
        this.wFightsText.setEditable(false);
        this.wFightsText.setBackground(Color.BLACK);
        this.wFightsText.setForeground(Color.WHITE);
        this.wFightsText.setFont(ClientGui.fixedWidthFont);
        JScrollPane wFightsScroll = new JScrollPane(this.wFightsText);
        wFightsScroll.setHorizontalScrollBarPolicy(31);
        MatteBorder wFightScrollBorder = BorderFactory.createMatteBorder(3, 5, 3, 3, Color.WHITE);
        wFightsScroll.setBorder(wFightScrollBorder);
        wFightsPane.add((Component)wFightsScroll, "Center");
        Box wFightsControls = Box.createHorizontalBox();
        Border wFightsControlsBorder = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        wFightsControls.setBorder(wFightsControlsBorder);
        wFightsPane.add((Component)wFightsControls, "North");
        this.wPrevFightB = new JButton("Prev Fight");
        this.wCurrentFightField = new BPDisplayField(15);
        this.wNextFightB = new JButton("Next Fight");
        this.wCurrentFightField.setHorizontalAlignment(0);
        wFightsControls.add(this.wPrevFightB);
        wFightsControls.add(Box.createHorizontalStrut(15));
        wFightsControls.add(this.wCurrentFightField);
        wFightsControls.add(Box.createHorizontalStrut(15));
        wFightsControls.add(this.wNextFightB);
        this.wPrevFightB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (WarriorGui.this.fightIndex > 0) {
                    WarriorGui.this.fightIndex--;
                    WarriorGui.this.attachFightPane();
                }
            }
        });
        this.wNextFightB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (WarriorGui.this.fightIndex < WarriorGui.this.fights.length - 1) {
                    WarriorGui.this.fightIndex++;
                    WarriorGui.this.attachFightPane();
                }
            }
        });
        JPanel replacementWarriorPanel = new JPanel();
        GridBagLayout replacementWarriorLayout = new GridBagLayout();
        replacementWarriorPanel.setLayout(replacementWarriorLayout);
        Border replacementWarriorInnerEmptyBorder = BorderFactory.createEmptyBorder(0, 10, 6, 10);
        Border replacementWarriorEtchedBorder = BorderFactory.createEtchedBorder();
        CompoundBorder replacementWarriorEtchedEmptyBorder = BorderFactory.createCompoundBorder(replacementWarriorEtchedBorder, replacementWarriorInnerEmptyBorder);
        TitledBorder replacementWarriorTitledBorder = BorderFactory.createTitledBorder(replacementWarriorEtchedEmptyBorder, "New Warrior");
        replacementWarriorPanel.setBorder(replacementWarriorTitledBorder);
        wReplacementPane.add((Component)replacementWarriorPanel, "replacement");
        JPanel replacementWarriorP1 = new JPanel(new BorderLayout());
        JPanel replacementWarriorP2 = new JPanel(new BorderLayout());
        JPanel replacementWarriorP3 = new JPanel();
        GridBagLayout replacementWarriorP3Layout = new GridBagLayout();
        replacementWarriorP3.setLayout(replacementWarriorP3Layout);
        GridBagConstraints replacementWarriorConst = new GridBagConstraints();
        replacementWarriorConst.fill = 1;
        replacementWarriorConst.weightx = 1.0;
        replacementWarriorConst.weighty = 1.0;
        replacementWarriorConst.gridwidth = 1;
        replacementWarriorConst.gridheight = 2;
        replacementWarriorLayout.setConstraints(replacementWarriorP1, replacementWarriorConst);
        replacementWarriorPanel.add(replacementWarriorP1);
        replacementWarriorConst.gridwidth = 0;
        replacementWarriorConst.gridheight = 1;
        replacementWarriorLayout.setConstraints(replacementWarriorP2, replacementWarriorConst);
        replacementWarriorPanel.add(replacementWarriorP2);
        replacementWarriorLayout.setConstraints(replacementWarriorP3, replacementWarriorConst);
        replacementWarriorPanel.add(replacementWarriorP3);
        JPanel replacementWarriorP1Labels = new JPanel(new GridLayout(0, 1));
        JPanel replacementWarriorP1Fields = new JPanel(new GridLayout(0, 1));
        JPanel replacementWarriorP1Buttons = new JPanel(new GridLayout(0, 2));
        Border replacementWarriorP1FieldsBorder = BorderFactory.createEmptyBorder(0, 4, 0, 10);
        Border replacementWarriorP1ButtonsBorder = BorderFactory.createEmptyBorder(0, 0, 0, 30);
        replacementWarriorP1Fields.setBorder(replacementWarriorP1FieldsBorder);
        replacementWarriorP1Buttons.setBorder(replacementWarriorP1ButtonsBorder);
        replacementWarriorP1.add((Component)replacementWarriorP1Labels, "West");
        replacementWarriorP1.add((Component)replacementWarriorP1Fields, "Center");
        replacementWarriorP1.add((Component)replacementWarriorP1Buttons, "East");
        JLabel rStrLabel = new JLabel("Strength");
        JLabel rDexLabel = new JLabel("Dexterity");
        JLabel rConLabel = new JLabel("Constitution");
        JLabel rIntLabel = new JLabel("Intelligence");
        JLabel rPreLabel = new JLabel("Presence");
        JLabel rSizLabel = new JLabel("Size");
        this.rStrField = new BPDisplayField(7);
        this.rDexField = new BPDisplayField(7);
        this.rConField = new BPDisplayField(7);
        this.rIntField = new BPDisplayField(7);
        this.rPreField = new BPDisplayField(7);
        this.rSizField = new BPDisplayField(7);
        JButton rStrDButton = new JButton("-");
        JButton rDexDButton = new JButton("-");
        JButton rConDButton = new JButton("-");
        JButton rIntDButton = new JButton("-");
        JButton rPreDButton = new JButton("-");
        JButton rSizDButton = new JButton("-");
        JButton rStrUButton = new JButton("+");
        JButton rDexUButton = new JButton("+");
        JButton rConUButton = new JButton("+");
        JButton rIntUButton = new JButton("+");
        JButton rPreUButton = new JButton("+");
        JButton rSizUButton = new JButton("+");
        Border replacementWarriorInnerBB = BorderFactory.createEmptyBorder(0, 3, 0, 3);
        Border replacementWarriorBevelBB = BorderFactory.createEtchedBorder();
        Border replacementWarriorOuterBB = BorderFactory.createEmptyBorder(2, 3, 2, 3);
        CompoundBorder replacementWarriorButtonBorder = BorderFactory.createCompoundBorder(replacementWarriorBevelBB, replacementWarriorInnerBB);
        replacementWarriorButtonBorder = BorderFactory.createCompoundBorder(replacementWarriorOuterBB, replacementWarriorButtonBorder);
        rStrDButton.setBorder(replacementWarriorButtonBorder);
        rDexDButton.setBorder(replacementWarriorButtonBorder);
        rConDButton.setBorder(replacementWarriorButtonBorder);
        rIntDButton.setBorder(replacementWarriorButtonBorder);
        rPreDButton.setBorder(replacementWarriorButtonBorder);
        rSizDButton.setBorder(replacementWarriorButtonBorder);
        rStrUButton.setBorder(replacementWarriorButtonBorder);
        rDexUButton.setBorder(replacementWarriorButtonBorder);
        rConUButton.setBorder(replacementWarriorButtonBorder);
        rIntUButton.setBorder(replacementWarriorButtonBorder);
        rPreUButton.setBorder(replacementWarriorButtonBorder);
        rSizUButton.setBorder(replacementWarriorButtonBorder);
        replacementWarriorP1Labels.add(rStrLabel);
        replacementWarriorP1Labels.add(rDexLabel);
        replacementWarriorP1Labels.add(rConLabel);
        replacementWarriorP1Labels.add(rIntLabel);
        replacementWarriorP1Labels.add(rPreLabel);
        replacementWarriorP1Labels.add(rSizLabel);
        replacementWarriorP1Fields.add(this.rStrField);
        replacementWarriorP1Fields.add(this.rDexField);
        replacementWarriorP1Fields.add(this.rConField);
        replacementWarriorP1Fields.add(this.rIntField);
        replacementWarriorP1Fields.add(this.rPreField);
        replacementWarriorP1Fields.add(this.rSizField);
        replacementWarriorP1Buttons.add(rStrDButton);
        replacementWarriorP1Buttons.add(rStrUButton);
        replacementWarriorP1Buttons.add(rDexDButton);
        replacementWarriorP1Buttons.add(rDexUButton);
        replacementWarriorP1Buttons.add(rConDButton);
        replacementWarriorP1Buttons.add(rConUButton);
        replacementWarriorP1Buttons.add(rIntDButton);
        replacementWarriorP1Buttons.add(rIntUButton);
        replacementWarriorP1Buttons.add(rPreDButton);
        replacementWarriorP1Buttons.add(rPreUButton);
        replacementWarriorP1Buttons.add(rSizDButton);
        replacementWarriorP1Buttons.add(rSizUButton);
        JPanel replacementWarriorP2Labels = new JPanel(new GridLayout(0, 1));
        JPanel replacementWarriorP2Fields = new JPanel(new GridLayout(0, 1));
        Border replacementWarriorP2LabelsBorder = BorderFactory.createEmptyBorder(0, 0, 0, 0);
        Border replacementWarriorP2FieldsBorder = BorderFactory.createEmptyBorder(0, 4, 0, 0);
        replacementWarriorP2Fields.setBorder(replacementWarriorP2FieldsBorder);
        replacementWarriorP2.add((Component)replacementWarriorP2Labels, "West");
        replacementWarriorP2.add((Component)replacementWarriorP2Fields, "Center");
        JLabel rNameLabel = new JLabel("Name");
        JLabel rRaceLabel = new JLabel("Race");
        JLabel rGenderLabel = new JLabel("Gender");
        this.rNameField = new BPTextField(25, 20);
        this.rRaceBox = new BPComboBox(RaceEnum.publicValues());
        this.rGenderBox = new BPComboBox(GenderEnum.values());
        replacementWarriorP2Labels.add(rNameLabel);
        replacementWarriorP2Labels.add(rRaceLabel);
        replacementWarriorP2Labels.add(rGenderLabel);
        replacementWarriorP2Fields.add(this.rNameField);
        replacementWarriorP2Fields.add(this.rRaceBox);
        replacementWarriorP2Fields.add(this.rGenderBox);
        Border replacementWarriorP3Border1 = BorderFactory.createEmptyBorder(6, 4, 4, 4);
        Border replacementWarriorP3Border2 = BorderFactory.createLineBorder(Color.black);
        Border replacementWarriorP3Border3 = BorderFactory.createEmptyBorder(8, 48, 0, 0);
        CompoundBorder replacementWarriorP3Border = BorderFactory.createCompoundBorder(replacementWarriorP3Border2, replacementWarriorP3Border1);
        replacementWarriorP3Border = BorderFactory.createCompoundBorder(replacementWarriorP3Border3, replacementWarriorP3Border);
        replacementWarriorP3.setBorder(replacementWarriorP3Border);
        JLabel rDistributeLabel = new JLabel("Points Left to Distribute");
        this.rDistributeField = new BPDisplayField(5);
        this.rResetButton = new JButton("Reset");
        this.rSaveButton = new JButton("Save");
        this.rDistributeField.setHorizontalAlignment(0);
        Border replacementWarriorP3Border4 = BorderFactory.createEmptyBorder(4, 6, 4, 6);
        Border replacementWarriorP3Border5 = BorderFactory.createRaisedBevelBorder();
        Border replacementWarriorP3Border6 = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        Border replacementWarriorP3Border7 = BorderFactory.createEmptyBorder(4, 9, 4, 9);
        Border replacementWarriorP3Border8 = BorderFactory.createRaisedBevelBorder();
        Border replacementWarriorP3Border9 = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        replacementWarriorConst.fill = 0;
        replacementWarriorConst.weightx = 1.0;
        replacementWarriorConst.weighty = 1.0;
        replacementWarriorConst.gridwidth = 0;
        replacementWarriorConst.gridheight = 1;
        replacementWarriorP3Layout.setConstraints(rDistributeLabel, replacementWarriorConst);
        replacementWarriorP3.add(rDistributeLabel);
        replacementWarriorP3Layout.setConstraints(this.rDistributeField, replacementWarriorConst);
        replacementWarriorP3.add(this.rDistributeField);
        replacementWarriorConst.gridwidth = -1;
        replacementWarriorP3Layout.setConstraints(this.rResetButton, replacementWarriorConst);
        replacementWarriorP3.add(this.rResetButton);
        replacementWarriorConst.gridwidth = 0;
        replacementWarriorP3Layout.setConstraints(this.rSaveButton, replacementWarriorConst);
        replacementWarriorP3.add(this.rSaveButton);
        this.rSaveButton.setEnabled(false);
        this.rStrField.setFont(ClientGui.f0b);
        this.rDexField.setFont(ClientGui.f0b);
        this.rConField.setFont(ClientGui.f0b);
        this.rIntField.setFont(ClientGui.f0b);
        this.rPreField.setFont(ClientGui.f0b);
        this.rSizField.setFont(ClientGui.f0b);
        this.rNameField.setFont(ClientGui.f0b);
        this.rDistributeField.setFont(ClientGui.f0b);
        wReplacementPaneLayout.addConstraint("replacement", AttributeType.TOP, new AttributeConstraint("_container", AttributeType.TOP, 0));
        wReplacementPaneLayout.addConstraint("replacement", AttributeType.LEFT, new AttributeConstraint("_container", AttributeType.LEFT, 0));
        wReplacementPaneLayout.addConstraint("replacement", AttributeType.WIDTH, new AttributeConstraint("_container", AttributeType.WIDTH, 0));
        rStrDButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (WarriorGui.this.replacement.decrementStr()) {
                    NewWarriorAdjustments r = WarriorGui.this.replacement;
                    WarriorGui.this.rStrField.setText(r.getStrAdd() == 0 ? r.getStr() + "" : r.getStr() + " (" + r.getBStr() + ")");
                    WarriorGui.this.replacementUpdatedEvent();
                }
            }
        });
        rStrUButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (WarriorGui.this.replacement.incrementStr()) {
                    NewWarriorAdjustments r = WarriorGui.this.replacement;
                    WarriorGui.this.rStrField.setText(r.getStrAdd() == 0 ? r.getStr() + "" : r.getStr() + " (" + r.getBStr() + ")");
                    WarriorGui.this.replacementUpdatedEvent();
                }
            }
        });
        rDexDButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (WarriorGui.this.replacement.decrementDex()) {
                    NewWarriorAdjustments r = WarriorGui.this.replacement;
                    WarriorGui.this.rDexField.setText(r.getDexAdd() == 0 ? r.getDex() + "" : r.getDex() + " (" + r.getBDex() + ")");
                    WarriorGui.this.replacementUpdatedEvent();
                }
            }
        });
        rDexUButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (WarriorGui.this.replacement.incrementDex()) {
                    NewWarriorAdjustments r = WarriorGui.this.replacement;
                    WarriorGui.this.rDexField.setText(r.getDexAdd() == 0 ? r.getDex() + "" : r.getDex() + " (" + r.getBDex() + ")");
                    WarriorGui.this.replacementUpdatedEvent();
                }
            }
        });
        rConDButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (WarriorGui.this.replacement.decrementCon()) {
                    NewWarriorAdjustments r = WarriorGui.this.replacement;
                    WarriorGui.this.rConField.setText(r.getConAdd() == 0 ? r.getCon() + "" : r.getCon() + " (" + r.getBCon() + ")");
                    WarriorGui.this.replacementUpdatedEvent();
                }
            }
        });
        rConUButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (WarriorGui.this.replacement.incrementCon()) {
                    NewWarriorAdjustments r = WarriorGui.this.replacement;
                    WarriorGui.this.rConField.setText(r.getConAdd() == 0 ? r.getCon() + "" : r.getCon() + " (" + r.getBCon() + ")");
                    WarriorGui.this.replacementUpdatedEvent();
                }
            }
        });
        rIntDButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (WarriorGui.this.replacement.decrementInt()) {
                    NewWarriorAdjustments r = WarriorGui.this.replacement;
                    WarriorGui.this.rIntField.setText(r.getIntAdd() == 0 ? r.getInt() + "" : r.getInt() + " (" + r.getBInt() + ")");
                    WarriorGui.this.replacementUpdatedEvent();
                }
            }
        });
        rIntUButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (WarriorGui.this.replacement.incrementInt()) {
                    NewWarriorAdjustments r = WarriorGui.this.replacement;
                    WarriorGui.this.rIntField.setText(r.getIntAdd() == 0 ? r.getInt() + "" : r.getInt() + " (" + r.getBInt() + ")");
                    WarriorGui.this.replacementUpdatedEvent();
                }
            }
        });
        rPreDButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (WarriorGui.this.replacement.decrementPre()) {
                    NewWarriorAdjustments r = WarriorGui.this.replacement;
                    WarriorGui.this.rPreField.setText(r.getPreAdd() == 0 ? r.getPre() + "" : r.getPre() + " (" + r.getBPre() + ")");
                    WarriorGui.this.replacementUpdatedEvent();
                }
            }
        });
        rPreUButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (WarriorGui.this.replacement.incrementPre()) {
                    NewWarriorAdjustments r = WarriorGui.this.replacement;
                    WarriorGui.this.rPreField.setText(r.getPreAdd() == 0 ? r.getPre() + "" : r.getPre() + " (" + r.getBPre() + ")");
                    WarriorGui.this.replacementUpdatedEvent();
                }
            }
        });
        rSizDButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (WarriorGui.this.replacement.decrementSiz()) {
                    NewWarriorAdjustments r = WarriorGui.this.replacement;
                    WarriorGui.this.rSizField.setText(r.getSizAdd() == 0 ? r.getSiz() + "" : r.getSiz() + " (" + r.getBSiz() + ")");
                    WarriorGui.this.replacementUpdatedEvent();
                }
            }
        });
        rSizUButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (WarriorGui.this.replacement.incrementSiz()) {
                    NewWarriorAdjustments r = WarriorGui.this.replacement;
                    WarriorGui.this.rSizField.setText(r.getSizAdd() == 0 ? r.getSiz() + "" : r.getSiz() + " (" + r.getBSiz() + ")");
                    WarriorGui.this.replacementUpdatedEvent();
                }
            }
        });
        this.rRaceBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.replacement.setRace((RaceEnum)WarriorGui.this.rRaceBox.getSelectedItem());
            }
        });
        this.rGenderBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.replacement.setGender((GenderEnum)WarriorGui.this.rGenderBox.getSelectedItem());
            }
        });
        this.rNameField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                WarriorGui.this.replacement.setName(WarriorGui.this.rNameField.getText());
                WarriorGui.this.replacementUpdatedEvent();
            }

            public void removeUpdate(DocumentEvent e) {
                WarriorGui.this.replacement.setName(WarriorGui.this.rNameField.getText());
                WarriorGui.this.replacementUpdatedEvent();
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.rResetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.replacementResetEvent();
            }
        });
        this.rSaveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WarriorGui.this.w.setFromWarriorReplacement(WarriorGui.this.replacement);
                WarriorGui.this.refresh();
                WarriorGui.this.parentGui.refreshClientDataEvent();
            }
        });
    }

    public DefaultMutableTreeNode createDDATree(ArenaDescriptor ad) {
        DescriptorDisplayAdapter rootAdapter = new DescriptorDisplayAdapter(ad);
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(rootAdapter);
        for (int i = 0; i < ad.getChildCount(); ++i) {
            ManagerDescriptor tempManager = (ManagerDescriptor)ad.getChild(i);
            DescriptorDisplayAdapter managerAdapter = new DescriptorDisplayAdapter(tempManager);
            DefaultMutableTreeNode managerNode = new DefaultMutableTreeNode(managerAdapter);
            rootNode.add(managerNode);
            for (int j = 0; j < tempManager.getChildCount(); ++j) {
                TeamDescriptor tempTeam = (TeamDescriptor)tempManager.getChild(j);
                DescriptorDisplayAdapter teamAdapter = new DescriptorDisplayAdapter(tempTeam);
                DefaultMutableTreeNode teamNode = new DefaultMutableTreeNode(teamAdapter);
                managerNode.add(teamNode);
                for (int k = 0; k < tempTeam.getChildCount(); ++k) {
                    WarriorDescriptor tempWarrior = (WarriorDescriptor)tempTeam.getChild(k);
                    DescriptorDisplayAdapter warriorAdapter = new DescriptorDisplayAdapter(tempWarrior);
                    DefaultMutableTreeNode warriorNode = new DefaultMutableTreeNode(warriorAdapter);
                    teamNode.add(warriorNode);
                }
            }
        }
        return rootNode;
    }

    public Vector createDDAList(Vector descriptors) {
        Vector<DescriptorDisplayAdapter> adapters = new Vector<DescriptorDisplayAdapter>();
        for (int i = 0; i < descriptors.size(); ++i) {
            DescriptorDisplayAdapter dda = new DescriptorDisplayAdapter((Descriptor)descriptors.get(i));
            if (!dda.isChallengable() && dda.getDescriptor() != this.w) continue;
            adapters.add(dda);
        }
        return adapters;
    }

    protected class DescriptorTreeCellRenderer
    extends DefaultTreeCellRenderer {
        protected DescriptorTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)value;
            DescriptorDisplayAdapter adapter = (DescriptorDisplayAdapter)n.getUserObject();
            this.setIcon(adapter.getIcon());
            this.setDisabledIcon(adapter.getIcon());
            this.setText(adapter.getDisplayString());
            if (!adapter.isChallengable()) {
                this.setForeground(MainGui.MEDIUM_GRAY);
            }
            if (adapter.getDescriptor() == WarriorGui.this.w) {
                this.setForeground(MainGui.MEDIUM_GRAY);
            }
            return this;
        }
    }

    protected class BCDescriptorListCellRenderer
    extends DefaultListCellRenderer {
        protected BCDescriptorListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            DescriptorDisplayAdapter adapter = (DescriptorDisplayAdapter)value;
            this.setIcon(adapter.getIcon());
            this.setDisabledIcon(adapter.getIcon());
            this.setText(adapter.getDisplayString());
            if (WarriorGui.this.bloodChallengeDescriptors != null) {
                for (int i = 0; i < WarriorGui.this.bloodChallengeDescriptors.size(); ++i) {
                    if (WarriorGui.this.bloodChallengeDescriptors.get(i) != adapter.getDescriptor()) continue;
                    this.setForeground(BLOOD_RED);
                }
            }
            return this;
        }
    }

    protected class DescriptorListCellRenderer
    extends DefaultListCellRenderer {
        protected DescriptorListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            DescriptorDisplayAdapter adapter = (DescriptorDisplayAdapter)value;
            this.setIcon(adapter.getIcon());
            this.setDisabledIcon(adapter.getIcon());
            this.setText(adapter.getDisplayString());
            if (!adapter.isChallengable()) {
                // empty if block
            }
            if (adapter.getDescriptor() == WarriorGui.this.w) {
                this.setBackground(MainGui.LIGHT_BROWN);
            }
            return this;
        }
    }
}

