/*
 * Decompiled with CFR 0.152.
 */
package client.data;

import client.data.TeamCOM;
import common.ManagerCore;
import common.NewTeamAdjustments;
import common.NewTeamBase;
import common.RunEnum;
import common.TurnNumber;
import java.util.Date;

public final class ManagerCOM
extends ManagerCore {
    protected Integer replaceableTeamNumber = null;
    protected boolean uploadNeeded = false;
    protected NewTeamAdjustments newTeamComplete = null;

    public ManagerCOM(int managerNumber, int forArenaNumber, String screenName, int wins, int losses, int kills, RunEnum runType, TurnNumber lastTurnRan, String password, Date lastUpload, Date lastDownload, Date lastModified, String emailAddress, NewTeamBase newTeamData) {
        super(managerNumber, forArenaNumber, screenName, wins, losses, kills, runType, lastTurnRan, password, lastUpload, lastDownload, lastModified, emailAddress, newTeamData);
    }

    public Integer getReplaceableTeamNumber() {
        return this.replaceableTeamNumber;
    }

    public boolean getUploadNeeded() {
        return this.uploadNeeded;
    }

    public NewTeamAdjustments getNewTeamComplete() {
        return this.newTeamComplete;
    }

    public void createTeamAsNew(NewTeamAdjustments nt) {
        nt.setBase(this.newTeamBase);
        if (nt.isCompleteAndValidTree()) {
            this.setNewTeamComplete(nt);
            this.setReplaceableTeamNumber(null);
            return;
        }
        throw new RuntimeException("Invalid New Team Data");
    }

    public void createTeamAsReplacement(TeamCOM team, NewTeamAdjustments nt) {
        nt.setBase(this.newTeamBase);
        if (nt.isCompleteAndValidTree()) {
            team.setFromTeamReplacement(nt);
            this.setNewTeamComplete(nt);
            this.setReplaceableTeamNumber(new Integer(team.getTeamNumber()));
            return;
        }
        throw new RuntimeException("Invalid Replacement Team Data");
    }

    public void setUploadNeeded(boolean flag) {
        this.uploadNeeded = flag;
    }

    public void setReplaceableTeamNumber(Integer replaceableTeamNumber) {
        this.replaceableTeamNumber = replaceableTeamNumber;
    }

    public void setNewTeamComplete(NewTeamAdjustments newTeamComplete) {
        this.newTeamComplete = newTeamComplete;
    }

    public Object clone() {
        ManagerCOM m = (ManagerCOM)super.clone();
        if (this.newTeamComplete != null) {
            m.newTeamComplete = (NewTeamAdjustments)this.newTeamComplete.clone();
        }
        return m;
    }

    public void localize() {
        super.localize();
        if (this.newTeamComplete != null) {
            this.newTeamComplete.localize();
        }
    }
}

