/*
 * Decompiled with CFR 0.152.
 */
package client.rmi;

import common.Constants;
import java.util.Properties;

public class RMIProperties
extends Properties
implements Constants {
    public static final String BP_REGISTRY_HOST = "BPRegistryHost";
    public static final String BP_REGISTRY_PORT = "BPRegistryPort";
    public static final String BP_SERVER_OBJECT = "BPServerObject";
    public static final String DEFAULT_BP_REGISTRY_HOST = "localhost";
    public static final String DEFAULT_BP_REGISTRY_PORT = "1099";
    public static final String DEFAULT_BP_SERVER_OBJECT = "BPDataServer";

    public RMIProperties() {
        this.setProperty(BP_REGISTRY_HOST, DEFAULT_BP_REGISTRY_HOST);
        this.setProperty(BP_REGISTRY_PORT, DEFAULT_BP_REGISTRY_PORT);
        this.setProperty(BP_SERVER_OBJECT, DEFAULT_BP_SERVER_OBJECT);
    }

    public String getRemoteInterfaceName() {
        return "//" + this.getBPRegistryHost() + ":" + this.getBPRegistryPort() + "/" + this.getBPServerObject();
    }

    public String getBPRegistryHost() {
        return this.getProperty(BP_REGISTRY_HOST, DEFAULT_BP_REGISTRY_HOST);
    }

    public int getBPRegistryPort() {
        return Integer.parseInt(this.getProperty(BP_REGISTRY_PORT, DEFAULT_BP_REGISTRY_PORT));
    }

    public String getBPServerObject() {
        return this.getProperty(BP_SERVER_OBJECT, DEFAULT_BP_SERVER_OBJECT);
    }

    public void setBPRegistryHost(String value) {
        this.setProperty(BP_REGISTRY_HOST, value);
    }

    public void setBPRegistryPort(int port) {
        this.setProperty(BP_REGISTRY_PORT, port + "");
    }

    public void setBPServerObject(String value) {
        this.setProperty(BP_SERVER_OBJECT, value);
    }
}

