/*
 * Decompiled with CFR 0.152.
 */
package client.rmi;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class RemoteTextFile
implements Serializable {
    private File destinationFilename;
    private byte[] zippedContents;

    public RemoteTextFile(File destinationFileName, File localFile) {
        this.destinationFilename = destinationFileName;
        this.readFile(localFile);
    }

    public void setDestinationFilename(File fileName) {
        this.destinationFilename = fileName;
    }

    public File getDestinationFile() {
        return this.destinationFilename;
    }

    public boolean destinationExists() {
        return this.destinationFilename.exists();
    }

    public void readFile(File localFile) {
        this.checkSecurityConstraints(localFile);
        CharArrayWriter charBuffer = new CharArrayWriter(2048);
        try {
            int c;
            BufferedReader inData = new BufferedReader(new FileReader(localFile));
            while ((c = inData.read()) != -1) {
                charBuffer.write(c);
            }
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Local file " + localFile.toString() + " not found");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setContents(charBuffer.toCharArray());
    }

    private void setContents(char[] contents) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
            ObjectOutputStream oos = new ObjectOutputStream(new GZIPOutputStream(baos));
            oos.writeObject(contents);
            oos.close();
            this.zippedContents = baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private char[] getContents() {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.zippedContents);
            ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(bais));
            char[] contents = (char[])ois.readObject();
            ois.close();
            return contents;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new char[0];
        }
    }

    public void writeFile() {
        File file = this.getDestinationFile();
        this.checkSecurityConstraints(file);
        File parentPath = file.getParentFile();
        if (parentPath != null && !parentPath.exists()) {
            parentPath.mkdirs();
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new CharArrayReader(this.getContents()));
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            while ((line = br.readLine()) != null) {
                pw.println(line);
            }
            br.close();
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void checkSecurityConstraints(File file) {
        String filenameStr = file.toString();
        if (filenameStr.indexOf("..") != -1) {
            throw new RuntimeException("File path " + filenameStr + " is not canonical");
        }
        if (file.isAbsolute()) {
            throw new RuntimeException("File path " + filenameStr + " is not relative");
        }
        if (file.getParent() == null) {
            throw new RuntimeException("File path " + filenameStr + " is not a sub-directory");
        }
    }

    public boolean equals(Object o) {
        if (o.getClass().isInstance(this)) {
            RemoteTextFile fib = (RemoteTextFile)o;
            if (this.destinationFilename.equals(fib.destinationFilename)) {
                return true;
            }
        }
        return false;
    }

    public int compareTo(Object o) {
        return this.destinationFilename.compareTo(((RemoteTextFile)o).destinationFilename);
    }

    public int hashCode() {
        return this.destinationFilename.hashCode();
    }

    public String toString() {
        return this.destinationFilename.toString();
    }
}

