/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.ArenaDescriptor;
import common.DescriptorCollectionVisitor;
import common.MatchupRankingComparator;
import common.TurnNumber;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;

public class ArenaCore
extends ArenaDescriptor {
    protected boolean eventEnabled;
    protected int maxEventEntries;
    protected boolean eventLock;
    protected DescriptorCollectionVisitor collectionVisitor = null;
    protected Vector managersByRanking = null;
    protected Vector teamsByRanking = null;
    protected Vector warriorsByRanking = null;

    public ArenaCore(int arenaNumber, String arenaName, TurnNumber turnNumber, boolean eventEnabled, int maxEventEntries, boolean eventLock) {
        super(arenaNumber, arenaName, turnNumber);
        this.eventEnabled = eventEnabled;
        this.maxEventEntries = maxEventEntries;
        this.eventLock = eventLock;
    }

    public boolean getEventEnabled() {
        return this.eventEnabled;
    }

    public int getMaxEventEntries() {
        return this.maxEventEntries;
    }

    public boolean getEventLock() {
        return this.eventLock;
    }

    public void resetCollections() {
        this.collectionVisitor = new DescriptorCollectionVisitor();
        this.acceptTree(this.collectionVisitor);
    }

    public Vector getManagerDescriptors() {
        if (this.collectionVisitor == null) {
            this.resetCollections();
        }
        return this.collectionVisitor.getManagers();
    }

    public Vector getTeamDescriptors() {
        if (this.collectionVisitor == null) {
            this.resetCollections();
        }
        return this.collectionVisitor.getTeams();
    }

    public Vector getWarriorDescriptors() {
        if (this.collectionVisitor == null) {
            this.resetCollections();
        }
        return this.collectionVisitor.getWarriors();
    }

    public void resetRankings() {
        this.managersByRanking = null;
        this.teamsByRanking = null;
        this.warriorsByRanking = null;
    }

    public Vector getManagersByRanking() {
        if (this.managersByRanking == null) {
            this.managersByRanking = (Vector)this.getManagerDescriptors().clone();
        }
        Collections.sort(this.managersByRanking, this.getManagerRankingComparator());
        return this.warriorsByRanking;
    }

    public Vector getTeamsByRanking() {
        if (this.teamsByRanking == null) {
            this.teamsByRanking = (Vector)this.getTeamDescriptors().clone();
        }
        Collections.sort(this.teamsByRanking, this.getTeamRankingComparator());
        return this.warriorsByRanking;
    }

    public Vector getWarriorsByRanking() {
        if (this.warriorsByRanking == null) {
            this.warriorsByRanking = (Vector)this.getWarriorDescriptors().clone();
        }
        Collections.sort(this.warriorsByRanking, this.getWarriorRankingComparator());
        return this.warriorsByRanking;
    }

    protected Comparator getManagerRankingComparator() {
        return new MatchupRankingComparator();
    }

    protected Comparator getTeamRankingComparator() {
        return new MatchupRankingComparator();
    }

    protected Comparator getWarriorRankingComparator() {
        return new MatchupRankingComparator();
    }

    public Object clone() {
        ArenaCore a = (ArenaCore)super.clone();
        a.collectionVisitor = null;
        a.managersByRanking = null;
        a.teamsByRanking = null;
        a.warriorsByRanking = null;
        return a;
    }
}

