/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.Vector;

public class ArmorEnum
implements Serializable,
Comparable {
    static final long serialVersionUID = 597709654994259759L;
    private static TreeMap VALUE2NAME = new TreeMap();
    private static HashMap NAME2VALUE = new HashMap();
    public static int MIN_VALUE = Integer.MAX_VALUE;
    public static int MAX_VALUE = Integer.MIN_VALUE;
    public static ArmorEnum NONE = new ArmorEnum(1, "None");
    public static ArmorEnum CLOTH = new ArmorEnum(2, "Cloth");
    public static ArmorEnum LEATHER = new ArmorEnum(3, "Leather");
    public static ArmorEnum CUIR_BOULLI = new ArmorEnum(4, "Cuir Boulli");
    public static ArmorEnum BRIGANDINE = new ArmorEnum(5, "Brigandine");
    public static ArmorEnum SCALE_MAIL = new ArmorEnum(6, "Scale Mail");
    public static ArmorEnum CHAIN_MAIL = new ArmorEnum(7, "Chain Mail");
    public static ArmorEnum HALF_PLATE = new ArmorEnum(8, "Half-Plate");
    public static ArmorEnum FULL_PLATE = new ArmorEnum(9, "Full-Plate");
    private Integer value;
    private String name;
    private String description;

    protected ArmorEnum(int value, String name) {
        this.value = new Integer(value);
        this.name = name;
        this.description = name;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    protected ArmorEnum(int value, String name, String description) {
        this.value = new Integer(value);
        this.name = name;
        this.description = description;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    public static boolean contains(String name) {
        return NAME2VALUE.containsKey(name);
    }

    public static boolean contains(int value) {
        return VALUE2NAME.containsKey(new Integer(value));
    }

    public static int valueOf(String name) {
        return ((ArmorEnum)NAME2VALUE.get(name)).value();
    }

    public static String nameOf(int value) {
        return ((ArmorEnum)VALUE2NAME.get(new Integer(value))).name();
    }

    public static ArmorEnum get(String name) {
        return (ArmorEnum)NAME2VALUE.get(name);
    }

    public static ArmorEnum get(int value) {
        return (ArmorEnum)VALUE2NAME.get(new Integer(value));
    }

    public int value() {
        return this.value;
    }

    public String name() {
        return this.name;
    }

    public int compareTo(Object o) {
        Integer anIntegerValue = ((ArmorEnum)o).value;
        return this.value.compareTo(anIntegerValue);
    }

    public static Vector values() {
        Vector<ArmorEnum> v = new Vector<ArmorEnum>(MAX_VALUE);
        for (int i = MIN_VALUE; i <= MAX_VALUE; ++i) {
            v.add(ArmorEnum.get(i));
        }
        return v;
    }

    public String toString() {
        return this.description;
    }

    public String toStringFull() {
        return super.toString() + " Name=" + this.name + " Value=" + this.value.toString();
    }
}

