/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Descriptor;
import common.GenerativeTreeVisitor;
import common.GenerativeVisitor;
import common.Localizeable;
import common.Orderable;
import common.OrderedCollection;
import common.PlainVisitor;
import java.io.Serializable;

public abstract class DataTreeNode
implements Orderable,
Localizeable,
Serializable,
Cloneable {
    protected DataTreeNode parent = null;
    protected OrderedCollection children = new OrderedCollection();

    protected DataTreeNode() {
    }

    public abstract String getName();

    public abstract int getId();

    public abstract int getParentId();

    public String toString() {
        return this.getName();
    }

    public DataTreeNode getParent() {
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public int getSlotNumber() {
        if (this.parent != null) {
            return this.parent.getSlotNumber(this);
        }
        return -1;
    }

    protected int getSlotNumber(DataTreeNode node) {
        return this.children.getIndex(node);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public void addChild(DataTreeNode newNode) {
        if (newNode.getParentId() != this.getId()) {
            throw new RuntimeException("Object-relational child constraint violated");
        }
        DataTreeNode existingNode = (DataTreeNode)this.children.add(newNode);
        if (existingNode != null) {
            existingNode.parent = null;
        }
        newNode.parent = this;
    }

    public DataTreeNode getChild(int slot) {
        return (DataTreeNode)this.children.get(slot);
    }

    public DataTreeNode getChildById(int id) {
        return (DataTreeNode)this.children.getElementById(new Integer(id));
    }

    public Object cloneTree() {
        DataTreeNode nodeClone = (DataTreeNode)this.clone();
        for (int i = 0; i < this.getChildCount(); ++i) {
            nodeClone.addChild((DataTreeNode)this.getChild(i).cloneTree());
        }
        return nodeClone;
    }

    public void localizeTree() {
        this.localize();
        for (int i = 0; i < this.getChildCount(); ++i) {
            DataTreeNode n = (DataTreeNode)this.children.get(i);
            n.localizeTree();
        }
    }

    public void acceptTree(PlainVisitor visitor) {
        this.accept(visitor);
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChild(i).acceptTree(visitor);
        }
    }

    public DataTreeNode acceptTree(GenerativeTreeVisitor visitor) {
        DataTreeNode result = this.accept(visitor);
        for (int i = 0; i < this.getChildCount(); ++i) {
            DataTreeNode childResult = this.getChild(i).acceptTree(visitor);
            result.addChild(childResult);
        }
        return result;
    }

    public void accept(PlainVisitor visitor) {
        visitor.visit(this);
    }

    public DataTreeNode accept(GenerativeTreeVisitor visitor) {
        return visitor.visit(this);
    }

    public Object accept(GenerativeVisitor visitor) {
        return visitor.visit(this);
    }

    public int compareTo(Object o) {
        DataTreeNode n = (DataTreeNode)o;
        return new Integer(this.getId()).compareTo(new Integer(n.getId()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o.getClass().isInstance(this)) {
            Descriptor d = (Descriptor)o;
            if (this.getId() == d.getId() && this.getParentId() == d.getParentId() && this.getName().equals(d.getName())) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        try {
            DataTreeNode nodeClone = (DataTreeNode)super.clone();
            nodeClone.parent = null;
            nodeClone.children = new OrderedCollection();
            return nodeClone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void localize() {
    }
}

