/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.ArenaDescriptor;
import common.Constants;
import common.DataTreeNode;
import common.DescriptorIdentifier;
import common.DescriptorTypeEnum;
import common.ManagerDescriptor;
import common.NullDescriptor;
import common.PlainVisitor;
import common.Rankable;
import common.TeamDescriptor;
import common.WarriorDescriptor;

public abstract class Descriptor
extends DataTreeNode
implements Rankable,
Constants {
    protected int number;
    protected int parentNumber;
    protected String name;
    protected int wins;
    protected int losses;
    protected int kills;
    protected int turnWins = 0;
    protected int turnLosses = 0;
    protected int turnKills = 0;
    protected double winPercent = 0.0;
    protected double killPercent = 0.0;
    protected double matchupRanking = 1.0E-4;
    protected double alternateRanking = 0.0;
    protected int rankingSequence = -1;

    public Descriptor(int number, int parentNumber, String name, int wins, int losses, int kills) {
        this.number = number;
        this.parentNumber = parentNumber;
        this.name = name;
        this.wins = wins;
        this.losses = losses;
        this.kills = kills;
    }

    public int getNumber() {
        return this.number;
    }

    public int getParentNumber() {
        return this.parentNumber;
    }

    public String getName() {
        return this.name;
    }

    public int getWins() {
        return this.wins;
    }

    public int getLosses() {
        return this.losses;
    }

    public int getKills() {
        return this.kills;
    }

    public int getTotalFights() {
        return this.getWins() + this.getLosses();
    }

    public void incrementWins(int count) {
        this.wins += count;
        this.turnWins += count;
        if (this.getParent() != null) {
            ((Descriptor)this.getParent()).incrementWins(count);
        }
    }

    public void incrementLosses(int count) {
        this.losses += count;
        this.turnLosses += count;
        if (this.getParent() != null) {
            ((Descriptor)this.getParent()).incrementLosses(count);
        }
    }

    public void incrementKills(int count) {
        this.kills += count;
        this.turnKills += count;
        if (this.getParent() != null) {
            ((Descriptor)this.getParent()).incrementKills(count);
        }
    }

    public int getCurrentWins() {
        int count = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            Descriptor d = (Descriptor)this.getChild(i);
            count += d.getCurrentWins();
        }
        return count;
    }

    public int getCurrentLosses() {
        int count = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            Descriptor d = (Descriptor)this.getChild(i);
            count += d.getCurrentLosses();
        }
        return count;
    }

    public int getCurrentKills() {
        int count = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            Descriptor d = (Descriptor)this.getChild(i);
            count += d.getCurrentKills();
        }
        return count;
    }

    public int getCurrentTotalFights() {
        int count = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            Descriptor d = (Descriptor)this.getChild(i);
            count += d.getCurrentWins() + d.getCurrentLosses();
        }
        return count;
    }

    public int getTurnWins() {
        return this.turnWins;
    }

    public int getTurnLosses() {
        return this.turnLosses;
    }

    public int getTurnKills() {
        return this.turnKills;
    }

    public int getTurnTotalFights() {
        return this.getTurnWins() + this.getTurnLosses();
    }

    public double getWinPercent() {
        return this.winPercent;
    }

    public double getKillPercent() {
        return this.killPercent;
    }

    public double getMatchupRanking() {
        return this.matchupRanking;
    }

    public double getAlternateRanking() {
        return this.alternateRanking;
    }

    public int getRankingSequence() {
        return this.rankingSequence;
    }

    public abstract boolean isActive();

    public abstract boolean isBuiltIn();

    public DescriptorIdentifier createDescriptorIdentifier() {
        DescriptorIdentifierVisitor div = new DescriptorIdentifierVisitor();
        this.accept(div);
        return div.getDescriptorIdentifier();
    }

    public Descriptor findDescriptor(DescriptorIdentifier descId) {
        DescriptorLocatorVisitor dlv = new DescriptorLocatorVisitor(descId);
        this.accept(dlv);
        return dlv.getTarget();
    }

    public DescriptorTypeEnum intersectionType(Descriptor descriptor) {
        DescriptorIdentifier di1 = this.createDescriptorIdentifier();
        DescriptorIdentifier di2 = descriptor.createDescriptorIdentifier();
        return di1.intersectionType(di2);
    }

    public void setWinPercent(double percent) {
        this.winPercent = percent;
    }

    public void setKillPercent(double percent) {
        this.killPercent = percent;
    }

    public void setMatchupRanking(double ranking) {
        this.matchupRanking = ranking;
    }

    public void setAlternateRanking(double ranking) {
        this.alternateRanking = ranking;
    }

    public void setRankingSequence(int sequence) {
        this.rankingSequence = sequence;
    }

    public int getId() {
        return this.getNumber();
    }

    public int getParentId() {
        return this.getParentNumber();
    }

    public String getNameNumberText() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(" (");
        sb.append(this.getNumber());
        sb.append(")");
        return sb.toString();
    }

    public String getRecordText() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getWins());
        sb.append("-");
        sb.append(this.getLosses());
        sb.append("-");
        sb.append(this.getKills());
        return sb.toString();
    }

    public String getNameRecordText() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(" (");
        sb.append(this.getRecordText());
        sb.append(")");
        return sb.toString();
    }

    public String getNameNumberRecordText() {
        StringBuffer sb = new StringBuffer(this.getNameNumberText());
        sb.append(" (");
        sb.append(this.getRecordText());
        sb.append(")");
        return sb.toString();
    }

    class DescriptorLocatorVisitor
    extends PlainVisitor {
        private DescriptorIdentifier descIdentifier;
        private Descriptor target = NullDescriptor.NONE;

        DescriptorLocatorVisitor(DescriptorIdentifier descId) {
            this.descIdentifier = descId;
        }

        DescriptorIdentifier getDescriptorIdentifier() {
            return this.descIdentifier;
        }

        Descriptor getTarget() {
            return this.target;
        }

        public void visit(ArenaDescriptor ad) {
            Descriptor nextDesc;
            if (this.descIdentifier.getType().value() == DescriptorTypeEnum.ARENA.value()) {
                this.target = ad;
                return;
            }
            if (this.descIdentifier.getType().value() > DescriptorTypeEnum.ARENA.value() && (nextDesc = (Descriptor)ad.getChildById(this.descIdentifier.getManagerId())) != null) {
                nextDesc.accept(this);
            }
        }

        public void visit(ManagerDescriptor md) {
            Descriptor nextDesc;
            if (this.descIdentifier.getType().value() == DescriptorTypeEnum.MANAGER.value()) {
                this.target = md;
                return;
            }
            if (this.descIdentifier.getType().value() > DescriptorTypeEnum.MANAGER.value() && (nextDesc = (Descriptor)md.getChildById(this.descIdentifier.getTeamId())) != null) {
                nextDesc.accept(this);
            }
        }

        public void visit(TeamDescriptor td) {
            Descriptor nextDesc;
            if (this.descIdentifier.getType().value() == DescriptorTypeEnum.TEAM.value()) {
                this.target = td;
                return;
            }
            if (this.descIdentifier.getType().value() > DescriptorTypeEnum.TEAM.value() && (nextDesc = (Descriptor)td.getChildById(this.descIdentifier.getWarriorId())) != null) {
                nextDesc.accept(this);
            }
        }

        public void visit(WarriorDescriptor wd) {
            if (this.descIdentifier.getType().value() == DescriptorTypeEnum.WARRIOR.value()) {
                this.target = wd;
                return;
            }
        }
    }

    class DescriptorIdentifierVisitor
    extends PlainVisitor {
        private DescriptorTypeEnum type = DescriptorTypeEnum.NONE;
        private int arenaId = 0;
        private int managerId = 0;
        private int teamId = 0;
        private int warriorId = 0;

        DescriptorIdentifierVisitor() {
        }

        DescriptorIdentifier getDescriptorIdentifier() {
            if (this.type == DescriptorTypeEnum.NONE) {
                return DescriptorIdentifier.NONE;
            }
            return new DescriptorIdentifier(this.type, this.managerId, this.teamId, this.warriorId);
        }

        public void visit(ArenaDescriptor ad) {
            this.initialDescriptor(DescriptorTypeEnum.ARENA);
            this.arenaId = ad.getId();
        }

        public void visit(ManagerDescriptor md) {
            this.initialDescriptor(DescriptorTypeEnum.MANAGER);
            this.managerId = md.getId();
            md.getParent().accept(this);
        }

        public void visit(TeamDescriptor td) {
            this.initialDescriptor(DescriptorTypeEnum.TEAM);
            this.teamId = td.getId();
            td.getParent().accept(this);
        }

        public void visit(WarriorDescriptor wd) {
            this.initialDescriptor(DescriptorTypeEnum.WARRIOR);
            this.warriorId = wd.getId();
            wd.getParent().accept(this);
        }

        private void initialDescriptor(DescriptorTypeEnum initialType) {
            if (initialType.value() > this.type.value()) {
                this.type = initialType;
            }
        }
    }
}

