/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Constants;
import common.DescriptorTypeEnum;
import common.Localizeable;
import java.io.Serializable;

public class DescriptorIdentifier
implements Constants,
Localizeable,
Serializable,
Cloneable {
    public static final DescriptorIdentifier NONE = new DescriptorIdentifier();
    public static final DescriptorIdentifier ARENA = new DescriptorIdentifier(DescriptorTypeEnum.ARENA, 0, 0, 0);
    protected DescriptorTypeEnum type = DescriptorTypeEnum.NONE;
    protected int managerId = 0;
    protected int teamId = 0;
    protected int warriorId = 0;

    public static DescriptorIdentifier create(DescriptorTypeEnum type, int managerId, int teamId, int warriorId) {
        if (type == DescriptorTypeEnum.NONE) {
            return NONE;
        }
        if (type == DescriptorTypeEnum.ARENA) {
            return ARENA;
        }
        return new DescriptorIdentifier(type, managerId, teamId, warriorId);
    }

    protected DescriptorIdentifier() {
    }

    protected DescriptorIdentifier(DescriptorTypeEnum type, int managerId, int teamId, int warriorId) {
        this.type = type;
        this.managerId = managerId;
        this.teamId = teamId;
        this.warriorId = warriorId;
        this.validate();
    }

    protected DescriptorIdentifier(DescriptorIdentifier identifier) {
        this.type = identifier.type;
        this.managerId = identifier.managerId;
        this.teamId = identifier.teamId;
        this.warriorId = identifier.warriorId;
        this.validate();
    }

    public DescriptorTypeEnum intersectionType(DescriptorIdentifier identifier) {
        if (this.warriorId != 0 && this.warriorId == identifier.warriorId) {
            return DescriptorTypeEnum.WARRIOR;
        }
        if (this.teamId != 0 && this.teamId == identifier.teamId) {
            return DescriptorTypeEnum.TEAM;
        }
        if (this.managerId != 0 && this.managerId == identifier.managerId) {
            return DescriptorTypeEnum.MANAGER;
        }
        if (this.type != DescriptorTypeEnum.NONE && identifier.type != DescriptorTypeEnum.NONE) {
            return DescriptorTypeEnum.ARENA;
        }
        return DescriptorTypeEnum.NONE;
    }

    public DescriptorTypeEnum getType() {
        return this.type;
    }

    public int getManagerId() {
        return this.managerId;
    }

    public int getTeamId() {
        return this.teamId;
    }

    public int getWarriorId() {
        return this.warriorId;
    }

    public String toString() {
        return super.toString() + " type=" + this.type.toString() + " managerId=" + this.managerId + " teamId=" + this.teamId + " warriorId=" + this.warriorId;
    }

    private void validate() {
        if (this.type.value() > 1 && this.managerId <= 0) {
            throw new RuntimeException("Invalid DescriptorType at manager level");
        }
        if (this.type.value() > 2 && this.teamId <= 0) {
            throw new RuntimeException("Invalid DescriptorType at team level");
        }
        if (this.type.value() > 3 && this.warriorId <= 0) {
            throw new RuntimeException("Invalid DescriptorType at warrior level");
        }
    }

    public boolean isBuiltIn() {
        return this.managerId == 1;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o.getClass().isInstance(this)) {
            DescriptorIdentifier di = (DescriptorIdentifier)o;
            if (this.type == di.type && this.managerId == di.managerId && this.teamId == di.teamId && this.warriorId == di.warriorId) {
                return true;
            }
        }
        return false;
    }

    public void localize() {
        this.type = DescriptorTypeEnum.get(this.type.value());
    }
}

