/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.Vector;

public class DescriptorTypeEnum
implements Serializable,
Comparable {
    private static TreeMap VALUE2NAME = new TreeMap();
    private static HashMap NAME2VALUE = new HashMap();
    public static int MIN_VALUE = Integer.MAX_VALUE;
    public static int MAX_VALUE = Integer.MIN_VALUE;
    public static DescriptorTypeEnum NONE = new DescriptorTypeEnum(0, "None");
    public static DescriptorTypeEnum ARENA = new DescriptorTypeEnum(1, "Arena");
    public static DescriptorTypeEnum MANAGER = new DescriptorTypeEnum(2, "Manager");
    public static DescriptorTypeEnum TEAM = new DescriptorTypeEnum(3, "Team");
    public static DescriptorTypeEnum WARRIOR = new DescriptorTypeEnum(4, "Warrior");
    private Integer value;
    private String name;
    private String description;

    protected DescriptorTypeEnum(int value, String name) {
        this.value = new Integer(value);
        this.name = name;
        this.description = name;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    protected DescriptorTypeEnum(int value, String name, String description) {
        this.value = new Integer(value);
        this.name = name;
        this.description = description;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    public static boolean contains(String name) {
        return NAME2VALUE.containsKey(name);
    }

    public static boolean contains(int value) {
        return VALUE2NAME.containsKey(new Integer(value));
    }

    public static int valueOf(String name) {
        return ((DescriptorTypeEnum)NAME2VALUE.get(name)).value();
    }

    public static String nameOf(int value) {
        return ((DescriptorTypeEnum)VALUE2NAME.get(new Integer(value))).name();
    }

    public static DescriptorTypeEnum get(String name) {
        return (DescriptorTypeEnum)NAME2VALUE.get(name);
    }

    public static DescriptorTypeEnum get(int value) {
        return (DescriptorTypeEnum)VALUE2NAME.get(new Integer(value));
    }

    public int value() {
        return this.value;
    }

    public String name() {
        return this.name;
    }

    public int compareTo(Object o) {
        Integer anIntegerValue = ((DescriptorTypeEnum)o).value;
        return this.value.compareTo(anIntegerValue);
    }

    public static Vector values() {
        Vector<DescriptorTypeEnum> v = new Vector<DescriptorTypeEnum>(MAX_VALUE);
        for (int i = MIN_VALUE; i <= MAX_VALUE; ++i) {
            DescriptorTypeEnum x = DescriptorTypeEnum.get(i);
            if (x == null) continue;
            v.add(x);
        }
        return v;
    }

    public String toString() {
        return this.description;
    }

    public String toStringFull() {
        return super.toString() + " Name=" + this.name + " Value=" + this.value.toString();
    }
}

