/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.ArenaDescriptor;
import common.Descriptor;
import common.FileNamingVisitor;
import common.ManagerDescriptor;
import common.PathNamingVisitor;
import common.TeamDescriptor;
import common.TextHelper;
import common.TurnNumber;
import common.WarriorDescriptor;

public class FileNamingSchema {
    protected static final int TURN_NUMBER_START = 8;
    protected static final int TURN_NUMBER_END = 12;
    protected static final int TURN_SERIES_START = 13;
    protected static final int TURN_SERIES_END = 14;
    public static final String RESULTS_DIR_FILTER = "[NTW][0-9]{3,6}";
    public static final String RESULTS_FILE_FILTER = "[NTW][0-9]{6}-[0-9]{4}-[0-9]\\.xml";
    public static final String NEWSLETTER_FILTER = "N[0-9]{6}-[0-9]{4}-[0-9]\\.xml";
    public static final String WARRIOR_FIGHT_FILTER = "W[0-9]{6}-[0-9]{4}-[0-9]\\.xml";
    public static final String TEAM_FIGHT_FILTER = "T[0-9]{6}-[0-9]{4}-[0-9]\\.xml";

    public static String getFullFilename(Descriptor descriptor) {
        FileNamingVisitor filenameVisitor = new FileNamingVisitor();
        descriptor.accept(filenameVisitor);
        return filenameVisitor.getFilename();
    }

    public static String getFullPathname(Descriptor descriptor) {
        PathNamingVisitor pathnameVisitor = new PathNamingVisitor();
        descriptor.accept(pathnameVisitor);
        return pathnameVisitor.getPathname();
    }

    public static String getFilenameFilter(WarriorDescriptor wd) {
        return "W" + TextHelper.pad(wd.getWarriorNumber(), 6) + "-[0-9]{4}-[0-9]\\.xml";
    }

    public static String getFilenameFilter(TeamDescriptor td) {
        return "T" + TextHelper.pad(td.getTeamNumber(), 6) + "-[0-9]{4}-[0-9]\\.xml";
    }

    public static String getNewsletterFilter(ArenaDescriptor ad) {
        return "N" + TextHelper.pad(ad.getArenaNumber(), 6) + "-[0-9]{4}-[0-9]\\.xml";
    }

    public static String getTurnNumberKey(String namingSchemaFilename) {
        if (namingSchemaFilename.length() > 12) {
            return namingSchemaFilename.substring(8, 12);
        }
        return "0000";
    }

    public static String getTurnAndSeriesKey(String namingSchemaFilename) {
        if (namingSchemaFilename.length() > 14) {
            return namingSchemaFilename.substring(8, 14);
        }
        return "0000-0";
    }

    public static String getDirectoryName(ArenaDescriptor arena) {
        return FileNamingSchema.getArenaDirectoryName(arena.getArenaNumber());
    }

    public static String getDirectoryName(ManagerDescriptor manager) {
        return FileNamingSchema.getManagerDirectoryName(manager.getManagerNumber());
    }

    public static String getDirectoryName(TeamDescriptor team) {
        return FileNamingSchema.getTeamDirectoryName(team.getTeamNumber());
    }

    public static String getFileName(ArenaDescriptor arena) {
        return FileNamingSchema.getNewsFileName(arena.getTurnNumber(), arena.getArenaNumber());
    }

    public static String getFileName(TurnNumber turnNumber, TeamDescriptor team) {
        return FileNamingSchema.getTeamFileName(turnNumber, team.getTeamNumber());
    }

    public static String getFileName(TurnNumber turnNumber, WarriorDescriptor warrior) {
        return FileNamingSchema.getWarriorFileName(turnNumber, warrior.getWarriorNumber());
    }

    public static String getArenaDirectoryName(int arenaNumber) {
        return "A" + TextHelper.pad(arenaNumber, 3) + "/";
    }

    public static String getManagerDirectoryName(int accountNumber) {
        return "M" + TextHelper.pad(accountNumber, 4) + "/";
    }

    public static String getTeamDirectoryName(int teamNumber) {
        return "T" + TextHelper.pad(teamNumber, 5) + "/";
    }

    public static String getNewsFileName(TurnNumber turnNumber, int arenaNumber) {
        return "N" + TextHelper.pad(arenaNumber, 6) + "-" + TextHelper.pad(turnNumber.getTurnSequence(), 4) + "-" + TextHelper.pad(turnNumber.getTurnSeries(), 1) + ".xml";
    }

    public static String getTeamFileName(TurnNumber turnNumber, int teamNumber) {
        return "T" + TextHelper.pad(teamNumber, 6) + "-" + TextHelper.pad(turnNumber.getTurnSequence(), 4) + "-" + TextHelper.pad(turnNumber.getTurnSeries(), 1) + ".xml";
    }

    public static String getWarriorFileName(TurnNumber turnNumber, int warriorNumber) {
        return "W" + TextHelper.pad(warriorNumber, 6) + "-" + TextHelper.pad(turnNumber.getTurnSequence(), 4) + "-" + TextHelper.pad(turnNumber.getTurnSeries(), 1) + ".xml";
    }
}

