/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.ArenaDescriptor;
import common.FileNamingSchema;
import common.ManagerDescriptor;
import common.PlainVisitor;
import common.TeamDescriptor;
import common.TurnNumber;
import common.WarriorDescriptor;

class FileNamingVisitor
extends PlainVisitor {
    private StringBuffer filename = new StringBuffer();
    private boolean warriorIndicator = false;
    private boolean teamIndicator = false;
    private TurnNumber turnNumber;

    FileNamingVisitor() {
    }

    public void visit(ArenaDescriptor ad) {
        this.turnNumber = ad.getTurnNumber();
        this.filename.append(FileNamingSchema.getDirectoryName(ad));
        if (!this.warriorIndicator && !this.teamIndicator) {
            this.filename.append(FileNamingSchema.getFileName(ad));
        }
    }

    public void visit(ManagerDescriptor md) {
        md.getParent().accept(this);
        this.filename.append(FileNamingSchema.getDirectoryName(md));
    }

    public void visit(TeamDescriptor td) {
        this.teamIndicator = true;
        td.getParent().accept(this);
        this.filename.append(FileNamingSchema.getDirectoryName(td));
        if (!this.warriorIndicator) {
            this.filename.append(FileNamingSchema.getFileName(this.turnNumber, td));
        }
    }

    public void visit(WarriorDescriptor wd) {
        this.warriorIndicator = true;
        wd.getParent().accept(this);
        this.filename.append(FileNamingSchema.getFileName(this.turnNumber, wd));
    }

    public String getFilename() {
        return this.filename.toString();
    }
}

