/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;

public class HitLocationEnum
implements Serializable,
Comparable {
    private static TreeMap VALUE2NAME = new TreeMap();
    private static HashMap NAME2VALUE = new HashMap();
    public static int MIN_VALUE = Integer.MAX_VALUE;
    public static int MAX_VALUE = Integer.MIN_VALUE;
    public static HitLocationEnum PRIMARY_ARM = new HitLocationEnum(1, "Primary Arm");
    public static HitLocationEnum SECONDARY_ARM = new HitLocationEnum(2, "Secondary Arm");
    public static HitLocationEnum HEAD = new HitLocationEnum(3, "Head");
    public static HitLocationEnum CHEST = new HitLocationEnum(4, "Chest");
    public static HitLocationEnum ABDOMEN = new HitLocationEnum(5, "Abdomen");
    public static HitLocationEnum PRIMARY_LEG = new HitLocationEnum(6, "Primary Leg");
    public static HitLocationEnum SECONDARY_LEG = new HitLocationEnum(7, "Secondary Leg");
    private Integer value;
    private String name;
    private String description;

    protected HitLocationEnum(int value, String name) {
        this.value = new Integer(value);
        this.name = name;
        this.description = name;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    protected HitLocationEnum(int value, String name, String description) {
        this.value = new Integer(value);
        this.name = name;
        this.description = description;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    public static boolean contains(String name) {
        return NAME2VALUE.containsKey(name);
    }

    public static boolean contains(int value) {
        return VALUE2NAME.containsKey(new Integer(value));
    }

    public static int valueOf(String name) {
        return ((HitLocationEnum)NAME2VALUE.get(name)).value();
    }

    public static String nameOf(int value) {
        return ((HitLocationEnum)VALUE2NAME.get(new Integer(value))).name();
    }

    public static HitLocationEnum get(String name) {
        return (HitLocationEnum)NAME2VALUE.get(name);
    }

    public static HitLocationEnum get(int value) {
        return (HitLocationEnum)VALUE2NAME.get(new Integer(value));
    }

    public int value() {
        return this.value;
    }

    public String name() {
        return this.name;
    }

    public int compareTo(Object o) {
        Integer anIntegerValue = ((HitLocationEnum)o).value;
        return this.value.compareTo(anIntegerValue);
    }

    public static Vector values() {
        Vector<HitLocationEnum> v = new Vector<HitLocationEnum>(MAX_VALUE);
        for (int i = MIN_VALUE; i <= MAX_VALUE; ++i) {
            HitLocationEnum x = HitLocationEnum.get(i);
            if (x == null) continue;
            v.add(x);
        }
        return v;
    }

    public static Iterator iterator() {
        return VALUE2NAME.values().iterator();
    }

    public static int size() {
        return VALUE2NAME.size();
    }

    public String toString() {
        return this.description;
    }

    public String toStringFull() {
        return super.toString() + " Name=" + this.name + " Value=" + this.value.toString();
    }
}

