/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Descriptor;
import common.RunEnum;
import common.TeamDescriptor;
import common.TurnNumber;

public class ManagerDescriptor
extends Descriptor {
    protected RunEnum runNextTurn;
    protected TurnNumber lastTurnRan;

    public ManagerDescriptor(int managerNumber, int forArenaNumber, String managerName, int wins, int losses, int kills, RunEnum runType, TurnNumber lastTurnRan) {
        super(managerNumber, forArenaNumber, managerName, wins, losses, kills);
        this.runNextTurn = runType;
        this.lastTurnRan = lastTurnRan;
    }

    public int getManagerNumber() {
        return this.number;
    }

    public int getForArenaNumber() {
        return this.parentNumber;
    }

    public String getManagerName() {
        return this.name;
    }

    public RunEnum getRunNextTurn() {
        return this.runNextTurn;
    }

    public TurnNumber getLastTurnRan() {
        return this.lastTurnRan;
    }

    public void setRunNextTurn(RunEnum runType) {
        this.runNextTurn = runType;
    }

    public boolean validateRunStatus() {
        if (this.isActive()) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                if (((TeamDescriptor)this.getChild(i)).validateRunStatus()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean validateTeamFights() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (((TeamDescriptor)this.getChild(i)).getTeamFightSize() != 1) continue;
            return false;
        }
        return true;
    }

    public int getEventEntryCount() {
        int total = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            total += ((TeamDescriptor)this.getChild(i)).getEventEntryCount();
        }
        return total;
    }

    public boolean isActive() {
        return this.runNextTurn != RunEnum.NO;
    }

    public boolean isBuiltIn() {
        return this.number == 1;
    }

    public void localize() {
        super.localize();
        this.runNextTurn = RunEnum.get(this.runNextTurn.value());
    }
}

