/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Constants;
import common.Localizeable;
import common.NewTeamBase;
import common.NewWarriorAdjustments;
import common.NewWarriorBase;
import java.io.Serializable;
import java.util.Vector;

public class NewTeamAdjustments
implements Localizeable,
Constants,
Serializable,
Cloneable {
    protected NewTeamBase base;
    protected String teamName = "";
    protected Vector warriors;

    public NewTeamAdjustments(NewTeamBase base) {
        this.base = base;
        this.warriors = new Vector();
        for (int i = 0; i < base.getWarriorCount(); ++i) {
            NewWarriorBase warrior = base.getNewWarrior(i);
            this.warriors.add(new NewWarriorAdjustments(warrior));
        }
    }

    public String getName() {
        return this.teamName;
    }

    public NewTeamBase getBase() {
        return this.base;
    }

    public NewWarriorAdjustments getNewWarrior(int slotNumber) {
        return (NewWarriorAdjustments)this.warriors.get(slotNumber);
    }

    public int getWarriorCount() {
        return this.warriors.size();
    }

    public void setNewWarrior(int slotNumber, NewWarriorAdjustments newWarrior) {
        if (slotNumber >= this.base.getWarriorCount()) {
            throw new RuntimeException("Attempted to add too many newWarriors to newTeam");
        }
        this.warriors.set(slotNumber, newWarrior);
    }

    public void setName(String teamName) {
        this.teamName = teamName;
    }

    public void setBase(NewTeamBase base) {
        if (base.getWarriorCount() == this.getWarriorCount()) {
            this.base = base;
            for (int i = 0; i < this.getWarriorCount(); ++i) {
                this.getNewWarrior(i).setBase(base.getNewWarrior(i));
            }
        } else {
            throw new RuntimeException("Attempted to set NewTeamBase with different number of warriors");
        }
    }

    public boolean isCompleteAndValidTree() {
        if (this.teamName.length() > 0 && this.getWarriorCount() == 5 && this.base.getWarriorCount() == 5) {
            for (int i = 0; i < this.warriors.size(); ++i) {
                if (this.getNewWarrior(i).isCompleteAndValidTree()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void reset() {
        this.teamName = "";
    }

    public void resetTree() {
        this.reset();
        for (int i = 0; i < this.warriors.size(); ++i) {
            this.getNewWarrior(i).reset();
        }
    }

    public Object clone() {
        try {
            NewTeamAdjustments newTeamAdjustments = (NewTeamAdjustments)super.clone();
            newTeamAdjustments.warriors = (Vector)this.warriors.clone();
            for (int i = 0; i < this.warriors.size(); ++i) {
                Object newWarrior = ((NewWarriorAdjustments)this.warriors.get(i)).clone();
                newTeamAdjustments.warriors.set(i, newWarrior);
            }
            return newTeamAdjustments;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o.getClass().isInstance(this)) {
            NewTeamAdjustments nta = (NewTeamAdjustments)o;
            if (this.teamName.equals(nta.teamName)) {
                for (int i = 0; i < this.warriors.size(); ++i) {
                    if (!this.getNewWarrior(i).equals(nta.getNewWarrior(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public void localize() {
        for (int i = 0; i < this.warriors.size(); ++i) {
            ((NewWarriorAdjustments)this.warriors.get(i)).localize();
        }
    }
}

