/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Constants;
import common.Localizeable;
import common.NewWarriorBase;
import java.io.Serializable;
import java.util.Vector;

public class NewTeamBase
implements Localizeable,
Constants,
Serializable,
Cloneable {
    protected Vector warriors;

    public NewTeamBase(Vector warriorData) {
        if (warriorData.size() != 5) {
            throw new RuntimeException("Invalid warrior count");
        }
        this.warriors = warriorData;
    }

    public String toString() {
        return "NewTeamBase";
    }

    public int getWarriorCount() {
        return this.warriors.size();
    }

    public NewWarriorBase getNewWarrior(int slotNumber) {
        return (NewWarriorBase)this.warriors.get(slotNumber);
    }

    public void setNewWarrior(int slotNumber, NewWarriorBase w) {
        if (slotNumber >= 5) {
            throw new RuntimeException("Attempted to add too many newWarriors");
        }
        this.warriors.set(slotNumber, w);
    }

    public Object clone() {
        try {
            NewTeamBase newTeamClone = (NewTeamBase)super.clone();
            newTeamClone.warriors = (Vector)this.warriors.clone();
            for (int i = 0; i < this.warriors.size(); ++i) {
                Object newWarrior = ((NewWarriorBase)this.warriors.get(i)).clone();
                newTeamClone.warriors.set(i, newWarrior);
            }
            return newTeamClone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o.getClass().isInstance(this)) {
            NewTeamBase nt = (NewTeamBase)o;
            for (int i = 0; i < this.warriors.size(); ++i) {
                if (this.getNewWarrior(i).equals(nt.getNewWarrior(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void localize() {
        for (int i = 0; i < this.warriors.size(); ++i) {
            ((NewWarriorBase)this.warriors.get(i)).localize();
        }
    }
}

