/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Constants;
import common.GenderEnum;
import common.Localizeable;
import common.NewWarriorBase;
import common.RaceEnum;
import common.WarriorStats;
import java.io.Serializable;

public class NewWarriorAdjustments
implements WarriorStats,
Localizeable,
Constants,
Serializable,
Cloneable {
    protected NewWarriorBase base;
    protected String warriorName = "";
    protected RaceEnum race = RaceEnum.HUMAN;
    protected GenderEnum gender = GenderEnum.MALE;
    protected int strengthAdd;
    protected int dexterityAdd;
    protected int constitutionAdd;
    protected int intelligenceAdd;
    protected int presenceAdd;
    protected int sizeAdd;

    public NewWarriorAdjustments(NewWarriorBase base) {
        this.base = base;
    }

    public String toString() {
        return "NewWarriorAdjustments: " + this.getName();
    }

    public NewWarriorBase getBase() {
        return this.base;
    }

    public String getName() {
        return this.warriorName;
    }

    public RaceEnum getRace() {
        return this.race;
    }

    public GenderEnum getGender() {
        return this.gender;
    }

    public int getStr() {
        return this.base.getBStr() + this.strengthAdd;
    }

    public int getDex() {
        return this.base.getBDex() + this.dexterityAdd;
    }

    public int getCon() {
        return this.base.getBCon() + this.constitutionAdd;
    }

    public int getInt() {
        return this.base.getBInt() + this.intelligenceAdd;
    }

    public int getPre() {
        return this.base.getBPre() + this.presenceAdd;
    }

    public int getSiz() {
        return this.base.getBSiz() + this.sizeAdd;
    }

    public int getBStr() {
        return this.base.getBStr();
    }

    public int getBDex() {
        return this.base.getBDex();
    }

    public int getBCon() {
        return this.base.getBCon();
    }

    public int getBInt() {
        return this.base.getBInt();
    }

    public int getBPre() {
        return this.base.getBPre();
    }

    public int getBSiz() {
        return this.base.getBSiz();
    }

    public int getStrAdd() {
        return this.strengthAdd;
    }

    public int getDexAdd() {
        return this.dexterityAdd;
    }

    public int getConAdd() {
        return this.constitutionAdd;
    }

    public int getIntAdd() {
        return this.intelligenceAdd;
    }

    public int getPreAdd() {
        return this.presenceAdd;
    }

    public int getSizAdd() {
        return this.sizeAdd;
    }

    public int getAddPointTotal() {
        return this.strengthAdd + this.dexterityAdd + this.constitutionAdd + this.intelligenceAdd + this.presenceAdd + this.sizeAdd;
    }

    public int getFinalPointTotal() {
        return this.getStr() + this.getDex() + this.getCon() + this.getInt() + this.getPre() + this.getSiz();
    }

    public int getPointsLeftToDistribute() {
        return 71 - this.getFinalPointTotal();
    }

    public void setBase(NewWarriorBase base) {
        this.base = base;
    }

    public void setName(String name) {
        this.warriorName = name;
    }

    public void setRace(RaceEnum race) {
        this.race = race;
    }

    public void setGender(GenderEnum gender) {
        this.gender = gender;
    }

    public void setStrengthAdd(int strengthAdd) {
        this.strengthAdd = strengthAdd;
    }

    public void setDexterityAdd(int dexterityAdd) {
        this.dexterityAdd = dexterityAdd;
    }

    public void setConstitutionAdd(int constitutionAdd) {
        this.constitutionAdd = constitutionAdd;
    }

    public void setIntelligenceAdd(int intelligenceAdd) {
        this.intelligenceAdd = intelligenceAdd;
    }

    public void setPresenceAdd(int presenceAdd) {
        this.presenceAdd = presenceAdd;
    }

    public void setSizeAdd(int sizeAdd) {
        this.sizeAdd = sizeAdd;
    }

    public boolean incrementStr() {
        if (this.incrementStatRules(this.getStr(), this.strengthAdd)) {
            ++this.strengthAdd;
            return true;
        }
        return false;
    }

    public boolean incrementDex() {
        if (this.incrementStatRules(this.getDex(), this.dexterityAdd)) {
            ++this.dexterityAdd;
            return true;
        }
        return false;
    }

    public boolean incrementCon() {
        if (this.incrementStatRules(this.getCon(), this.constitutionAdd)) {
            ++this.constitutionAdd;
            return true;
        }
        return false;
    }

    public boolean incrementInt() {
        if (this.incrementStatRules(this.getInt(), this.intelligenceAdd)) {
            ++this.intelligenceAdd;
            return true;
        }
        return false;
    }

    public boolean incrementPre() {
        if (this.incrementStatRules(this.getPre(), this.presenceAdd)) {
            ++this.presenceAdd;
            return true;
        }
        return false;
    }

    public boolean incrementSiz() {
        if (this.incrementStatRules(this.getSiz(), this.sizeAdd)) {
            ++this.sizeAdd;
            return true;
        }
        return false;
    }

    public boolean decrementStr() {
        if (this.decrementStatRules(this.getStr(), this.strengthAdd)) {
            --this.strengthAdd;
            return true;
        }
        return false;
    }

    public boolean decrementDex() {
        if (this.decrementStatRules(this.getDex(), this.dexterityAdd)) {
            --this.dexterityAdd;
            return true;
        }
        return false;
    }

    public boolean decrementCon() {
        if (this.decrementStatRules(this.getCon(), this.constitutionAdd)) {
            --this.constitutionAdd;
            return true;
        }
        return false;
    }

    public boolean decrementInt() {
        if (this.decrementStatRules(this.getInt(), this.intelligenceAdd)) {
            --this.intelligenceAdd;
            return true;
        }
        return false;
    }

    public boolean decrementPre() {
        if (this.decrementStatRules(this.getPre(), this.presenceAdd)) {
            --this.presenceAdd;
            return true;
        }
        return false;
    }

    public boolean decrementSiz() {
        if (this.decrementStatRules(this.getSiz(), this.sizeAdd)) {
            --this.sizeAdd;
            return true;
        }
        return false;
    }

    public boolean isCompleteAndValidTree() {
        if (this.base.getBasePointTotal() != 55) {
            return false;
        }
        if (this.getAddPointTotal() != 16) {
            return false;
        }
        if (this.getFinalPointTotal() != 71) {
            return false;
        }
        if (this.getStr() > 25 || this.getStr() < 3) {
            return false;
        }
        if (this.getDex() > 25 || this.getDex() < 3) {
            return false;
        }
        if (this.getCon() > 25 || this.getCon() < 3) {
            return false;
        }
        if (this.getInt() > 25 || this.getInt() < 3) {
            return false;
        }
        if (this.getPre() > 25 || this.getPre() < 3) {
            return false;
        }
        if (this.getSiz() > 25 || this.getSiz() < 3) {
            return false;
        }
        if (this.strengthAdd < 0 || this.strengthAdd > 7) {
            return false;
        }
        if (this.dexterityAdd < 0 || this.dexterityAdd > 7) {
            return false;
        }
        if (this.constitutionAdd < 0 || this.constitutionAdd > 7) {
            return false;
        }
        if (this.intelligenceAdd < 0 || this.intelligenceAdd > 7) {
            return false;
        }
        if (this.presenceAdd < 0 || this.presenceAdd > 7) {
            return false;
        }
        if (this.sizeAdd < 0 || this.sizeAdd > 7) {
            return false;
        }
        if (this.warriorName.length() == 0) {
            return false;
        }
        return RaceEnum.publicValues().contains(this.race);
    }

    public void reset() {
        this.strengthAdd = 0;
        this.dexterityAdd = 0;
        this.constitutionAdd = 0;
        this.intelligenceAdd = 0;
        this.presenceAdd = 0;
        this.sizeAdd = 0;
    }

    private boolean incrementStatRules(int currentTotal, int currentAdd) {
        if (this.getFinalPointTotal() >= 71) {
            return false;
        }
        if (currentTotal >= 25) {
            return false;
        }
        return currentAdd < 7;
    }

    private boolean decrementStatRules(int currentTotal, int currentAdd) {
        if (this.getFinalPointTotal() <= 55) {
            return false;
        }
        if (currentTotal <= 3) {
            return false;
        }
        return currentAdd > 0;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o.getClass().isInstance(this)) {
            NewWarriorAdjustments w = (NewWarriorAdjustments)o;
            if (this.warriorName == w.warriorName && this.race == w.race && this.gender == w.gender && this.strengthAdd == w.strengthAdd && this.dexterityAdd == w.dexterityAdd && this.constitutionAdd == w.constitutionAdd && this.intelligenceAdd == w.intelligenceAdd && this.presenceAdd == w.presenceAdd && this.sizeAdd == w.sizeAdd) {
                return true;
            }
        }
        return false;
    }

    public void localize() {
        this.race = RaceEnum.get(this.race.value());
        this.gender = GenderEnum.get(this.gender.value());
    }
}

