/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Orderable;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;

public class OrderedCollection
implements Serializable {
    protected Vector elementList = new Vector();
    protected HashMap elementMap = new HashMap();

    public Orderable add(Orderable element) {
        Integer elementId = new Integer(element.getId());
        int insertionPoint = -1;
        Orderable existingElement = this.getElementById(elementId);
        if (existingElement == null) {
            insertionPoint = Collections.binarySearch(this.elementList, element);
            if (insertionPoint >= 0) {
                throw new RuntimeException("Corrupt element list detected inserting ID " + elementId);
            }
            insertionPoint = Math.abs(insertionPoint + 1);
            this.elementList.insertElementAt(element, insertionPoint);
            Orderable alwaysNull = this.elementMap.put(elementId, element);
            if (alwaysNull != null) {
                throw new RuntimeException("Corrupt element map detected inserting ID " + elementId);
            }
        } else {
            int existingElementIndex = this.getIndex(element);
            if (existingElementIndex < 0) {
                throw new RuntimeException("Corrupt element list detected replacing ID " + elementId);
            }
            this.elementList.set(existingElementIndex, element);
            Orderable notNull = this.elementMap.put(elementId, element);
            if (notNull == null) {
                throw new RuntimeException("Corrupt element map detected replacing ID " + elementId);
            }
        }
        return existingElement;
    }

    public Orderable get(int index) {
        return (Orderable)this.elementList.get(index);
    }

    public Orderable getElement(int index) {
        return (Orderable)this.elementList.get(index);
    }

    public Orderable getElementById(Integer elementId) {
        return (Orderable)this.elementMap.get(elementId);
    }

    public int getIndex(Orderable element) {
        int index = Collections.binarySearch(this.elementList, element);
        if (index >= 0) {
            return index;
        }
        return -1;
    }

    public int size() {
        return this.elementList.size();
    }
}

