/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.Vector;

public class PermLevelEnum
implements Serializable,
Comparable {
    private static TreeMap VALUE2NAME = new TreeMap();
    private static HashMap NAME2VALUE = new HashMap();
    public static int MIN_VALUE = Integer.MAX_VALUE;
    public static int MAX_VALUE = Integer.MIN_VALUE;
    public static PermLevelEnum NONE = new PermLevelEnum(0, "Has no");
    public static PermLevelEnum ANNOYING = new PermLevelEnum(1, "Has an annoying");
    public static PermLevelEnum BOTHERSOME = new PermLevelEnum(2, "Has a bothersome");
    public static PermLevelEnum IRRITATING = new PermLevelEnum(3, "Has an irritating");
    public static PermLevelEnum TROUBLESOME = new PermLevelEnum(4, "Has a troublesome");
    public static PermLevelEnum PAINFUL = new PermLevelEnum(5, "Has a painful");
    public static PermLevelEnum DREADFUL = new PermLevelEnum(6, "Has a dreadful");
    public static PermLevelEnum DEVASTATING = new PermLevelEnum(7, "Has a devastating");
    public static PermLevelEnum INCAPACITATING = new PermLevelEnum(8, "Has an incapacitating");
    public static PermLevelEnum FATAL = new PermLevelEnum(9, "Has a fatal");
    private Integer value;
    private String name;
    private String description;

    protected PermLevelEnum(int value, String name) {
        this.value = new Integer(value);
        this.name = name;
        this.description = name;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    protected PermLevelEnum(int value, String name, String description) {
        this.value = new Integer(value);
        this.name = name;
        this.description = description;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    public static boolean contains(String name) {
        return NAME2VALUE.containsKey(name);
    }

    public static boolean contains(int value) {
        return VALUE2NAME.containsKey(new Integer(value));
    }

    public static int valueOf(String name) {
        return ((PermLevelEnum)NAME2VALUE.get(name)).value();
    }

    public static String nameOf(int value) {
        return ((PermLevelEnum)VALUE2NAME.get(new Integer(value))).name();
    }

    public static PermLevelEnum get(String name) {
        return (PermLevelEnum)NAME2VALUE.get(name);
    }

    public static PermLevelEnum get(int value) {
        return (PermLevelEnum)VALUE2NAME.get(new Integer(value));
    }

    public int value() {
        return this.value;
    }

    public String name() {
        return this.name;
    }

    public int compareTo(Object o) {
        Integer anIntegerValue = ((PermLevelEnum)o).value;
        return this.value.compareTo(anIntegerValue);
    }

    public static Vector values() {
        Vector<PermLevelEnum> v = new Vector<PermLevelEnum>(MAX_VALUE);
        for (int i = MIN_VALUE; i <= MAX_VALUE; ++i) {
            v.add(PermLevelEnum.get(i));
        }
        return v;
    }

    public String toString() {
        return this.description;
    }

    public String toStringFull() {
        return super.toString() + " Name=" + this.name + " Value=" + this.value.toString();
    }
}

