/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.Vector;

public class RaceEnum
implements Serializable,
Comparable {
    private static TreeMap VALUE2NAME = new TreeMap();
    private static HashMap NAME2VALUE = new HashMap();
    public static int MIN_VALUE = Integer.MAX_VALUE;
    public static int MAX_VALUE = Integer.MIN_VALUE;
    public static RaceEnum HUMAN = new RaceEnum(1, "Human");
    public static RaceEnum DWARF = new RaceEnum(2, "Dwarf");
    public static RaceEnum HALF_ORC = new RaceEnum(3, "Half-Orc");
    public static RaceEnum HALFLING = new RaceEnum(4, "Halfling");
    public static RaceEnum HALF_ELF = new RaceEnum(5, "Half-Elf");
    public static RaceEnum ELF = new RaceEnum(6, "Elf");
    public static RaceEnum MONSTER = new RaceEnum(7, "Monster");
    public static RaceEnum PEASANT = new RaceEnum(8, "Peasant");
    private Integer value;
    private String name;
    private String description;

    protected RaceEnum(int value, String name) {
        this.value = new Integer(value);
        this.name = name;
        this.description = name;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    protected RaceEnum(int value, String name, String description) {
        this.value = new Integer(value);
        this.name = name;
        this.description = description;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    public static boolean contains(String name) {
        return NAME2VALUE.containsKey(name);
    }

    public static boolean contains(int value) {
        return VALUE2NAME.containsKey(new Integer(value));
    }

    public static int valueOf(String name) {
        return ((RaceEnum)NAME2VALUE.get(name)).value();
    }

    public static String nameOf(int value) {
        return ((RaceEnum)VALUE2NAME.get(new Integer(value))).name();
    }

    public static RaceEnum get(String name) {
        return (RaceEnum)NAME2VALUE.get(name);
    }

    public static RaceEnum get(int value) {
        return (RaceEnum)VALUE2NAME.get(new Integer(value));
    }

    public int value() {
        return this.value;
    }

    public String name() {
        return this.name;
    }

    public int compareTo(Object o) {
        Integer anIntegerValue = ((RaceEnum)o).value;
        return this.value.compareTo(anIntegerValue);
    }

    public static Vector values() {
        Vector<RaceEnum> v = new Vector<RaceEnum>(MAX_VALUE);
        for (int i = MIN_VALUE; i <= MAX_VALUE; ++i) {
            v.add(RaceEnum.get(i));
        }
        return v;
    }

    public static Vector publicValues() {
        Vector<RaceEnum> v = new Vector<RaceEnum>(MAX_VALUE);
        for (int i = MIN_VALUE; i <= MAX_VALUE; ++i) {
            RaceEnum r = RaceEnum.get(i);
            if (r == MONSTER || r == PEASANT) continue;
            v.add(r);
        }
        return v;
    }

    public String toString() {
        return this.description;
    }

    public String toStringFull() {
        return super.toString() + " Name=" + this.name + " Value=" + this.value.toString();
    }
}

