/*
 * Decompiled with CFR 0.152.
 */
package common;

import java.io.Serializable;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.Vector;

public class SkillLevelEnum
implements Serializable,
Comparable {
    private static TreeMap VALUE2NAME = new TreeMap();
    private static HashMap NAME2VALUE = new HashMap();
    public static int MIN_VALUE = Integer.MAX_VALUE;
    public static int MAX_VALUE = Integer.MIN_VALUE;
    public static SkillLevelEnum NONE = new SkillLevelEnum(0, "Has no skill");
    public static SkillLevelEnum NOVICE = new SkillLevelEnum(1, "Has novice skill");
    public static SkillLevelEnum SOME = new SkillLevelEnum(2, "Has some skill");
    public static SkillLevelEnum SKILLED = new SkillLevelEnum(3, "Is skilled");
    public static SkillLevelEnum GOOD = new SkillLevelEnum(4, "Has good skill");
    public static SkillLevelEnum VERY = new SkillLevelEnum(5, "Has very good skill");
    public static SkillLevelEnum EXCELLENT = new SkillLevelEnum(6, "Has excellent skill");
    public static SkillLevelEnum EXPERT = new SkillLevelEnum(7, "Is an expert");
    public static SkillLevelEnum INCREDIBLE = new SkillLevelEnum(8, "Has incredible skill");
    public static SkillLevelEnum MASTER = new SkillLevelEnum(9, "Is mastered");
    private Integer value;
    private String name;
    private String description;

    protected SkillLevelEnum(int value, String name) {
        this.value = new Integer(value);
        this.name = name;
        this.description = name;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    protected SkillLevelEnum(int value, String name, String description) {
        this.value = new Integer(value);
        this.name = name;
        this.description = description;
        VALUE2NAME.put(this.value, this);
        NAME2VALUE.put(this.name, this);
        if (value < MIN_VALUE) {
            MIN_VALUE = value;
        }
        if (value > MAX_VALUE) {
            MAX_VALUE = value;
        }
    }

    public static boolean contains(String name) {
        return NAME2VALUE.containsKey(name);
    }

    public static boolean contains(int value) {
        return VALUE2NAME.containsKey(new Integer(value));
    }

    public static int valueOf(String name) {
        return ((SkillLevelEnum)NAME2VALUE.get(name)).value();
    }

    public static String nameOf(int value) {
        return ((SkillLevelEnum)VALUE2NAME.get(new Integer(value))).name();
    }

    public static SkillLevelEnum get(String name) {
        return (SkillLevelEnum)NAME2VALUE.get(name);
    }

    public static SkillLevelEnum get(int value) {
        return (SkillLevelEnum)VALUE2NAME.get(new Integer(value));
    }

    public int value() {
        return this.value;
    }

    public String name() {
        return this.name;
    }

    public int compareTo(Object o) {
        Integer anIntegerValue = ((SkillLevelEnum)o).value;
        return this.value.compareTo(anIntegerValue);
    }

    public static Vector values() {
        Vector<SkillLevelEnum> v = new Vector<SkillLevelEnum>(MAX_VALUE);
        for (int i = MIN_VALUE; i <= MAX_VALUE; ++i) {
            v.add(SkillLevelEnum.get(i));
        }
        return v;
    }

    public String toString() {
        return this.description;
    }

    public String toStringFull() {
        return super.toString() + " Name=" + this.name + " Value=" + this.value.toString();
    }
}

