/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Localizeable;
import common.SkillEnum;
import common.SkillLevelEnum;
import java.util.Iterator;
import java.util.Vector;

public class Skills
extends Vector
implements Localizeable {
    public Skills() {
        super(SkillEnum.size());
        for (int i = 0; i < SkillEnum.size(); ++i) {
            this.add(SkillLevelEnum.NONE);
        }
    }

    public SkillLevelEnum getSkillLevel(SkillEnum skill) {
        return (SkillLevelEnum)this.get(this.toIndexDomain(skill));
    }

    public int getSkill(SkillEnum skill) {
        return ((SkillLevelEnum)this.get(this.toIndexDomain(skill))).value();
    }

    public int getSkill(int skillNumber) {
        return ((SkillLevelEnum)this.get(this.toIndexDomain(skillNumber))).value();
    }

    public void setSkillLevel(SkillEnum skill, SkillLevelEnum level) {
        this.set(this.toIndexDomain(skill), level);
    }

    public void setSkill(SkillEnum skill, int skillLevel) {
        this.set(this.toIndexDomain(skill), this.toEnum(skillLevel));
    }

    public void setSkill(int skillNumber, int skillLevel) {
        this.set(this.toIndexDomain(skillNumber), this.toEnum(skillLevel));
    }

    public Iterator getSkillLevelIterator() {
        return this.iterator();
    }

    public void localize() {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, SkillLevelEnum.get(((SkillLevelEnum)this.get(i)).value()));
        }
    }

    private int toIndexDomain(SkillEnum skill) {
        return skill.value() - SkillEnum.MIN_VALUE;
    }

    private int toIndexDomain(int skillNumber) {
        return skillNumber - SkillEnum.MIN_VALUE;
    }

    private SkillLevelEnum toEnum(int level) {
        SkillLevelEnum l = SkillLevelEnum.get(level);
        if (l == null) {
            throw new RuntimeException("Invalid skill level value " + level);
        }
        return l;
    }
}

